/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.block;

import java.util.Collection;
import java.util.UUID;
import mcmultipart.MCMultiPartMod;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.capabilities.MultipartCapabilityHelper;
import mcmultipart.client.multipart.IFastMSRPart;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.client.multipart.MultipartSpecialRenderer;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartContainer;
import mcmultipart.multipart.PartSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMultipartContainer
extends TileEntity
implements IMultipartContainer,
IMultipartContainer.IMultipartContainerListener {
    private MultipartContainer container;

    public TileMultipartContainer(MultipartContainer container) {
        this.container = new MultipartContainer(this, container.canTurnIntoBlock(), container);
        this.container.setListener(this);
    }

    public TileMultipartContainer() {
        this.container = new MultipartContainer(this, true);
        this.container.setListener(this);
    }

    @Override
    public World getWorldIn() {
        return this.getWorld();
    }

    @Override
    public BlockPos getPosIn() {
        return this.getPos();
    }

    public MultipartContainer getPartContainer() {
        return this.container;
    }

    @Override
    public Collection<? extends IMultipart> getParts() {
        return this.container.getParts();
    }

    @Override
    public ISlottedPart getPartInSlot(PartSlot slot) {
        return this.container.getPartInSlot(slot);
    }

    @Override
    public boolean canAddPart(IMultipart part) {
        return this.container.canAddPart(part);
    }

    @Override
    public boolean canReplacePart(IMultipart oldPart, IMultipart newPart) {
        return this.container.canReplacePart(oldPart, newPart);
    }

    @Override
    public void addPart(IMultipart part) {
        this.container.addPart(part);
    }

    @Override
    public void removePart(IMultipart part) {
        this.container.removePart(part);
    }

    @Override
    public UUID getPartID(IMultipart part) {
        return this.container.getPartID(part);
    }

    @Override
    public IMultipart getPartFromID(UUID id) {
        return this.container.getPartFromID(id);
    }

    @Override
    public void addPart(UUID id, IMultipart part) {
        this.container.addPart(id, part);
    }

    @Override
    public boolean occlusionTest(IMultipart part, IMultipart ... ignored) {
        return this.container.occlusionTest(part, ignored);
    }

    @Override
    public void onAddPartPre(IMultipart part) {
        if (part instanceof ITickable && !(this instanceof ITickable)) {
            this.getWorld().setBlockState(this.getPos(), MCMultiPartMod.multipart.getDefaultState().withProperty(BlockMultipartContainer.PROPERTY_TICKING, (Comparable)Boolean.valueOf(true)));
            TileEntity te = this.getWorld().getTileEntity(this.getPos());
            if (te != null && te instanceof TileMultipartContainer) {
                ((TileMultipartContainer)te).container = this.container;
                this.container.setListener((TileMultipartContainer)te);
            } else {
                throw new RuntimeException("Failed to replace ticking tile!");
            }
        }
    }

    @Override
    public void onAddPartPost(IMultipart part) {
    }

    @Override
    public void onRemovePartPre(IMultipart part) {
        if (part instanceof ITickable && this.getParts().size() > 1) {
            boolean shouldTick = false;
            for (IMultipart iMultipart : this.getParts()) {
                if (iMultipart == part || !(iMultipart instanceof ITickable)) continue;
                shouldTick = true;
                break;
            }
            if (!shouldTick) {
                this.getWorld().setBlockState(this.getPos(), MCMultiPartMod.multipart.getDefaultState().withProperty(BlockMultipartContainer.PROPERTY_TICKING, (Comparable)Boolean.valueOf(false)));
                TileEntity te = this.getWorld().getTileEntity(this.getPos());
                if (te != null && te instanceof TileMultipartContainer) {
                    ((TileMultipartContainer)te).container = this.container;
                    this.container.setListener((TileMultipartContainer)te);
                } else {
                    throw new RuntimeException("Failed to replace ticking tile!");
                }
            }
        }
    }

    @Override
    public void onRemovePartPost(IMultipart part) {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        return MultipartCapabilityHelper.hasCapability(this.container, capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object impl = super.getCapability(capability, facing);
        if (impl != null) {
            return (T)impl;
        }
        return MultipartCapabilityHelper.getCapability(this.container, capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, PartSlot slot, EnumFacing facing) {
        return this.container.hasCapability(capability, slot, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, PartSlot slot, EnumFacing facing) {
        return this.container.getCapability(capability, slot, facing);
    }

    public void onLoad() {
        super.onLoad();
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.onLoaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.onUnloaded();
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        this.container.writeToNBT(compound);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.container.readFromNBT(compound);
    }

    public NBTTagCompound getUpdateTag() {
        return this.container.writeToNBT(super.getUpdateTag());
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), this.getBlockMetadata(), this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bounds = null;
        for (IMultipart iMultipart : this.getParts()) {
            AxisAlignedBB bb = iMultipart.getRenderBoundingBox();
            if (bb == null) continue;
            if (bounds == null) {
                bounds = bb;
                continue;
            }
            bounds = bounds.union(bb);
        }
        if (bounds == null) {
            bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return bounds.offset((double)this.getPosIn().getX(), (double)this.getPosIn().getY(), (double)this.getPosIn().getZ());
    }

    public boolean hasFastRenderer() {
        for (IMultipart iMultipart : this.getParts()) {
            if (this.getSpecialRenderer(iMultipart) == null || iMultipart instanceof IFastMSRPart && ((IFastMSRPart)iMultipart).hasFastRenderer()) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private MultipartSpecialRenderer<?> getSpecialRenderer(IMultipart part) {
        return MultipartRegistryClient.getSpecialRenderer(part);
    }

    public static class Ticking
    extends TileMultipartContainer
    implements ITickable {
        public void update() {
            if (!this.getWorldIn().isRemote && this.getParts().isEmpty()) {
                this.getWorldIn().setBlockToAir(this.getPosIn());
                return;
            }
            for (IMultipart iMultipart : this.getParts()) {
                if (!(iMultipart instanceof ITickable)) continue;
                ((ITickable)iMultipart).update();
            }
        }
    }
}

