/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.client.multipart;

import java.lang.ref.WeakReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AdvancedParticleManager
extends ParticleManager {
    private static AdvancedParticleManager instance;
    private WeakReference<ParticleManager> parent;

    public static AdvancedParticleManager getInstance(ParticleManager particleManager) {
        if (instance == null) {
            instance = new AdvancedParticleManager((World)Minecraft.getMinecraft().theWorld, Minecraft.getMinecraft().renderEngine, particleManager);
            return instance;
        }
        AdvancedParticleManager.instance.worldObj = Minecraft.getMinecraft().theWorld;
        AdvancedParticleManager.instance.parent = new WeakReference<ParticleManager>(particleManager);
        return instance;
    }

    private AdvancedParticleManager(World worldIn, TextureManager rendererIn, ParticleManager parent) {
        super(worldIn, rendererIn);
        this.parent = new WeakReference<ParticleManager>(parent);
    }

    public void addBlockDestroyEffects(BlockPos pos, IBlockState state) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.addBlockDestroyEffects(pos, state);
        }
    }

    public void addBlockDestroyEffects(BlockPos pos, TextureAtlasSprite icon) {
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.getX() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.getY() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.getZ() + ((double)l + 0.5) / (double)i;
                    this.addEffect((Particle)new AdvancedEntityDiggingFX(this.worldObj, d0, d1, d2, d0 - (double)pos.getX() - 0.5, d1 - (double)pos.getY() - 0.5, d2 - (double)pos.getZ() - 0.5, icon).setBlockPos(pos));
                }
            }
        }
    }

    public void addBlockHitEffects(BlockPos pos, EnumFacing side) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.addBlockHitEffects(pos, side);
        }
    }

    public void addBlockHitEffects(BlockPos pos, EnumFacing side, AxisAlignedBB box, TextureAtlasSprite icon) {
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        float f = 0.1f;
        double d0 = (double)i + this.worldObj.rand.nextDouble() * (box.maxX - box.minX - (double)(f * 2.0f)) + (double)f + box.minX;
        double d1 = (double)j + this.worldObj.rand.nextDouble() * (box.maxY - box.maxY - (double)(f * 2.0f)) + (double)f + box.minY;
        double d2 = (double)k + this.worldObj.rand.nextDouble() * (box.maxZ - box.minZ - (double)(f * 2.0f)) + (double)f + box.minZ;
        if (side == EnumFacing.DOWN) {
            d1 = (double)j + box.minY - (double)f;
        }
        if (side == EnumFacing.UP) {
            d1 = (double)j + box.maxY + (double)f;
        }
        if (side == EnumFacing.NORTH) {
            d2 = (double)k + box.minZ - (double)f;
        }
        if (side == EnumFacing.SOUTH) {
            d2 = (double)k + box.maxZ + (double)f;
        }
        if (side == EnumFacing.WEST) {
            d0 = (double)i + box.minX - (double)f;
        }
        if (side == EnumFacing.EAST) {
            d0 = (double)i + box.maxX + (double)f;
        }
        this.addEffect(new AdvancedEntityDiggingFX(this.worldObj, d0, d1, d2, 0.0, 0.0, 0.0, icon).setBlockPos(pos).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
    }

    public void addBlockHitEffects(BlockPos pos, RayTraceResult target) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.addBlockHitEffects(pos, target);
        }
    }

    public void addBlockHitEffects(BlockPos pos, RayTraceResult target, AxisAlignedBB box, TextureAtlasSprite icon) {
        this.addBlockHitEffects(pos, target.sideHit, box, icon);
    }

    public void addEffect(Particle effect) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.addEffect(effect);
        }
    }

    public void clearEffects(World worldIn) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.clearEffects(worldIn);
        }
    }

    public void emitParticleAtEntity(Entity entityIn, EnumParticleTypes particleTypes) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.emitParticleAtEntity(entityIn, particleTypes);
        }
    }

    public String getStatistics() {
        if (this.parent.get() != null) {
            return ((ParticleManager)this.parent.get()).getStatistics();
        }
        return null;
    }

    public void registerParticle(int id, IParticleFactory particleFactory) {
    }

    public void renderLitParticles(Entity entityIn, float p_78872_2_) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.renderLitParticles(entityIn, p_78872_2_);
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.renderParticles(entityIn, partialTicks);
        }
    }

    public Particle spawnEffectParticle(int particleId, double p_178927_2_, double p_178927_4_, double p_178927_6_, double p_178927_8_, double p_178927_10_, double p_178927_12_, int ... p_178927_14_) {
        if (this.parent.get() != null) {
            return ((ParticleManager)this.parent.get()).spawnEffectParticle(particleId, p_178927_2_, p_178927_4_, p_178927_6_, p_178927_8_, p_178927_10_, p_178927_12_, p_178927_14_);
        }
        return null;
    }

    public void updateEffects() {
        ParticleManager p = (ParticleManager)this.parent.get();
        if (p != null) {
            p.updateEffects();
        }
    }

    public static class AdvancedEntityDiggingFX
    extends ParticleDigging {
        protected AdvancedEntityDiggingFX(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, TextureAtlasSprite icon) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, Blocks.STONE.getDefaultState());
            this.setParticleTexture(icon);
        }
    }
}

