/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.client.multipart;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcmultipart.block.BlockCoverable;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.multipart.PartState;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelMultipartContainer
implements IBakedModel {
    final IBakedModel model;
    private final Predicate<BlockRenderLayer> layerFilter;

    public ModelMultipartContainer(IBakedModel model, Predicate<BlockRenderLayer> layerFilter) {
        this.model = model;
        this.layerFilter = layerFilter;
    }

    public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
        if (state == null) {
            if (this.model != null) {
                return this.model.getQuads(state, side, rand);
            }
            return Collections.emptyList();
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (!(state instanceof IExtendedBlockState) || !((IExtendedBlockState)state).getUnlistedProperties().containsKey(BlockMultipartContainer.PROPERTY_MULTIPART_CONTAINER)) {
            if (this.model != null && this.layerFilter.apply((Object)layer)) {
                return this.model.getQuads(state, side, rand);
            }
            return Collections.emptyList();
        }
        List partStates = (List)((IExtendedBlockState)state).getValue(BlockMultipartContainer.PROPERTY_MULTIPART_CONTAINER);
        if (partStates == null) {
            if (this.model != null) {
                this.model.getQuads(state, side, rand);
            }
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (this.model != null && this.layerFilter.apply((Object)layer)) {
            quads.addAll(this.model.getQuads(state, side, rand));
        }
        for (PartState partState : partStates) {
            if (!partState.renderLayers.contains(MinecraftForgeClient.getRenderLayer())) continue;
            ModelResourceLocation modelLocation = new ModelResourceLocation(partState.modelPath, MultipartStateMapper.instance.getPropertyString((Map<IProperty<?>, Comparable<?>>)partState.state.getProperties()));
            IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getModel(modelLocation);
            if (model == null) continue;
            quads.addAll(model.getQuads(partState.state, side, rand));
        }
        return quads;
    }

    public boolean isAmbientOcclusion() {
        return this.model != null ? this.model.isAmbientOcclusion() : true;
    }

    public boolean isGui3d() {
        return this.model != null ? this.model.isGui3d() : false;
    }

    public boolean isBuiltInRenderer() {
        return this.model != null ? this.model.isBuiltInRenderer() : false;
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.model != null ? this.model.getParticleTexture() : Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite("minecraft:blocks/stone");
    }

    public ItemCameraTransforms getItemCameraTransforms() {
        return this.model != null ? this.model.getItemCameraTransforms() : ItemCameraTransforms.DEFAULT;
    }

    public ItemOverrideList getOverrides() {
        return ItemOverrideList.NONE;
    }

    public static ModelMultipartContainer fromBlock(IBakedModel model, final BlockCoverable block) {
        return new ModelMultipartContainer(model, new Predicate<BlockRenderLayer>(){

            public boolean apply(BlockRenderLayer layer) {
                return block.canRenderInLayerDefault(layer);
            }
        });
    }

    public static ModelMultipartContainer fromBlockState(IBakedModel model, final IBlockState state) {
        return new ModelMultipartContainer(model, new Predicate<BlockRenderLayer>(){

            public boolean apply(BlockRenderLayer layer) {
                return ((BlockCoverable)state.getBlock()).canRenderInLayerDefault(state, layer);
            }
        });
    }
}

