/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.client.multipart;

import java.util.Map;
import mcmultipart.block.TileCoverable;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.multipart.IFastMSRPart;
import mcmultipart.client.multipart.ModelMultipartContainer;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.client.multipart.MultipartSpecialRenderer;
import mcmultipart.client.multipart.MultipartStateMapper;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;

public final class MultipartContainerSpecialRenderer {
    private static final EnumFacing[] ALL_ENUM_FACING = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, null};

    public static boolean renderMultipartContainerAt(IMultipartContainer container, double x, double y, double z, float partialTicks, int destroyStage, TileEntityRendererDispatcher rendererDispatcher) {
        MultipartSpecialRenderer<IMultipart> renderer;
        if (destroyStage >= 0) {
            VertexBufferConsumer consumer = new VertexBufferConsumer(Tessellator.getInstance().getBuffer());
            MultipartContainerSpecialRenderer.startBreaking(rendererDispatcher);
            RayTraceResult mop = Minecraft.getMinecraft().objectMouseOver;
            if (mop != null && mop.typeOfHit == RayTraceResult.Type.BLOCK && mop.getBlockPos() != null && mop.getBlockPos().equals((Object)container.getPosIn()) && !(mop instanceof PartMOP)) {
                MultipartContainerSpecialRenderer.renderBreaking(((PartMOP)mop).partHit, (IVertexConsumer)consumer, x, y, z, partialTicks, destroyStage, rendererDispatcher);
            } else {
                for (IMultipart iMultipart : container.getParts()) {
                    MultipartContainerSpecialRenderer.renderBreaking(iMultipart, (IVertexConsumer)consumer, x, y, z, partialTicks, destroyStage, rendererDispatcher);
                }
            }
            MultipartContainerSpecialRenderer.finishBreaking();
            return true;
        }
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer buffer = tessellator.getBuffer();
        rendererDispatcher.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        buffer.begin(7, DefaultVertexFormats.BLOCK);
        for (IMultipart iMultipart : container.getParts()) {
            renderer = MultipartRegistryClient.getSpecialRenderer(iMultipart);
            if (renderer == null || !renderer.shouldRenderInPass(iMultipart, MinecraftForgeClient.getRenderPass()) || !(iMultipart instanceof IFastMSRPart) || !((IFastMSRPart)iMultipart).hasFastRenderer()) continue;
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartFast(iMultipart, x, y, z, partialTicks, destroyStage, buffer);
        }
        buffer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        RenderHelper.enableStandardItemLighting();
        for (IMultipart iMultipart : container.getParts()) {
            renderer = MultipartRegistryClient.getSpecialRenderer(iMultipart);
            if (renderer == null || !renderer.shouldRenderInPass(iMultipart, MinecraftForgeClient.getRenderPass()) || iMultipart instanceof IFastMSRPart && ((IFastMSRPart)iMultipart).hasFastRenderer()) continue;
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartAt(iMultipart, x, y, z, partialTicks, destroyStage);
        }
        return false;
    }

    public static boolean renderMultipartContainerFast(IMultipartContainer container, double x, double y, double z, float partialTicks, int destroyStage, TileEntityRendererDispatcher rendererDispatcher, VertexBuffer buffer) {
        for (IMultipart iMultipart : container.getParts()) {
            MultipartSpecialRenderer<IMultipart> renderer = MultipartRegistryClient.getSpecialRenderer(iMultipart);
            if (renderer == null || !renderer.shouldRenderInPass(iMultipart, MinecraftForgeClient.getRenderPass())) continue;
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartFast(iMultipart, x, y, z, partialTicks, destroyStage, buffer);
        }
        return false;
    }

    private static void startBreaking(TileEntityRendererDispatcher rendererDispatcher) {
        GlStateManager.pushMatrix();
        GlStateManager.tryBlendFuncSeparate((int)774, (int)768, (int)1, (int)0);
        GlStateManager.enableBlend();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.doPolygonOffset((float)-3.0f, (float)-3.0f);
        GlStateManager.enablePolygonOffset();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableAlpha();
        Minecraft.getMinecraft().getTextureManager().getTexture(TextureMap.LOCATION_BLOCKS_TEXTURE).setBlurMipmap(false, false);
    }

    private static void startTessellating(double x, double y, double z) {
        Tessellator.getInstance().getBuffer().begin(7, DefaultVertexFormats.OLDMODEL_POSITION_TEX_NORMAL);
        Tessellator.getInstance().getBuffer().setTranslation(x, y, z);
        Tessellator.getInstance().getBuffer().noColor();
    }

    private static void renderBreaking(IMultipart part, IVertexConsumer consumer, double x, double y, double z, float partialTicks, int destroyStage, TileEntityRendererDispatcher rendererDispatcher) {
        MultipartSpecialRenderer<IMultipart> renderer = MultipartRegistryClient.getSpecialRenderer(part);
        if (renderer != null && renderer.canRenderBreaking(part)) {
            renderer.setRendererDispatcher(rendererDispatcher);
            renderer.renderMultipartAt(part, x, y, z, partialTicks, destroyStage);
        } else if (MinecraftForgeClient.getRenderPass() == 1) {
            IBakedModel model;
            ResourceLocation path = part.getModelPath();
            IBlockState state = part.getExtendedState(MultipartRegistry.getDefaultState(part).getBaseState());
            IBakedModel iBakedModel = model = path == null ? null : Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getModel(new ModelResourceLocation(path, MultipartStateMapper.instance.getPropertyString((Map<IProperty<?>, Comparable<?>>)state.getProperties())));
            if (model != null) {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!part.canRenderInLayer(layer)) continue;
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    IBakedModel layerModel = new SimpleBakedModel.Builder(state, model, Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite("minecraft:blocks/destroy_stage_" + destroyStage), part.getPos()).makeBakedModel();
                    rendererDispatcher.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
                    MultipartContainerSpecialRenderer.startTessellating(x, y, z);
                    consumer = new VertexBufferConsumer(Tessellator.getInstance().getBuffer());
                    MultipartContainerSpecialRenderer.renderBreaking(state, layerModel, consumer);
                    MultipartContainerSpecialRenderer.finishTessellating();
                }
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
            }
        }
    }

    private static void renderBreaking(IBlockState state, IBakedModel model, IVertexConsumer consumer) {
        for (EnumFacing side : ALL_ENUM_FACING) {
            for (BakedQuad quad : model.getQuads(state, side, 0L)) {
                quad.pipe(consumer);
            }
        }
    }

    private static void finishTessellating() {
        Tessellator.getInstance().getBuffer().setTranslation(0.0, 0.0, 0.0);
        Tessellator.getInstance().draw();
    }

    private static void finishBreaking() {
        Minecraft.getMinecraft().getTextureManager().getTexture(TextureMap.LOCATION_BLOCKS_TEXTURE).restoreLastBlurMipmap();
        GlStateManager.disableAlpha();
        GlStateManager.doPolygonOffset((float)0.0f, (float)0.0f);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableAlpha();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
    }

    public static class TileCoverableSpecialRenderer<T extends TileCoverable>
    extends TileEntitySpecialRenderer<T> {
        public void renderTileEntityAt(T te, double x, double y, double z, float partialTicks, int destroyStage) {
            if (destroyStage >= 0) {
                if (MinecraftForgeClient.getRenderPass() != 1) {
                    return;
                }
                RayTraceResult mop = Minecraft.getMinecraft().objectMouseOver;
                if (mop != null && mop.typeOfHit == RayTraceResult.Type.BLOCK && mop.getBlockPos() != null && mop.getBlockPos().equals((Object)((TileCoverable)te).getPosIn()) && !(mop instanceof PartMOP)) {
                    VertexBufferConsumer consumer = new VertexBufferConsumer(Tessellator.getInstance().getBuffer());
                    MultipartContainerSpecialRenderer.startBreaking(this.rendererDispatcher);
                    if (this.canRenderBreaking()) {
                        this.renderTileEntityAtDefault(te, x, y, z, partialTicks, destroyStage);
                    } else {
                        IBlockState state = ((TileCoverable)te).getWorldIn().getBlockState(((TileCoverable)te).getPosIn());
                        IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelForState(te.getBlockType().getActualState(state, (IBlockAccess)((TileCoverable)te).getWorldIn(), ((TileCoverable)te).getPosIn()));
                        if (model != null && model instanceof ModelMultipartContainer) {
                            model = ((ModelMultipartContainer)model).model;
                        }
                        if (model != null) {
                            model = new SimpleBakedModel.Builder(state, model, Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite("minecraft:blocks/destroy_stage_" + destroyStage), ((TileCoverable)te).getPosIn()).makeBakedModel();
                            MultipartContainerSpecialRenderer.startTessellating(x, y, z);
                            MultipartContainerSpecialRenderer.renderBreaking(state, model, (IVertexConsumer)consumer);
                            MultipartContainerSpecialRenderer.finishTessellating();
                        }
                    }
                    MultipartContainerSpecialRenderer.finishBreaking();
                    return;
                }
            }
            if (MultipartContainerSpecialRenderer.renderMultipartContainerAt(((TileCoverable)te).getMicroblockContainer(), x, y, z, partialTicks, destroyStage, this.rendererDispatcher)) {
                return;
            }
            this.renderTileEntityAtDefault(te, x, y, z, partialTicks, destroyStage);
        }

        public void renderTileEntityAtDefault(T te, double x, double y, double z, float partialTicks, int destroyStage) {
        }

        public void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
            if (MultipartContainerSpecialRenderer.renderMultipartContainerFast(((TileCoverable)te).getMicroblockContainer(), x, y, z, partialTicks, destroyStage, this.rendererDispatcher, buffer)) {
                return;
            }
            this.renderTileEntityFastDefault(te, x, y, z, partialTicks, destroyStage, buffer);
        }

        public void renderTileEntityFastDefault(T te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
        }

        public boolean canRenderBreaking() {
            return false;
        }
    }

    public static final class TileMultipartSpecialRenderer
    extends TileEntitySpecialRenderer<TileMultipartContainer> {
        public void renderTileEntityAt(TileMultipartContainer te, double x, double y, double z, float partialTicks, int destroyStage) {
            MultipartContainerSpecialRenderer.renderMultipartContainerAt(te, x, y, z, partialTicks, destroyStage, this.rendererDispatcher);
        }

        public void renderTileEntityFast(TileMultipartContainer te, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
            MultipartContainerSpecialRenderer.renderMultipartContainerFast(te, x, y, z, partialTicks, destroyStage, this.rendererDispatcher, buffer);
        }
    }
}

