/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.client.multipart;

import java.util.HashMap;
import java.util.Map;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.util.ResourceLocation;

public class MultipartStateMapper
extends DefaultStateMapper {
    public static MultipartStateMapper instance = new MultipartStateMapper();
    private boolean replaceNormal = true;

    public Map<IBlockState, ModelResourceLocation> putStateModelLocations(Block blockIn) {
        HashMap<IBlockState, ModelResourceLocation> mappings = new HashMap<IBlockState, ModelResourceLocation>();
        this.replaceNormal = false;
        mappings.putAll(super.putStateModelLocations(blockIn));
        this.replaceNormal = true;
        for (ResourceLocation part : MultipartRegistry.getRegisteredParts()) {
            IStateMapper mapper = MultipartRegistryClient.getSpecialPartStateMapper(part);
            if (mapper != null) {
                mappings.putAll(mapper.putStateModelLocations(blockIn));
                continue;
            }
            BlockStateContainer state = MultipartRegistry.getDefaultState(part);
            ResourceLocation modelPath = MultipartRegistry.getStateLocation(state);
            for (IBlockState istate : state.getValidStates()) {
                mappings.put(istate, new ModelResourceLocation(modelPath, this.getPropertyString((Map<IProperty<?>, Comparable<?>>)istate.getProperties())));
            }
        }
        return mappings;
    }

    public String getPropertyString(Map<IProperty<?>, Comparable<?>> p_178131_1_) {
        String str = super.getPropertyString(p_178131_1_);
        if (this.replaceNormal && str.equals("normal")) {
            return "multipart";
        }
        return str;
    }
}

