/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.item;

import mcmultipart.item.IItemMultipartFactory;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.MultipartHelper;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ItemMultiPart
extends Item
implements IItemMultipartFactory {
    @Override
    public abstract IMultipart createPart(World var1, BlockPos var2, EnumFacing var3, Vec3d var4, ItemStack var5, EntityPlayer var6);

    public boolean place(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        if (!player.canPlayerEdit(pos, side, stack)) {
            return false;
        }
        IMultipart part = this.createPart(world, pos, side, hit, stack, player);
        if (part != null && MultipartHelper.canAddPart(world, pos, part)) {
            if (!world.isRemote) {
                MultipartHelper.addPart(world, pos, part);
            }
            this.consumeItem(stack);
            SoundType sound = this.getPlacementSound(stack);
            if (sound != null) {
                world.playSound(player, pos, sound.getPlaceSound(), SoundCategory.BLOCKS, sound.getVolume(), sound.getPitch());
            }
            return true;
        }
        return false;
    }

    protected void consumeItem(ItemStack stack) {
        --stack.stackSize;
    }

    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Vec3d hit = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        double depth = (hit.xCoord * 2.0 - 1.0) * (double)side.getFrontOffsetX() + (hit.yCoord * 2.0 - 1.0) * (double)side.getFrontOffsetY() + (hit.zCoord * 2.0 - 1.0) * (double)side.getFrontOffsetZ();
        if (depth < 1.0 && this.place(world, pos, side, hit, stack, player)) {
            return EnumActionResult.SUCCESS;
        }
        if (this.place(world, pos.offset(side), side.getOpposite(), hit, stack, player)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public SoundType getPlacementSound(ItemStack stack) {
        return SoundType.GLASS;
    }

    public boolean canItemEditBlocks() {
        return true;
    }
}

