/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.item;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import mcmultipart.item.IItemMultipartFactory;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.network.MessageWrappedPartPlacement;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PartPlacementWrapper {
    private static final Map<String, PartPlacementWrapper> wrappers = new HashMap<String, PartPlacementWrapper>();
    protected final Predicate<ItemStack> match;
    protected final IItemMultipartFactory factory;
    private String identifier;

    public static PartPlacementWrapper getWrapper(String handler) {
        return wrappers.get(handler);
    }

    public PartPlacementWrapper(Predicate<ItemStack> match, IItemMultipartFactory factory) {
        this.match = match;
        this.factory = factory;
    }

    public PartPlacementWrapper(final ItemStack match, IItemMultipartFactory factory) {
        this(new Predicate<ItemStack>(){

            public boolean apply(ItemStack input) {
                return input.isItemEqual(match);
            }
        }, factory);
    }

    public void register(String identifier) {
        this.identifier = identifier;
        wrappers.put(this.identifier, this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected boolean place(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        if (!player.canPlayerEdit(pos, side, stack)) {
            return false;
        }
        IMultipart part = this.factory.createPart(world, pos, side, hit, stack, player);
        if (part == null) {
            return false;
        }
        if (MultipartHelper.canAddPart(world, pos, part)) {
            if (!world.isRemote) {
                MultipartHelper.addPart(world, pos, part);
            }
            if (!player.capabilities.isCreativeMode) {
                this.consumeItem(stack);
            }
            this.playPlacementSound(world, pos, stack, player);
            return true;
        }
        return false;
    }

    protected boolean placeDefault(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        IBlockState iblockstate = world.getBlockState(pos);
        Block block = iblockstate.getBlock();
        Block placedBlock = Block.getBlockFromItem((Item)stack.getItem());
        if (placedBlock == null) {
            throw new IllegalStateException("For non-ItemBlocks you need to write your own default placement handler!");
        }
        if (!block.isReplaceable((IBlockAccess)world, pos)) {
            return false;
        }
        if (stack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(pos, side, stack)) {
            return false;
        }
        if (world.canBlockBePlaced(placedBlock, pos, false, side, (Entity)null, stack)) {
            if (world.isRemote) {
                return true;
            }
            int i = stack.getItem().getMetadata(stack.getMetadata());
            IBlockState iblockstate1 = placedBlock.onBlockPlaced(world, pos, side, (float)hit.xCoord, (float)hit.yCoord, (float)hit.zCoord, i, (EntityLivingBase)player);
            if (((ItemBlock)stack.getItem()).placeBlockAt(stack, player, world, pos, side, (float)hit.xCoord, (float)hit.yCoord, (float)hit.zCoord, iblockstate1)) {
                this.playPlacementSound(world, pos, stack, player);
                if (!player.capabilities.isCreativeMode) {
                    this.consumeItem(stack);
                }
            }
            return true;
        }
        return false;
    }

    protected void consumeItem(ItemStack stack) {
        --stack.stackSize;
    }

    protected void playPlacementSound(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        SoundType sound;
        Block placedBlock = Block.getBlockFromItem((Item)stack.getItem());
        if (placedBlock != null) {
            world.playSound(player, pos, placedBlock.getSoundType().getPlaceSound(), SoundCategory.BLOCKS, (placedBlock.getSoundType().getVolume() + 1.0f) / 2.0f, placedBlock.getSoundType().getPitch() * 0.8f);
        }
        if ((sound = this.getPlacementSound(stack)) != null) {
            world.playSound(player, pos, sound.getPlaceSound(), SoundCategory.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
        }
    }

    protected SoundType getPlacementSound(ItemStack stack) {
        return SoundType.GLASS;
    }

    protected boolean isValidPlacement(World world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EnumHand hand = event.getHand();
        if (hand == null) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().getHeldItem(hand);
        if (stack == null || !this.match.apply((Object)stack)) {
            return;
        }
        event.setCanceled(true);
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumFacing side = event.getFace();
        EntityPlayer player = event.getEntityPlayer();
        RayTraceResult mop = world.rayTraceBlocks(RayTraceUtils.getStart(player), RayTraceUtils.getEnd(player));
        Vec3d hit = mop.hitVec.subtract(new Vec3d((Vec3i)mop.getBlockPos()));
        if (this.doPlace(world, pos, side, hit, stack, player)) {
            player.swingArm(hand);
            if (world.isRemote) {
                new MessageWrappedPartPlacement(this.identifier, hand).send();
            }
        }
    }

    public boolean doPlace(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        if (this.doPlaceAt(world, pos, side, hit, stack, player)) {
            return true;
        }
        pos = pos.offset(side);
        return this.doPlaceAt(world, pos, side, hit, stack, player);
    }

    private boolean doPlaceAt(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        Block block = world.getBlockState(pos).getBlock();
        if (block.isReplaceable((IBlockAccess)world, pos) && this.placeDefault(world, pos, side, hit, stack, player)) {
            return true;
        }
        return this.isValidPlacement(world, pos, side) && this.place(world, pos, side, hit, stack, player);
    }
}

