/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.microblock;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Map;
import mcmultipart.microblock.IMicroMaterial;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.microblock.MicroblockDelegate;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BlockMicroMaterial
implements IMicroMaterial {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<IProperty<?>, Comparable<?>>, String>(){

        public String apply(Map.Entry<IProperty<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            IProperty<?> iproperty = entry.getKey();
            return iproperty.getName() + "=" + iproperty.getName(entry.getValue());
        }
    };
    private final IBlockState blockState;
    private final float hardness;
    private final String name;

    public BlockMicroMaterial(IBlockState blockState) {
        this(blockState, ((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)blockState.getBlock(), (String[])new String[]{"blockHardness", "field_149782_v"})).floatValue());
    }

    public BlockMicroMaterial(IBlockState blockState, float hardness) {
        this.blockState = blockState;
        this.hardness = hardness;
        this.name = this.genName();
    }

    private BlockMicroMaterial(BlockMicroMaterial material) {
        this.blockState = material.blockState;
        this.hardness = material.hardness;
        this.name = material.name;
    }

    private final String genName() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(Block.REGISTRY.getNameForObject((Object)this.blockState.getBlock()));
        if (!this.blockState.getProperties().isEmpty()) {
            stringbuilder.append("[");
            COMMA_JOINER.appendTo(stringbuilder, Iterables.transform((Iterable)this.blockState.getProperties().entrySet(), MAP_ENTRY_TO_STRING));
            stringbuilder.append("]");
        }
        return stringbuilder.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalizedName() {
        return this.getItem().getDisplayName();
    }

    @Override
    public boolean isSolid() {
        return this.blockState.isFullCube();
    }

    @Override
    public int getLightValue() {
        return this.blockState.getLightValue();
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public int getSawStrength() {
        return this.blockState.getBlock().getHarvestLevel(this.blockState);
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack(this.blockState.getBlock(), 1, this.blockState.getBlock().getMetaFromState(this.blockState));
    }

    @Override
    public SoundType getSound() {
        return this.blockState.getBlock().getSoundType();
    }

    @Override
    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return this.blockState.getBlock().canRenderInLayer(this.getDefaultMaterialState(), layer);
    }

    @Override
    public IBlockState getDefaultMaterialState() {
        return this.blockState;
    }

    @Override
    public IBlockState getMaterialState(IBlockAccess world, BlockPos pos, IMicroblock microblock) {
        return this.blockState;
    }

    public DelegatedBlockMicroMaterial withDelegate(Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate> delegateFactory) {
        return new DelegatedBlockMicroMaterial(this, delegateFactory);
    }

    public static class DelegatedBlockMicroMaterial
    extends BlockMicroMaterial
    implements IMicroMaterial.IDelegatedMicroMaterial {
        private final Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate> delegateFactory;

        private DelegatedBlockMicroMaterial(BlockMicroMaterial material, Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate> delegateFactory) {
            super(material);
            this.delegateFactory = delegateFactory;
        }

        @Override
        public MicroblockDelegate provideDelegate(IMicroblock microblock, boolean isRemote) {
            return (MicroblockDelegate)this.delegateFactory.apply((Object)new Tuple((Object)microblock, (Object)isRemote));
        }
    }
}

