/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.microblock;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mcmultipart.microblock.BlockMicroMaterial;
import mcmultipart.microblock.IMicroMaterial;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.microblock.MicroblockClass;
import mcmultipart.microblock.MicroblockDelegate;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;

public class MicroblockRegistry {
    private static final Map<String, IMicroMaterial> materials = new LinkedHashMap<String, IMicroMaterial>();
    private static final Set<MicroblockClass> microClasses = new HashSet<MicroblockClass>();

    public static void registerMicroClass(MicroblockClass microClass) {
        microClasses.add(microClass);
        MultipartRegistry.registerPartFactory(microClass, microClass.getType());
    }

    public static <T extends IMicroMaterial> T registerMaterial(T material) {
        if (material == null) {
            throw new NullPointerException("Attempting to register a null micro material!");
        }
        String name = material.getName();
        if (materials.containsKey(name)) {
            throw new IllegalArgumentException("Attempting to register a micro material with a name that's already in use!");
        }
        materials.put(name, material);
        return material;
    }

    public static BlockMicroMaterial registerMaterial(IBlockState blockState, float hardness) {
        return MicroblockRegistry.registerMaterial(new BlockMicroMaterial(blockState, hardness));
    }

    public static BlockMicroMaterial registerMaterial(IBlockState blockState) {
        return MicroblockRegistry.registerMaterial(new BlockMicroMaterial(blockState));
    }

    public static BlockMicroMaterial registerMaterial(Block block, int meta) {
        return MicroblockRegistry.registerMaterial(block.getStateFromMeta(meta));
    }

    public static BlockMicroMaterial[] registerMaterial(Block block, int fromMeta, int toMeta) {
        BlockMicroMaterial[] materials = new BlockMicroMaterial[toMeta - fromMeta + 1];
        for (int i = fromMeta; i <= toMeta; ++i) {
            materials[i - fromMeta] = MicroblockRegistry.registerMaterial(block, i);
        }
        return materials;
    }

    public static BlockMicroMaterial registerMaterial(Block block) {
        return MicroblockRegistry.registerMaterial(block.getDefaultState());
    }

    public static Collection<IMicroMaterial> getRegisteredMaterials() {
        return Collections.unmodifiableCollection(materials.values());
    }

    public static IMicroMaterial getMaterial(String name) {
        return materials.get(name);
    }

    static {
        MicroblockRegistry.registerMaterial(Blocks.STONE, 0, 6);
        MicroblockRegistry.registerMaterial(Blocks.COBBLESTONE);
        MicroblockRegistry.registerMaterial(Blocks.PLANKS, 0, 5);
        MicroblockRegistry.registerMaterial(Blocks.LAPIS_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.SANDSTONE, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.WOOL, 0, 15);
        MicroblockRegistry.registerMaterial(Blocks.GOLD_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.IRON_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.BRICK_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.BOOKSHELF);
        MicroblockRegistry.registerMaterial(Blocks.MOSSY_COBBLESTONE);
        MicroblockRegistry.registerMaterial(Blocks.OBSIDIAN);
        MicroblockRegistry.registerMaterial(Blocks.DIAMOND_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.PUMPKIN);
        MicroblockRegistry.registerMaterial(Blocks.NETHERRACK);
        MicroblockRegistry.registerMaterial(Blocks.SOUL_SAND);
        MicroblockRegistry.registerMaterial(Blocks.STONEBRICK, 0, 3);
        MicroblockRegistry.registerMaterial(Blocks.NETHER_BRICK);
        MicroblockRegistry.registerMaterial(Blocks.END_STONE);
        MicroblockRegistry.registerMaterial(Blocks.EMERALD_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.QUARTZ_BLOCK, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.STAINED_HARDENED_CLAY, 0, 15);
        MicroblockRegistry.registerMaterial(Blocks.PRISMARINE, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.HAY_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.HARDENED_CLAY);
        MicroblockRegistry.registerMaterial(Blocks.COAL_BLOCK);
        MicroblockRegistry.registerMaterial(Blocks.ICE);
        MicroblockRegistry.registerMaterial(Blocks.PACKED_ICE);
        MicroblockRegistry.registerMaterial(Blocks.RED_SANDSTONE, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.GLASS);
        MicroblockRegistry.registerMaterial((Block)Blocks.STAINED_GLASS, 0, 15);
        MicroblockRegistry.registerMaterial(Blocks.LIT_PUMPKIN);
        MicroblockRegistry.registerMaterial(Blocks.GLOWSTONE);
        MicroblockRegistry.registerMaterial(Blocks.SEA_LANTERN);
        MicroblockRegistry.registerMaterial(Blocks.REDSTONE_BLOCK);
        MicroblockRegistry.registerMaterial(new BlockMicroMaterial(Blocks.CRAFTING_TABLE.getDefaultState()).withDelegate(new Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate>(){

            public MicroblockDelegate apply(Tuple<IMicroblock, Boolean> input) {
                return new CraftingTableMicroblockDelegate((IMicroblock)input.getFirst());
            }
        }));
    }

    private static class InterfaceMicroCraftingTable
    implements IInteractionObject {
        private final IMicroblock microblock;

        public InterfaceMicroCraftingTable(IMicroblock microblock) {
            this.microblock = microblock;
        }

        public String getName() {
            return null;
        }

        public boolean hasCustomName() {
            return false;
        }

        public ITextComponent getDisplayName() {
            return new TextComponentTranslation(Blocks.CRAFTING_TABLE.getUnlocalizedName() + ".name", new Object[0]);
        }

        public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerWorkbench(playerInventory, this.microblock.getWorld(), this.microblock.getPos()){

                public boolean canInteractWith(EntityPlayer player) {
                    BlockPos pos = InterfaceMicroCraftingTable.this.microblock.getPos();
                    return InterfaceMicroCraftingTable.this.microblock.getContainer() == null ? false : player.getDistanceSq((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
                }
            };
        }

        public String getGuiID() {
            return "minecraft:crafting_table";
        }
    }

    private static final class CraftingTableMicroblockDelegate
    extends MicroblockDelegate {
        public CraftingTableMicroblockDelegate(IMicroblock delegated) {
            super(delegated);
        }

        @Override
        public Optional<Boolean> onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
            if (!this.delegated.getWorld().isRemote) {
                player.displayGui((IInteractionObject)new InterfaceMicroCraftingTable(this.delegated));
                player.addStat(StatList.CRAFTING_TABLE_INTERACTION);
            }
            return Optional.of((Object)true);
        }

        @Override
        public void onRemoved() {
        }
    }
}

