/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mcmultipart.MCMultiPartMod;
import mcmultipart.capabilities.PartAttachCapabilitiesEvent;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.OcclusionHelper;
import mcmultipart.network.MessageMultipartChange;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Multipart
implements IMultipart,
ICapabilitySerializable<NBTTagCompound> {
    protected static final AxisAlignedBB DEFAULT_RENDER_BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final ResourceLocation partType = MultipartRegistry.getPartType(this);
    private IMultipartContainer container;
    private final CapabilityDispatcher capabilities;

    public Multipart() {
        PartAttachCapabilitiesEvent event = new PartAttachCapabilitiesEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), null) : null;
    }

    @Override
    public World getWorld() {
        return this.getContainer() != null ? this.getContainer().getWorldIn() : null;
    }

    @Override
    public BlockPos getPos() {
        return this.getContainer() != null ? this.getContainer().getPosIn() : null;
    }

    @Override
    public IMultipartContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(IMultipartContainer container) {
        this.container = container;
    }

    @Override
    public ResourceLocation getType() {
        return this.partType;
    }

    @Override
    public ResourceLocation getModelPath() {
        return this.getType();
    }

    @Override
    public RayTraceUtils.AdvancedRayTraceResultPart collisionRayTrace(Vec3d start, Vec3d end) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        this.addSelectionBoxes(list);
        RayTraceUtils.AdvancedRayTraceResult result = RayTraceUtils.collisionRayTrace(this.getWorld(), this.getPos(), start, end, list);
        return result == null ? null : new RayTraceUtils.AdvancedRayTraceResultPart(result, this);
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
    }

    @Override
    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
    }

    @Override
    public boolean occlusionTest(IMultipart part) {
        return OcclusionHelper.defaultOcclusionTest(this, part);
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return null;
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(new ItemStack[0]);
    }

    @Override
    public void harvest(EntityPlayer player, PartMOP hit) {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        if (!(player != null && player.capabilities.isCreativeMode || world.isRemote || !world.getGameRules().getBoolean("doTileDrops") || world.restoringBlockSnapshots)) {
            for (ItemStack stack : this.getDrops()) {
                EntityItem item = new EntityItem(world, x, y, z, stack);
                item.setDefaultPickupDelay();
                world.spawnEntityInWorld((Entity)item);
            }
        }
        this.getContainer().removePart(this);
    }

    public float getHardness(PartMOP hit) {
        return 0.0f;
    }

    public Material getMaterial() {
        return null;
    }

    public boolean isToolEffective(String type, int level) {
        return true;
    }

    @Override
    public float getStrength(EntityPlayer player, PartMOP hit) {
        boolean effective;
        float hardness = this.getHardness(hit);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (hardness == 0.0f) {
            return 1.0f;
        }
        Material mat = this.getMaterial();
        ItemStack stack = player.getHeldItemMainhand();
        boolean bl = effective = mat == null || mat.isToolNotRequired();
        if (!effective && stack != null) {
            String tool;
            Iterator iterator = stack.getItem().getToolClasses(stack).iterator();
            while (iterator.hasNext() && !(effective = this.isToolEffective(tool = (String)iterator.next(), stack.getItem().getHarvestLevel(stack, tool)))) {
            }
        }
        float breakSpeed = player.getDigSpeed(this.getExtendedState(MultipartRegistry.getDefaultState(this).getBaseState()), this.getPos());
        if (!effective) {
            return breakSpeed / hardness / 100.0f;
        }
        return breakSpeed / hardness / 30.0f;
    }

    @Override
    public void onPartChanged(IMultipart part) {
    }

    @Override
    public void onNeighborBlockChange(Block block) {
    }

    @Override
    public void onNeighborTileChange(EnumFacing facing) {
    }

    @Override
    public void onAdded() {
    }

    @Override
    public void onRemoved() {
    }

    @Override
    public void onLoaded() {
    }

    @Override
    public void onUnloaded() {
    }

    @Override
    public void onConverted(TileEntity tile) {
    }

    @Override
    public boolean rotatePart(EnumFacing axis) {
        return false;
    }

    @Override
    public EnumFacing[] getValidRotations() {
        return null;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
        return false;
    }

    @Override
    public void onClicked(EntityPlayer player, PartMOP hit) {
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
    }

    @Override
    public void readUpdatePacket(PacketBuffer buf) {
    }

    @Override
    public void sendUpdatePacket() {
        this.sendUpdatePacket(this.getModelPath() != null);
    }

    public void sendUpdatePacket(boolean reRender) {
        if (this.getWorld() instanceof WorldServer) {
            MessageMultipartChange.newPacket(this.getWorld(), this.getPos(), this, reRender ? MessageMultipartChange.Type.UPDATE_RERENDER : MessageMultipartChange.Type.UPDATE).send(this.getWorld());
        }
    }

    @Override
    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state) {
        return state;
    }

    @Override
    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return DEFAULT_RENDER_BOUNDS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random rand) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(AdvancedParticleManager particleManager) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(PartMOP hit, AdvancedParticleManager particleManager) {
        return false;
    }

    @Override
    public Boolean isAABBInsideMaterial(AxisAlignedBB aabb, Material material) {
        return null;
    }

    @Override
    public Boolean isEntityInsideMaterial(Entity entity, double yToTest, Material material, boolean testingHead) {
        return null;
    }

    @Override
    public void onEntityCollided(Entity entity) {
    }

    @Override
    public void onEntityStanding(Entity entity) {
    }

    protected void markRenderUpdate() {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        if (world != null) {
            world.markBlockRangeForRenderUpdate(pos, pos);
        }
    }

    protected void markDirty() {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        if (world != null) {
            world.markChunkDirty(pos, null);
            world.updateComparatorOutputLevel(pos, world.getBlockState(pos).getBlock());
        }
    }

    protected void markLightingUpdate() {
        World world = this.getWorld();
        if (world != null) {
            world.checkLight(this.getPos());
        }
    }

    protected void notifyBlockUpdate() {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        if (world != null) {
            world.notifyNeighborsOfStateChange(pos, world.getBlockState(pos).getBlock());
        }
    }

    protected void notifyPartUpdate() {
        IMultipartContainer container = this.getContainer();
        if (container != null) {
            for (IMultipart iMultipart : container.getParts()) {
                iMultipart.onPartChanged(this);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.getCapability(capability, facing) != null) {
            return true;
        }
        return this.capabilities == null ? false : this.capabilities.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        this.writeToNBT(ret);
        return ret;
    }
}

