/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import mcmultipart.capabilities.CapabilityWrapperRegistry;
import mcmultipart.capabilities.ISlottedCapabilityProvider;
import mcmultipart.event.PartEvent;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.ISolidPart;
import mcmultipart.multipart.MultipartRedstoneHelper;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.PartSlot;
import mcmultipart.multipart.PartState;
import mcmultipart.network.MessageMultipartChange;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import mcmultipart.util.IWorldLocation;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultipartContainer
implements IMultipartContainer {
    private IWorldLocation location;
    private IMultipartContainer.IMultipartContainerListener listener;
    private boolean canTurnIntoBlock;
    private BiMap<UUID, IMultipart> partMap = HashBiMap.create();
    private Map<PartSlot, ISlottedPart> slotMap = new HashMap<PartSlot, ISlottedPart>();

    public MultipartContainer(IWorldLocation location, boolean canTurnIntoBlock) {
        this.location = location;
        this.canTurnIntoBlock = canTurnIntoBlock;
    }

    public MultipartContainer(IWorldLocation location, boolean canTurnIntoBlock, MultipartContainer container) {
        this.location = location;
        this.canTurnIntoBlock = canTurnIntoBlock;
        this.partMap = HashBiMap.create(container.partMap);
        this.slotMap = new HashMap<PartSlot, ISlottedPart>(container.slotMap);
        for (IMultipart part : this.partMap.values()) {
            part.setContainer(this);
        }
    }

    public void setListener(IMultipartContainer.IMultipartContainerListener listener) {
        this.listener = listener;
    }

    @Override
    public World getWorldIn() {
        return this.location.getWorldIn();
    }

    @Override
    public BlockPos getPosIn() {
        return this.location.getPosIn();
    }

    public boolean canTurnIntoBlock() {
        return this.canTurnIntoBlock;
    }

    @Override
    public Collection<? extends IMultipart> getParts() {
        return this.partMap.values();
    }

    @Override
    public ISlottedPart getPartInSlot(PartSlot slot) {
        return this.slotMap.get((Object)slot);
    }

    @Override
    public boolean canAddPart(IMultipart part) {
        if (part == null || this.getParts().contains(part)) {
            return false;
        }
        if (part instanceof ISlottedPart) {
            for (PartSlot s : ((ISlottedPart)part).getSlotMask()) {
                if (this.getPartInSlot(s) == null) continue;
                return false;
            }
        }
        if (!this.occlusionTest(part, new IMultipart[0])) {
            return false;
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        part.addCollisionBoxes(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), list, null);
        if (this.getWorldIn() != null && this.getPosIn() != null) {
            for (AxisAlignedBB bb : list) {
                if (this.getWorldIn().checkNoEntityCollision(bb.offset((double)this.getPosIn().getX(), (double)this.getPosIn().getY(), (double)this.getPosIn().getZ()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canReplacePart(IMultipart oldPart, IMultipart newPart) {
        if (oldPart == null) {
            return this.canAddPart(newPart);
        }
        if (newPart == null || this.getParts().contains(newPart)) {
            return false;
        }
        if (newPart instanceof ISlottedPart) {
            for (PartSlot s : ((ISlottedPart)newPart).getSlotMask()) {
                ISlottedPart p = this.getPartInSlot(s);
                if (p == null || p == oldPart) continue;
                return false;
            }
        }
        if (!this.occlusionTest(newPart, oldPart)) {
            return false;
        }
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        newPart.addCollisionBoxes(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), list, null);
        if (this.getWorldIn() != null && this.getPosIn() != null) {
            for (AxisAlignedBB bb : list) {
                if (this.getWorldIn().checkNoEntityCollision(bb.offset((double)this.getPosIn().getX(), (double)this.getPosIn().getY(), (double)this.getPosIn().getZ()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void addPart(IMultipart part) {
        if (this.getWorldIn().isRemote) {
            throw new IllegalStateException("Attempted to add a part on the client!");
        }
        this.addPart(part, true, true, true, true, UUID.randomUUID());
    }

    public void addPart(IMultipart part, boolean notifyPart, boolean notifyNeighbors, boolean tryConvert, boolean postEvent, UUID id) {
        if (part == null) {
            throw new NullPointerException("Attempted to add a null part at " + this.getPosIn());
        }
        if (this.getParts().contains(part)) {
            throw new IllegalArgumentException("Attempted to add a duplicate part at " + this.getPosIn() + " (" + part + ")");
        }
        if (this.listener != null) {
            this.listener.onAddPartPre(part);
        }
        part.setContainer(this);
        HashBiMap partMap = HashBiMap.create(this.partMap);
        HashMap<PartSlot, ISlottedPart> slotMap = new HashMap<PartSlot, ISlottedPart>(this.slotMap);
        partMap.put((Object)id, (Object)part);
        if (part instanceof ISlottedPart) {
            for (PartSlot s : ((ISlottedPart)part).getSlotMask()) {
                slotMap.put(s, (ISlottedPart)part);
            }
        }
        this.partMap = partMap;
        this.slotMap = slotMap;
        if (postEvent) {
            MinecraftForge.EVENT_BUS.post((Event)new PartEvent.Add(part));
        }
        if (notifyPart) {
            part.onAdded();
        }
        if (notifyNeighbors) {
            this.notifyPartChanged(part);
            this.getWorldIn().checkLight(this.getPosIn());
        }
        if (this.listener != null) {
            this.listener.onAddPartPost(part);
        }
        if (!(this.getWorldIn() == null || this.getWorldIn().isRemote || this.canTurnIntoBlock && tryConvert && MultipartRegistry.convertToBlock(this))) {
            MessageMultipartChange.newPacket(this.getWorldIn(), this.getPosIn(), part, MessageMultipartChange.Type.ADD).send(this.getWorldIn());
        }
    }

    @Override
    public void removePart(IMultipart part) {
        this.removePart(part, true, true, true);
    }

    public void removePart(IMultipart part, boolean notifyPart, boolean notifyNeighbors, boolean postEvent) {
        if (part == null) {
            throw new NullPointerException("Attempted to remove a null part from " + this.getPosIn());
        }
        if (!this.getParts().contains(part)) {
            throw new IllegalArgumentException("Attempted to remove a part that doesn't exist from " + this.getPosIn() + " (" + part + ")");
        }
        HashBiMap partMap = HashBiMap.create(this.partMap);
        BiMap<UUID, IMultipart> oldPartMap = this.partMap;
        HashMap<PartSlot, ISlottedPart> slotMap = new HashMap<PartSlot, ISlottedPart>(this.slotMap);
        Map<PartSlot, ISlottedPart> oldSlotMap = this.slotMap;
        if (this.listener != null) {
            this.listener.onRemovePartPre(part);
        }
        partMap.inverse().remove((Object)part);
        if (part instanceof ISlottedPart) {
            Iterator it = slotMap.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue() != part) continue;
                it.remove();
            }
        }
        this.partMap = partMap;
        this.slotMap = slotMap;
        if (postEvent) {
            MinecraftForge.EVENT_BUS.post((Event)new PartEvent.Remove(part));
        }
        if (!(this.getWorldIn() == null || this.getWorldIn().isRemote || this.canTurnIntoBlock && MultipartRegistry.convertToBlock(this))) {
            this.partMap = oldPartMap;
            this.slotMap = oldSlotMap;
            MessageMultipartChange.newPacket(this.getWorldIn(), this.getPosIn(), part, MessageMultipartChange.Type.REMOVE).send(this.getWorldIn());
            this.partMap = partMap;
            this.slotMap = slotMap;
        }
        if (notifyPart) {
            part.onRemoved();
        }
        if (notifyNeighbors) {
            this.notifyPartChanged(part);
            this.getWorldIn().checkLight(this.getPosIn());
        }
        part.setContainer(null);
        if (this.listener != null) {
            this.listener.onRemovePartPost(part);
        }
    }

    @Override
    public UUID getPartID(IMultipart part) {
        return (UUID)this.partMap.inverse().get((Object)part);
    }

    @Override
    public IMultipart getPartFromID(UUID id) {
        return (IMultipart)this.partMap.get((Object)id);
    }

    @Override
    public void addPart(UUID id, IMultipart part) {
        this.addPart(part, true, true, true, true, id);
    }

    @Override
    public boolean occlusionTest(IMultipart part, IMultipart ... ignored) {
        List<IMultipart> ignoredList = Arrays.asList(ignored);
        for (IMultipart iMultipart : this.getParts()) {
            if (ignoredList.contains(iMultipart) || iMultipart.occlusionTest(part) && part.occlusionTest(iMultipart)) continue;
            return false;
        }
        return true;
    }

    public void notifyPartChanged(IMultipart part) {
        for (IMultipart iMultipart : this.getParts()) {
            if (iMultipart == part) continue;
            iMultipart.onPartChanged(part);
        }
        this.getWorldIn().notifyNeighborsOfStateChange(this.getPosIn(), this.getWorldIn().getBlockState(this.getPosIn()).getBlock());
    }

    public RayTraceUtils.AdvancedRayTraceResultPart collisionRayTrace(Vec3d start, Vec3d end) {
        double dist = Double.POSITIVE_INFINITY;
        RayTraceUtils.AdvancedRayTraceResultPart current = null;
        for (IMultipart iMultipart : this.getParts()) {
            double d;
            RayTraceUtils.AdvancedRayTraceResultPart result = iMultipart.collisionRayTrace(start, end);
            if (result == null || !((d = result.squareDistanceTo(start)) <= dist)) continue;
            dist = d;
            current = result;
        }
        return current;
    }

    public void addCollisionBoxes(AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity collidingEntity) {
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.addCollisionBoxes(entityBox, collidingBoxes, collidingEntity);
        }
    }

    public int getLightValue() {
        int max = 0;
        for (IMultipart iMultipart : this.getParts()) {
            max = Math.max(max, iMultipart.getLightValue());
        }
        return max;
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return hit.partHit.getPickBlock(player, hit);
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (IMultipart iMultipart : this.getParts()) {
            list.addAll(iMultipart.getDrops());
        }
        return list;
    }

    public boolean harvest(EntityPlayer player, PartMOP hit) {
        if (this.getWorldIn().isRemote) {
            return false;
        }
        if (hit == null) {
            for (IMultipart iMultipart : this.getParts()) {
                iMultipart.harvest(null, hit);
            }
            return true;
        }
        if (!this.partMap.values().contains(hit.partHit)) {
            return false;
        }
        if (this.getWorldIn().isRemote) {
            return this.getParts().size() - 1 == 0;
        }
        hit.partHit.harvest(player, hit);
        return this.getParts().isEmpty();
    }

    public float getHardness(EntityPlayer player, PartMOP hit) {
        if (!this.partMap.values().contains(hit.partHit)) {
            return -1.0f;
        }
        return hit.partHit.getStrength(player, hit);
    }

    public void onNeighborBlockChange(Block block) {
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.onNeighborBlockChange(block);
        }
    }

    public void onNeighborTileChange(EnumFacing facing) {
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.onNeighborTileChange(facing);
        }
    }

    public boolean onActivated(EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, PartMOP hit) {
        if (hit == null) {
            return false;
        }
        if (!this.partMap.values().contains(hit.partHit)) {
            return false;
        }
        return hit.partHit.onActivated(playerIn, hand, heldItem, hit);
    }

    public void onClicked(EntityPlayer playerIn, PartMOP hit) {
        if (hit == null) {
            return;
        }
        if (!this.partMap.values().contains(hit.partHit)) {
            return;
        }
        hit.partHit.onClicked(playerIn, hit);
    }

    public boolean canConnectRedstone(EnumFacing side) {
        return MultipartRedstoneHelper.canConnectRedstone(this, side);
    }

    public int getWeakSignal(EnumFacing side) {
        return MultipartRedstoneHelper.getWeakSignal(this, side);
    }

    public int getStrongSignal(EnumFacing side) {
        return MultipartRedstoneHelper.getStrongSignal(this, side);
    }

    public boolean isSideSolid(EnumFacing side) {
        ISlottedPart slotPart = this.getPartInSlot(PartSlot.getFaceSlot(side));
        if (slotPart != null && slotPart instanceof ISolidPart) {
            return ((ISolidPart)((Object)slotPart)).isSideSolid(side);
        }
        for (IMultipart iMultipart : this.getParts()) {
            if (iMultipart instanceof ISlottedPart && !((ISlottedPart)iMultipart).getSlotMask().isEmpty() || !(iMultipart instanceof ISolidPart) || !((ISolidPart)iMultipart).isSideSolid(side)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceTorchOnTop() {
        ISlottedPart slotPart = this.getPartInSlot(PartSlot.getFaceSlot(EnumFacing.UP));
        if (slotPart != null && slotPart instanceof ISolidPart.ISolidTopPart) {
            return ((ISolidPart.ISolidTopPart)((Object)slotPart)).canPlaceTorchOnTop();
        }
        for (IMultipart iMultipart : this.getParts()) {
            if (!(iMultipart instanceof ISolidPart.ISolidTopPart) || !((ISolidPart.ISolidTopPart)iMultipart).canPlaceTorchOnTop()) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random rand) {
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.randomDisplayTick(rand);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList partList = new NBTTagList();
        for (Map.Entry entry : this.partMap.entrySet()) {
            NBTTagCompound t = new NBTTagCompound();
            t.setString("__partID", ((UUID)entry.getKey()).toString());
            t.setString("__partType", ((IMultipart)entry.getValue()).getType().toString());
            t = ((IMultipart)entry.getValue()).writeToNBT(t);
            partList.appendTag((NBTBase)t);
        }
        tag.setTag("partList", (NBTBase)partList);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.partMap.clear();
        this.slotMap.clear();
        NBTTagList partList = tag.getTagList("partList", (int)new NBTTagCompound().getId());
        for (int i = 0; i < partList.tagCount(); ++i) {
            NBTTagCompound t = partList.getCompoundTagAt(i);
            UUID id = UUID.fromString(t.getString("__partID"));
            IMultipart part = MultipartRegistry.createPart(new ResourceLocation(t.getString("__partType")), t);
            if (part == null) continue;
            this.addPart(part, false, false, false, false, id);
        }
    }

    public NBTTagCompound writeDescription(NBTTagCompound tag) {
        NBTTagList partList = new NBTTagList();
        for (Map.Entry entry : this.partMap.entrySet()) {
            NBTTagCompound t = new NBTTagCompound();
            t.setString("__partID", ((UUID)entry.getKey()).toString());
            t.setString("__partType", ((IMultipart)entry.getValue()).getType().toString());
            ByteBuf buf = Unpooled.buffer();
            ((IMultipart)entry.getValue()).writeUpdatePacket(new PacketBuffer(buf));
            t.setByteArray("data", buf.array());
            partList.appendTag((NBTBase)t);
        }
        tag.setTag("partList", (NBTBase)partList);
        return tag;
    }

    public void readDescription(NBTTagCompound tag) {
        NBTTagList partList = tag.getTagList("partList", (int)new NBTTagCompound().getId());
        for (int i = 0; i < partList.tagCount(); ++i) {
            NBTTagCompound t = partList.getCompoundTagAt(i);
            UUID id = UUID.fromString(t.getString("__partID"));
            IMultipart part = (IMultipart)this.partMap.get((Object)id);
            if (part == null) {
                part = MultipartRegistry.createPart(new ResourceLocation(t.getString("__partType")), new PacketBuffer(Unpooled.copiedBuffer((byte[])t.getByteArray("data"))));
                this.addPart(part, false, false, false, false, id);
                continue;
            }
            part.readUpdatePacket(new PacketBuffer(Unpooled.copiedBuffer((byte[])t.getByteArray("data"))));
        }
    }

    public List<PartState> getExtendedStates(IBlockAccess world, BlockPos pos) {
        ArrayList<PartState> states = new ArrayList<PartState>();
        for (IMultipart iMultipart : this.getParts()) {
            PartState state = PartState.fromPart(iMultipart);
            if (state == null) continue;
            states.add(state);
        }
        return states;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, PartSlot slot, EnumFacing facing) {
        if (slot == null) {
            for (IMultipart iMultipart : this.getParts()) {
                if (iMultipart instanceof ISlottedPart && !((ISlottedPart)iMultipart).getSlotMask().isEmpty() || !(iMultipart instanceof ICapabilityProvider) || !((ICapabilityProvider)iMultipart).hasCapability(capability, facing)) continue;
                return true;
            }
            return false;
        }
        ISlottedPart part = this.getPartInSlot(slot);
        return part instanceof ISlottedCapabilityProvider ? ((ISlottedCapabilityProvider)((Object)part)).hasCapability(capability, slot, facing) : (part instanceof ICapabilityProvider ? ((ICapabilityProvider)part).hasCapability(capability, facing) : false);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, PartSlot slot, EnumFacing facing) {
        if (slot == null) {
            ArrayList<Object> implementations = new ArrayList<Object>();
            for (IMultipart iMultipart : this.getParts()) {
                Object impl;
                if (iMultipart instanceof ISlottedPart && !((ISlottedPart)iMultipart).getSlotMask().isEmpty() || !(iMultipart instanceof ICapabilityProvider) || (impl = ((ICapabilityProvider)iMultipart).getCapability(capability, facing)) == null) continue;
                implementations.add(impl);
            }
            if (implementations.isEmpty()) {
                return null;
            }
            if (implementations.size() == 1) {
                return (T)implementations.get(0);
            }
            return CapabilityWrapperRegistry.wrap(capability, implementations);
        }
        ISlottedPart part = this.getPartInSlot(slot);
        return (T)(part instanceof ISlottedCapabilityProvider ? (Object)((ISlottedCapabilityProvider)((Object)part)).getCapability(capability, slot, facing) : (part instanceof ICapabilityProvider ? ((ICapabilityProvider)part).getCapability(capability, facing) : null));
    }

    public Boolean isAABBInsideMaterial(AxisAlignedBB aabb, Material material) {
        Boolean def = null;
        for (IMultipart iMultipart : this.getParts()) {
            Boolean is = iMultipart.isAABBInsideMaterial(aabb, material);
            if (is == null) continue;
            if (is.booleanValue()) {
                return true;
            }
            def = false;
        }
        return def;
    }

    public Boolean isEntityInsideMaterial(Entity entity, double yToTest, Material material, boolean testingHead) {
        Boolean def = null;
        for (IMultipart iMultipart : this.getParts()) {
            Boolean is = iMultipart.isEntityInsideMaterial(entity, yToTest, material, testingHead);
            if (is == null) continue;
            if (is.booleanValue()) {
                return true;
            }
            def = false;
        }
        return def;
    }

    public void onEntityStanding(Entity entity) {
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.onEntityStanding(entity);
        }
    }

    public void onEntityCollided(Entity entity) {
        for (IMultipart iMultipart : this.getParts()) {
            iMultipart.onEntityCollided(entity);
        }
    }
}

