/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mcmultipart.MCMultiPartMod;
import mcmultipart.block.BlockMultipartContainer;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.microblock.IMicroblockContainerTile;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartHelper {
    public static boolean canAddPart(World world, BlockPos pos, IMultipart part) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, pos);
        if (container == null) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            part.addCollisionBoxes(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), list, null);
            for (AxisAlignedBB bb : list) {
                if (world.checkNoEntityCollision(bb.offset((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()))) continue;
                return false;
            }
            Collection<? extends IMultipart> parts = MultipartRegistry.convert((IBlockAccess)world, pos, true);
            if (parts != null && !parts.isEmpty()) {
                TileMultipartContainer tmp = new TileMultipartContainer();
                for (IMultipart iMultipart : parts) {
                    tmp.getPartContainer().addPart(iMultipart, false, false, false, false, UUID.randomUUID());
                }
                return tmp.canAddPart(part);
            }
            return world.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)world, pos);
        }
        return container.canAddPart(part);
    }

    public static boolean canReplacePart(World world, BlockPos pos, IMultipart oldPart, IMultipart newPart) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, pos);
        if (container == null) {
            return false;
        }
        return container.canReplacePart(oldPart, newPart);
    }

    public static boolean canReplacePart(World world, BlockPos pos, String oldType, IMultipart newPart) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, pos);
        if (container == null) {
            return false;
        }
        IMultipart oldPart = null;
        for (IMultipart iMultipart : container.getParts()) {
            if (!iMultipart.getType().equals((Object)oldType)) continue;
            oldPart = iMultipart;
            break;
        }
        return container.canReplacePart(oldPart, newPart);
    }

    public static void addPart(World world, BlockPos pos, IMultipart part) {
        MultipartHelper.addPart(world, pos, part, null);
    }

    public static void addPart(World world, BlockPos pos, IMultipart part, UUID id) {
        boolean newContainer;
        IMultipartContainer container = world.isRemote ? MultipartHelper.getPartContainer((IBlockAccess)world, pos) : MultipartHelper.getOrConvertPartContainer(world, pos, true);
        boolean bl = newContainer = container == null;
        if (newContainer) {
            world.setBlockState(pos, MCMultiPartMod.multipart.getDefaultState().withProperty(BlockMultipartContainer.PROPERTY_TICKING, (Comparable)Boolean.valueOf(part instanceof ITickable)));
            TileEntity te = world.getTileEntity(pos);
            if (te instanceof TileMultipartContainer) {
                container = (IMultipartContainer)te;
            }
            if (container == null) {
                container = new TileMultipartContainer();
                world.setTileEntity(pos, (TileEntity)container);
            }
        }
        if (container.getPartFromID(id) != null) {
            return;
        }
        part.setContainer(container);
        if (id != null) {
            container.addPart(id, part);
        } else {
            container.addPart(part);
        }
        if (newContainer) {
            world.notifyLightSet(pos);
        }
    }

    public static boolean addPartIfPossible(World world, BlockPos pos, IMultipart part) {
        if (!MultipartHelper.canAddPart(world, pos, part)) {
            return false;
        }
        MultipartHelper.addPart(world, pos, part);
        return true;
    }

    public static IMultipartContainer getPartContainer(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.getTileEntity(pos);
        if (te == null) {
            return null;
        }
        if (te instanceof IMultipartContainer) {
            return (IMultipartContainer)te;
        }
        if (te instanceof IMicroblockContainerTile) {
            return ((IMicroblockContainerTile)te).getMicroblockContainer();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IMultipartContainer getOrConvertPartContainer(World world, BlockPos pos, boolean doConvert) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, pos);
        if (container != null) {
            return container;
        }
        Collection<? extends IMultipart> parts = MultipartRegistry.convert((IBlockAccess)world, pos, !doConvert);
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        if (doConvert) {
            void var7_12;
            TileEntity oldTile = world.getTileEntity(pos);
            world.setBlockState(pos, MCMultiPartMod.multipart.getDefaultState());
            TileEntity tile = world.getTileEntity(pos);
            Object var7_9 = null;
            if (tile == null || !(tile instanceof TileMultipartContainer)) {
                TileMultipartContainer tileMultipartContainer = new TileMultipartContainer();
                world.setTileEntity(pos, (TileEntity)tileMultipartContainer);
            } else {
                TileMultipartContainer tileMultipartContainer = (TileMultipartContainer)tile;
            }
            for (IMultipart iMultipart : parts) {
                var7_12.getPartContainer().addPart(iMultipart, false, false, false, false, UUID.randomUUID());
            }
            for (IMultipart iMultipart : parts) {
                iMultipart.onConverted(oldTile);
            }
            return var7_12;
        }
        TileMultipartContainer te = new TileMultipartContainer();
        for (IMultipart iMultipart : parts) {
            te.getPartContainer().addPart(iMultipart, false, false, false, false, UUID.randomUUID());
        }
        return te;
    }
}

