/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.ISlotOccludingPart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.PartSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class OcclusionHelper {
    private static final NormallyOccludingPart NOP = new NormallyOccludingPart(new AxisAlignedBB[0]);

    public static boolean defaultOcclusionTest(IMultipart part1, IMultipart part2) {
        if (part1 instanceof INormallyOccludingPart && part2 instanceof INormallyOccludingPart) {
            ArrayList<AxisAlignedBB> boxes1 = new ArrayList<AxisAlignedBB>();
            ArrayList<AxisAlignedBB> boxes2 = new ArrayList<AxisAlignedBB>();
            ((INormallyOccludingPart)part1).addOcclusionBoxes(boxes1);
            ((INormallyOccludingPart)part2).addOcclusionBoxes(boxes2);
            for (AxisAlignedBB a : boxes1) {
                for (AxisAlignedBB b : boxes2) {
                    if (!a.intersectsWith(b)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean occlusionTest(IMultipart part, IMultipart other) {
        return part.occlusionTest(other) && other.occlusionTest(part);
    }

    public static boolean occlusionTest(IMultipart part, IMultipart ... others) {
        return OcclusionHelper.occlusionTest(part, (Predicate<IMultipart>)((Predicate)null), others);
    }

    public static boolean occlusionTest(IMultipart part, Iterable<? extends IMultipart> others) {
        return OcclusionHelper.occlusionTest(part, null, others);
    }

    public static boolean occlusionTest(IMultipart part, IMultipartContainer container) {
        return container.occlusionTest(part, new IMultipart[0]);
    }

    public static boolean occlusionTest(IMultipart part, Predicate<IMultipart> ignored, IMultipart ... others) {
        for (IMultipart other : others) {
            if (ignored != null && ignored.apply((Object)other) || OcclusionHelper.occlusionTest(part, other)) continue;
            return false;
        }
        return true;
    }

    public static boolean occlusionTest(IMultipart part, Predicate<IMultipart> ignored, Iterable<? extends IMultipart> others) {
        for (IMultipart iMultipart : others) {
            if (ignored != null && ignored.apply((Object)iMultipart) || OcclusionHelper.occlusionTest(part, iMultipart)) continue;
            return false;
        }
        return true;
    }

    public static boolean occlusionTest(IMultipart part, Predicate<IMultipart> ignored, IMultipartContainer container) {
        ArrayList<IMultipart> ignoredParts = new ArrayList<IMultipart>();
        for (IMultipart iMultipart : container.getParts()) {
            if (!ignored.apply((Object)iMultipart)) continue;
            ignoredParts.add(iMultipart);
        }
        return container.occlusionTest(part, ignoredParts.toArray(new IMultipart[ignoredParts.size()]));
    }

    public static boolean slotOcclusionTest(PartSlot slot, IMultipart ... parts) {
        return OcclusionHelper.slotOcclusionTest(slot, null, parts);
    }

    public static boolean slotOcclusionTest(PartSlot slot, Iterable<? extends IMultipart> parts) {
        return OcclusionHelper.slotOcclusionTest(slot, null, parts);
    }

    public static boolean slotOcclusionTest(PartSlot slot, IMultipartContainer container) {
        return OcclusionHelper.slotOcclusionTest(slot, null, container.getParts());
    }

    public static boolean slotOcclusionTest(PartSlot slot, Predicate<IMultipart> ignored, IMultipart ... parts) {
        for (IMultipart part : parts) {
            if (ignored != null && ignored.apply((Object)part) || (!(part instanceof ISlottedPart) || !((ISlottedPart)part).getSlotMask().contains((Object)slot)) && (!(part instanceof ISlotOccludingPart) || !((ISlotOccludingPart)part).getOccludedSlots().contains((Object)slot))) continue;
            return false;
        }
        return true;
    }

    public static boolean slotOcclusionTest(PartSlot slot, Predicate<IMultipart> ignored, Iterable<? extends IMultipart> parts) {
        for (IMultipart iMultipart : parts) {
            if (ignored != null && ignored.apply((Object)iMultipart) || (!(iMultipart instanceof ISlottedPart) || !((ISlottedPart)iMultipart).getSlotMask().contains((Object)slot)) && (!(iMultipart instanceof ISlotOccludingPart) || !((ISlotOccludingPart)iMultipart).getOccludedSlots().contains((Object)slot))) continue;
            return false;
        }
        return true;
    }

    public static boolean slotOcclusionTest(PartSlot slot, Predicate<IMultipart> ignored, IMultipartContainer container) {
        return OcclusionHelper.slotOcclusionTest(slot, ignored, container.getParts());
    }

    public static Predicate<IMultipart> ignore(final IMultipart ... parts) {
        return new Predicate<IMultipart>(){

            public boolean apply(IMultipart input) {
                for (IMultipart p : parts) {
                    if (input != p) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<IMultipart> ignore(final Iterable<IMultipart> parts) {
        return new Predicate<IMultipart>(){

            public boolean apply(IMultipart input) {
                for (IMultipart p : parts) {
                    if (input != p) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static NormallyOccludingPart boxes(AxisAlignedBB ... boxes) {
        return NOP.setBoxes(boxes);
    }

    public static NormallyOccludingPart boxes(Iterable<AxisAlignedBB> boxes) {
        return NOP.setBoxes(boxes);
    }

    @Deprecated
    public static boolean occlusionTest(IMultipart part, Iterable<? extends IMultipart> parts, IMultipart ... ignored) {
        return OcclusionHelper.occlusionTest(part, OcclusionHelper.ignore(ignored), parts);
    }

    @Deprecated
    public static boolean occlusionTest(IMultipart part, IMultipartContainer container, IMultipart ... ignored) {
        return OcclusionHelper.occlusionTest(part, OcclusionHelper.ignore(ignored), container);
    }

    @Deprecated
    public static boolean occlusionTest(IMultipart part, Iterable<? extends IMultipart> parts, Predicate<IMultipart> ignored) {
        return OcclusionHelper.occlusionTest(part, ignored, parts);
    }

    @Deprecated
    public static boolean occlusionTest(IMultipart part, AxisAlignedBB ... boxes) {
        return OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes(boxes), part);
    }

    @Deprecated
    public static boolean occlusionTest(Iterable<? extends IMultipart> parts, AxisAlignedBB ... boxes) {
        return OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes(boxes), parts);
    }

    @Deprecated
    public static boolean occlusionTest(Iterable<? extends IMultipart> parts, Predicate<IMultipart> ignored, AxisAlignedBB ... boxes) {
        return OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes(boxes), ignored, parts);
    }

    @Deprecated
    public static boolean isSlotOccluded(IMultipartContainer container, PartSlot slot, IMultipart ... ignored) {
        return !OcclusionHelper.slotOcclusionTest(slot, OcclusionHelper.ignore(ignored), container);
    }

    @Deprecated
    public static boolean isSlotOccluded(Iterable<? extends IMultipart> parts, PartSlot slot, IMultipart ... ignored) {
        return !OcclusionHelper.slotOcclusionTest(slot, OcclusionHelper.ignore(ignored), parts);
    }

    @Deprecated
    public static boolean isSlotOccluded(Iterable<? extends IMultipart> parts, PartSlot slot, Predicate<IMultipart> ignored) {
        return !OcclusionHelper.slotOcclusionTest(slot, ignored, parts);
    }

    public static class NormallyOccludingPart
    extends Multipart
    implements INormallyOccludingPart {
        private AxisAlignedBB[] boxArray;
        private Iterable<AxisAlignedBB> boxIterable;

        public NormallyOccludingPart(Iterable<AxisAlignedBB> boxes) {
            this.boxIterable = boxes;
        }

        public NormallyOccludingPart(AxisAlignedBB ... boxes) {
            this.boxArray = boxes;
        }

        @Override
        public ResourceLocation getType() {
            return null;
        }

        @Override
        public void addOcclusionBoxes(List<AxisAlignedBB> list) {
            if (this.boxArray != null) {
                for (AxisAlignedBB bb : this.boxArray) {
                    list.add(bb);
                }
            }
            if (this.boxIterable != null) {
                for (AxisAlignedBB bb : this.boxIterable) {
                    list.add(bb);
                }
            }
        }

        public NormallyOccludingPart setBoxes(Iterable<AxisAlignedBB> boxes) {
            this.boxIterable = boxes;
            this.boxArray = null;
            return this;
        }

        public NormallyOccludingPart setBoxes(AxisAlignedBB ... boxes) {
            this.boxIterable = null;
            this.boxArray = boxes;
            return this;
        }
    }
}

