package net.minecraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAnvil extends BlockFalling
{
    public static final String[] field_149834_a = new String[] {"intact", "slightlyDamaged", "veryDamaged"};
    private static final String[] field_149835_N = new String[] {"anvil_top_damaged_0", "anvil_top_damaged_1", "anvil_top_damaged_2"};
    @SideOnly(Side.CLIENT)
    public int field_149833_b;
    @SideOnly(Side.CLIENT)
    private IIcon[] field_149836_O;
    private static final String __OBFID = "CL_00000192";

    protected BlockAnvil()
    {
        super(Material.field_151574_g);
        this.func_149713_g(0);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public boolean func_149686_d()
    {
        return false;
    }

    public boolean func_149662_c()
    {
        return false;
    }

    @SideOnly(Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_)
    {
        if (this.field_149833_b == 3 && p_149691_1_ == 1)
        {
            int k = (p_149691_2_ >> 2) % this.field_149836_O.length;
            return this.field_149836_O[k];
        }
        else
        {
            return this.field_149761_L;
        }
    }

    @SideOnly(Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_)
    {
        this.field_149761_L = p_149651_1_.func_94245_a("anvil_base");
        this.field_149836_O = new IIcon[field_149835_N.length];

        for (int i = 0; i < this.field_149836_O.length; ++i)
        {
            this.field_149836_O[i] = p_149651_1_.func_94245_a(field_149835_N[i]);
        }
    }

    public void func_149689_a(World p_149689_1_, int p_149689_2_, int p_149689_3_, int p_149689_4_, EntityLivingBase p_149689_5_, ItemStack p_149689_6_)
    {
        int l = MathHelper.func_76128_c((double)(p_149689_5_.field_70177_z * 4.0F / 360.0F) + 0.5D) & 3;
        int i1 = p_149689_1_.func_72805_g(p_149689_2_, p_149689_3_, p_149689_4_) >> 2;
        ++l;
        l %= 4;

        if (l == 0)
        {
            p_149689_1_.func_72921_c(p_149689_2_, p_149689_3_, p_149689_4_, 2 | i1 << 2, 2);
        }

        if (l == 1)
        {
            p_149689_1_.func_72921_c(p_149689_2_, p_149689_3_, p_149689_4_, 3 | i1 << 2, 2);
        }

        if (l == 2)
        {
            p_149689_1_.func_72921_c(p_149689_2_, p_149689_3_, p_149689_4_, 0 | i1 << 2, 2);
        }

        if (l == 3)
        {
            p_149689_1_.func_72921_c(p_149689_2_, p_149689_3_, p_149689_4_, 1 | i1 << 2, 2);
        }
    }

    public boolean func_149727_a(World p_149727_1_, int p_149727_2_, int p_149727_3_, int p_149727_4_, EntityPlayer p_149727_5_, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_)
    {
        if (p_149727_1_.field_72995_K)
        {
            return true;
        }
        else
        {
            p_149727_5_.func_82244_d(p_149727_2_, p_149727_3_, p_149727_4_);
            return true;
        }
    }

    public int func_149645_b()
    {
        return 35;
    }

    public int func_149692_a(int p_149692_1_)
    {
        return p_149692_1_ >> 2;
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_)
    {
        int l = p_149719_1_.func_72805_g(p_149719_2_, p_149719_3_, p_149719_4_) & 3;

        if (l != 3 && l != 1)
        {
            this.func_149676_a(0.125F, 0.0F, 0.0F, 0.875F, 1.0F, 1.0F);
        }
        else
        {
            this.func_149676_a(0.0F, 0.0F, 0.125F, 1.0F, 1.0F, 0.875F);
        }
    }

    @SideOnly(Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_)
    {
        p_149666_3_.add(new ItemStack(p_149666_1_, 1, 0));
        p_149666_3_.add(new ItemStack(p_149666_1_, 1, 1));
        p_149666_3_.add(new ItemStack(p_149666_1_, 1, 2));
    }

    protected void func_149829_a(EntityFallingBlock p_149829_1_)
    {
        p_149829_1_.func_145806_a(true);
    }

    public void func_149828_a(World p_149828_1_, int p_149828_2_, int p_149828_3_, int p_149828_4_, int p_149828_5_)
    {
        p_149828_1_.func_72926_e(1022, p_149828_2_, p_149828_3_, p_149828_4_, 0);
    }

    @SideOnly(Side.CLIENT)
    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_)
    {
        return true;
    }
}