/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.omniconfig.api;

import io.github.crucible.omniconfig.OmniconfigCore;
import io.github.crucible.omniconfig.api.annotation.IAnnotationConfigRegistry;
import io.github.crucible.omniconfig.api.builders.IOmniconfigBuilder;
import io.github.crucible.omniconfig.api.core.IOmniconfigRegistry;
import io.github.crucible.omniconfig.api.core.SidedConfigType;
import io.github.crucible.omniconfig.api.lib.Version;
import io.github.crucible.omniconfig.core.Omniconfig;
import io.github.crucible.omniconfig.core.OmniconfigRegistry;
import io.github.crucible.omniconfig.gconfig.AnnotationConfigCore;
import java.io.File;

public class OmniconfigAPI {
    private OmniconfigAPI() {
    }

    public static IOmniconfigBuilder configBuilder(String fileName) {
        return Omniconfig.builder((String)OmniconfigCore.INSTANCE.sanitizeName(fileName), (Version)new Version("1.0.0"), (boolean)true, (SidedConfigType)SidedConfigType.COMMON);
    }

    public static IOmniconfigBuilder configBuilder(String fileName, Version version) {
        return Omniconfig.builder((String)OmniconfigCore.INSTANCE.sanitizeName(fileName), (Version)version, (boolean)true, (SidedConfigType)SidedConfigType.COMMON);
    }

    public static IOmniconfigBuilder configBuilder(String fileName, Version version, SidedConfigType sidedType) {
        return Omniconfig.builder((String)OmniconfigCore.INSTANCE.sanitizeName(fileName), (Version)version, (boolean)true, (SidedConfigType)sidedType);
    }

    public static void registerAnnotationConfig(Class<?> annotationConfigClass) {
        AnnotationConfigCore.INSTANCE.addAnnotationConfig(annotationConfigClass);
    }

    public static IOmniconfigRegistry getOmniconfigRegistry() {
        return OmniconfigRegistry.INSTANCE;
    }

    public static IAnnotationConfigRegistry getAnnotationConfigRegistry() {
        return AnnotationConfigCore.INSTANCE;
    }

    public static File getConfigFolder() {
        return OmniconfigCore.CONFIG_DIR;
    }
}

