/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.common.core;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.github.crucible.grimoire.common.GrimoireCore;
import io.github.crucible.grimoire.common.GrimoireInternals;
import io.github.crucible.grimoire.common.api.GrimoireAPI;
import io.github.crucible.grimoire.common.api.eventbus.CoreEvent;
import io.github.crucible.grimoire.common.api.eventbus.CoreEventBus;
import io.github.crucible.grimoire.common.api.eventbus.CoreEventHandler;
import io.github.crucible.grimoire.common.api.events.configurations.GrimoireConfigsEvent;
import io.github.crucible.grimoire.common.api.grimmix.GrimmixController;
import io.github.crucible.grimoire.common.api.grimmix.IGrimmix;
import io.github.crucible.grimoire.common.api.grimmix.lifecycle.LoadingStage;
import io.github.crucible.grimoire.common.api.mixin.ConfigurationType;
import io.github.crucible.grimoire.common.api.mixin.IMixinConfiguration;
import io.github.crucible.grimoire.common.core.DeserializedMixinJson;
import io.github.crucible.grimoire.common.core.GrimmixContainer;
import io.github.crucible.grimoire.common.core.GrimoireAnnotationAnalyzer;
import io.github.crucible.grimoire.common.core.MixinConfiguration;
import io.github.crucible.grimoire.common.core.runtimeconfig.ConfigBuildingManager;
import io.github.crucible.grimoire.common.modules.ForceLoadController;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.service.MixinService;

public class GrimmixLoader {
    public static Pattern classFile = Pattern.compile("[^\\s\\$]+(\\$[^\\s]+)?\\.class$");
    public static final GrimmixLoader INSTANCE = new GrimmixLoader();
    protected final List<GrimmixContainer> containerList = new ArrayList<GrimmixContainer>();
    protected final List<GrimmixContainer> activeContainerList = new ArrayList<GrimmixContainer>();
    protected final List<Class<?>> staticEventHandlers = new ArrayList();
    protected final List<IMixinConfiguration> preparedConfigs = new ArrayList<IMixinConfiguration>();
    protected LoadingStage internalStage = LoadingStage.PRE_CONSTRUCTION;
    protected GrimmixContainer activeContainer = null;
    protected boolean finishedScan = false;

    public boolean isGrimmix(String fileName) {
        for (GrimmixContainer grimmix : this.containerList) {
            if (!grimmix.getGrimmixFile().getName().equals(fileName) || grimmix.wasOnClasspath()) continue;
            return true;
        }
        return false;
    }

    public LoadingStage getInternalStage() {
        return this.internalStage;
    }

    @Nullable
    public GrimmixContainer getActiveContainer() {
        return this.activeContainer;
    }

    public List<GrimmixContainer> getAllContainers() {
        return Collections.unmodifiableList(this.containerList);
    }

    public List<IGrimmix> getAllActiveContainers() {
        return Collections.unmodifiableList(this.activeContainerList);
    }

    private boolean isClassFile(String fileName) {
        return classFile.matcher(fileName).matches();
    }

    private boolean isJson(String fileName) {
        String splitName = fileName.contains("/") ? fileName.substring(fileName.lastIndexOf("/")).replace("/", "") : fileName;
        return splitName.endsWith(".json");
    }

    @Nullable
    private InputStream tryGetInputStream(ZipFile file, ZipEntry entry) {
        try {
            InputStream stream = file.getInputStream(entry);
            return stream;
        }
        catch (IOException ex) {
            Throwables.propagate((Throwable)ex);
            return null;
        }
    }

    @Nullable
    private InputStream tryGetInputStream(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            return stream;
        }
        catch (IOException ex) {
            Throwables.propagate((Throwable)ex);
            return null;
        }
    }

    private boolean examineForAnnotations(File file, List<GrimoireAnnotationAnalyzer.GrimmixCandidate> candidates, List<GrimoireAnnotationAnalyzer.EventHandlerCandidate> handlers, List<String> configList, String recursivePath) {
        boolean hadForcedConfigurations = false;
        if (file.isDirectory()) {
            String newPath = recursivePath == null ? "" : recursivePath + file.getName() + File.separator;
            for (File newFile : file.listFiles()) {
                this.examineForAnnotations(newFile, candidates, handlers, configList, newPath);
            }
        } else if (file.getName().endsWith(".jar")) {
            try {
                JarFile jar = new JarFile(file);
                for (ZipEntry zipEntry : Collections.list(jar.entries())) {
                    DeserializedMixinJson json;
                    if (this.isClassFile(zipEntry.getName())) {
                        GrimoireAnnotationAnalyzer analyzer = GrimoireAnnotationAnalyzer.examineClass(jar, zipEntry);
                        if (analyzer.getGrimmixCandidate().validate()) {
                            candidates.add(analyzer.getGrimmixCandidate());
                        }
                        if (!analyzer.getHandlerCandidate().validate()) continue;
                        handlers.add(analyzer.getHandlerCandidate());
                        continue;
                    }
                    if (!this.isJson(zipEntry.getName()) || (json = DeserializedMixinJson.deserialize(() -> this.tryGetInputStream(jar, ze))) == null || !json.isValidConfiguration()) continue;
                    if (json.getForceLoadType() != null) {
                        hadForcedConfigurations = true;
                        ForceLoadController.addForcedConfiguration(json.getForceLoadType(), zipEntry.getName());
                        continue;
                    }
                    configList.add(zipEntry.getName());
                }
                jar.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.isClassFile(file.getName())) {
            GrimoireAnnotationAnalyzer analyzer = GrimoireAnnotationAnalyzer.examineClass(file);
            if (analyzer.getGrimmixCandidate().validate()) {
                candidates.add(analyzer.getGrimmixCandidate());
            }
            if (analyzer.getHandlerCandidate().validate()) {
                handlers.add(analyzer.getHandlerCandidate());
            }
        } else if (this.isJson(file.getName())) {
            DeserializedMixinJson json = DeserializedMixinJson.deserialize(() -> this.tryGetInputStream(file));
            String cfgPath = recursivePath + file.getName();
            cfgPath = cfgPath.replace(File.separator, "/");
            if (json != null && json.isValidConfiguration()) {
                if (json.getForceLoadType() != null) {
                    hadForcedConfigurations = true;
                    ForceLoadController.addForcedConfiguration(json.getForceLoadType(), cfgPath);
                } else {
                    configList.add(cfgPath);
                }
            }
        }
        return hadForcedConfigurations;
    }

    protected void seekGrimmixes(Collection<URL> paths, @Nullable LaunchClassLoader classLoader, boolean ignoreFolders) {
        for (URL url : paths) {
            try {
                String isGrimoireAttribute;
                URI uri = url.toURI();
                if (!"file".equals(uri.getScheme()) || !new File(uri).exists()) continue;
                File candidateFile = new File(url.toURI().getPath());
                Manifest manifest = null;
                boolean isDirectory = candidateFile.isDirectory();
                GrimoireCore.logger.info("Scanning {} {} for grimmix controllers...", new Object[]{isDirectory ? "directory" : "file", GrimoireInternals.sanitizePath(uri.toString())});
                if (isDirectory) {
                    if (ignoreFolders) continue;
                    File manifestFile = new File(candidateFile, "META-INF/MANIFEST.MF");
                    if (manifestFile.exists()) {
                        FileInputStream stream = new FileInputStream(manifestFile);
                        manifest = new Manifest(stream);
                        stream.close();
                    }
                } else if (candidateFile.getName().endsWith("jar")) {
                    JarFile jar = new JarFile(candidateFile);
                    manifest = jar.getManifest();
                    jar.close();
                }
                boolean isGrimoireGrimmix = false;
                if (manifest != null && Objects.equal((Object)(isGrimoireAttribute = manifest.getMainAttributes().getValue("IsThatYouGrimoire")), (Object)"Indeed")) {
                    isGrimoireGrimmix = true;
                }
                ArrayList<GrimoireAnnotationAnalyzer.GrimmixCandidate> candidateList = new ArrayList<GrimoireAnnotationAnalyzer.GrimmixCandidate>();
                ArrayList<GrimoireAnnotationAnalyzer.EventHandlerCandidate> handlerList = new ArrayList<GrimoireAnnotationAnalyzer.EventHandlerCandidate>();
                ArrayList<String> configList = new ArrayList<String>();
                boolean hadForcedConfigurations = this.examineForAnnotations(candidateFile, candidateList, handlerList, configList, null);
                boolean alreadyThere = false;
                if (classLoader != null && !candidateFile.isDirectory() && (candidateList.size() > 0 || handlerList.size() > 0 || hadForcedConfigurations)) {
                    for (URL classURL : classLoader.getURLs()) {
                        if (!url.equals(classURL)) continue;
                        alreadyThere = true;
                        break;
                    }
                    if (!alreadyThere) {
                        GrimoireCore.logger.info("Adding location: {} to java classpath, not there yet", new Object[]{url.toString().replaceAll("%20", " ")});
                        classLoader.addURL(url);
                        GrimoireCore.INSTANCE.getForcedFilenames().add(candidateFile.getName());
                    }
                }
                for (GrimoireAnnotationAnalyzer.GrimmixCandidate candidate2 : candidateList) {
                    try {
                        Class<?> controllerClass = Class.forName(candidate2.getClassName());
                        if (!GrimmixController.class.isAssignableFrom(controllerClass)) {
                            throw new RuntimeException("Invalid @Grimmix annotation target: " + candidate2.getClassName() + ". All targets of @Grimmix annotation must have GrimmixController in superclasss hierarchy!");
                        }
                        Constructor<?> controllerConstructor = controllerClass.getConstructor(new Class[0]);
                        controllerConstructor.setAccessible(true);
                        GrimmixContainer container = new GrimmixContainer(candidateFile, controllerConstructor, new ArrayList<String>(configList), isGrimoireGrimmix, alreadyThere);
                        this.containerList.add(container);
                        this.activeContainerList.add(container);
                        GrimoireCore.logger.info("Configuration candidates for {} Grimmix {}: {}", new Object[]{isGrimoireGrimmix ? "integrated" : "external", candidate2.getClassName(), configList});
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Failed to collect controller constructor: " + candidate2.getClassName(), ex);
                    }
                }
                if (handlerList.size() <= 0) continue;
                handlerList.forEach(candidate -> {
                    try {
                        Class<?> handlerClass = Class.forName(candidate.getClassName());
                        this.staticEventHandlers.add(handlerClass);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw new RuntimeException(e);
                }
                e.printStackTrace();
            }
        }
    }

    public void scanForGrimmixes(@Nullable LaunchClassLoader classLoader, File ... directories) {
        if (this.finishedScan) {
            return;
        }
        GrimoireCore.logger.info("Scanning for @Grimmix controllers in following locations: ");
        if (classLoader != null) {
            GrimoireCore.logger.info("Location: Java Classpath");
        }
        for (File file : directories) {
            try {
                GrimoireCore.logger.info("Location: " + GrimoireInternals.sanitizePath(file.getCanonicalFile().toURI().toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList classUrls = new ArrayList();
        if (classLoader != null) {
            classUrls = Lists.newArrayList((Object[])MixinService.getService().getClassProvider().getClassPath());
            this.seekGrimmixes(classUrls, null, false);
        }
        ArrayList<URL> fileURLs = new ArrayList<URL>();
        for (File dir : directories) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            for (File mod : FileUtils.listFiles(dir, new String[]{"jar"}, true)) {
                try {
                    URL fileURL = mod.getCanonicalFile().toURI().toURL();
                    if (classUrls.contains(fileURL)) continue;
                    fileURLs.add(fileURL);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (fileURLs.size() > 0) {
            this.seekGrimmixes(fileURLs, classLoader, true);
        }
        for (Class clazz : this.staticEventHandlers) {
            String[] busNames;
            CoreEventHandler annotation = clazz.getAnnotation(CoreEventHandler.class);
            if (annotation == null) continue;
            for (String busName : busNames = annotation.value()) {
                Optional<CoreEventBus<CoreEvent>> maybeBus = CoreEventBus.findBus(busName);
                if (!maybeBus.isPresent() && annotation.mandatory()) {
                    throw new NoSuchElementException("Could not locate EventBus with name: " + busName + ", required by static handler: " + clazz);
                }
                maybeBus.ifPresent(bus -> {
                    bus.register(handlerClass);
                    GrimoireCore.logger.info("Successfully subscribed annotated static handler {} to event bus {}", new Object[]{handlerClass, busName});
                });
            }
        }
        this.finishedScan = true;
    }

    public void construct() {
        this.transition(LoadingStage.CONSTRUCTION);
    }

    public void validate() {
        this.transition(LoadingStage.VALIDATION, true);
    }

    public void buildRuntimeConfigs() {
        this.transition(LoadingStage.MIXIN_CONFIG_BUILDING);
    }

    public void prepareCoreConfigs() {
        this.transition(LoadingStage.CORELOAD);
    }

    public void loadCoreConfigs() {
        this.loadConfigs(ConfigurationType.CORE);
    }

    public void prepareModConfigs() {
        this.transition(LoadingStage.MODLOAD);
    }

    public void loadModConfigs() {
        this.loadConfigs(ConfigurationType.MOD);
    }

    private void loadConfigs(ConfigurationType type) {
        GrimoireConfigsEvent.Pre event = new GrimoireConfigsEvent.Pre(this.preparedConfigs, type.getAssociatedLoadingStage());
        GrimoireAPI.EVENT_BUS.post(event);
        if (!event.isCanceled()) {
            for (IMixinConfiguration config : event.getPreparedConfigurations()) {
                ((MixinConfiguration)config).load();
            }
        }
        GrimoireAPI.EVENT_BUS.post(new GrimoireConfigsEvent.Post(event.getPreparedConfigurations(), type.getAssociatedLoadingStage()));
        this.preparedConfigs.clear();
    }

    public void finish() {
        this.transition(LoadingStage.FINAL);
    }

    public List<IMixinConfiguration> getPreparedConfigs() {
        return Collections.unmodifiableList(this.preparedConfigs);
    }

    protected void transition(LoadingStage to) {
        this.transition(to, false, null);
    }

    protected void transition(LoadingStage to, boolean dropOnCancel) {
        this.transition(to, dropOnCancel, null);
    }

    protected void transition(LoadingStage to, boolean dropOnCancel, Consumer<GrimmixContainer> beforeEach) {
        if (this.internalStage.ordinal() + 1 != to.ordinal()) {
            throw new IllegalStateException("Cannot transition from " + (Object)((Object)this.internalStage) + " to " + (Object)((Object)to));
        }
        GrimoireCore.logger.info("Transitioning from loading stage {} to stage {}...", new Object[]{this.internalStage, to});
        this.internalStage = to;
        this.preparedConfigs.clear();
        this.activeContainerList.removeIf(container -> {
            boolean valid;
            this.activeContainer = container;
            if (beforeEach != null) {
                beforeEach.accept((GrimmixContainer)container);
            }
            if ((valid = container.transition(to)) && to.isConfigurationStage()) {
                this.preparedConfigs.addAll(container.prepareConfigurations(to.getAssociatedConfigurationType()));
            }
            if (dropOnCancel && !valid) {
                container.invalidate();
                return true;
            }
            return false;
        });
        this.activeContainer = null;
        if (to == LoadingStage.MIXIN_CONFIG_BUILDING) {
            ConfigBuildingManager.generateRuntimeConfigurations();
        } else if (to.isConfigurationStage()) {
            this.preparedConfigs.addAll(MixinConfiguration.prepareUnclaimedConfigurations(to.getAssociatedConfigurationType()));
            GrimoireCore.logger.info("Registered total of {} mixin configurations of type {}.", new Object[]{this.preparedConfigs.size(), to.getAssociatedConfigurationType()});
        }
        GrimoireCore.logger.info("Sucessfully finished transition into {} loading stage.", new Object[]{this.internalStage});
    }
}

