/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.grimoire.common.modules.legacy;

import io.github.crucible.grimoire.common.GrimoireCore;
import io.github.crucible.grimoire.common.api.GrimoireAPI;
import io.github.crucible.grimoire.common.api.grimmix.Grimmix;
import io.github.crucible.grimoire.common.api.grimmix.GrimmixController;
import io.github.crucible.grimoire.common.api.grimmix.IGrimmix;
import io.github.crucible.grimoire.common.api.grimmix.lifecycle.ICoreLoadEvent;
import io.github.crucible.grimoire.common.api.grimmix.lifecycle.IModLoadEvent;
import io.github.crucible.grimoire.common.api.grimmix.lifecycle.IValidationEvent;
import io.github.crucible.grimoire.common.config.GrimoireConfig;
import io.github.crucible.grimoire.common.core.GrimmixLoader;
import io.github.crucible.grimoire.common.modules.legacy.LegacyPatch;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;

@Grimmix(id="GrimoireLegacyModule", name="Grimoire Legacy Module")
public class LegacyPatchController
extends GrimmixController {
    private static LegacyPatchController instance;
    private static List<LegacyPatch> patches;
    private final IGrimmix grimmix;

    public LegacyPatchController() {
        instance = this;
        this.grimmix = GrimmixLoader.INSTANCE.getActiveContainer();
    }

    public static LegacyPatchController instance() {
        return instance;
    }

    public boolean isEnabled() {
        return this.grimmix != null && this.grimmix.isValid();
    }

    public boolean isLegacyPatch(String fileName) {
        for (LegacyPatch patch : patches) {
            if (!patch.getFileName().equals(fileName) || patch.wasOnClasspath()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateController(IValidationEvent event) {
        if (!GrimoireConfig.enableLegacySupport) {
            event.invalidate();
        } else {
            GrimoireCore.logger.info("Legacy support module is enabled. Be looking for legacy patch files...");
            File grimoireFolder = new File(GrimoireAPI.getMinecraftFolder(), "grimoire");
            File modFolder = GrimoireAPI.getModFolder();
            File versionFolder = GrimoireAPI.getVersionedModFolder();
            if (grimoireFolder.exists() && grimoireFolder.isDirectory()) {
                patches.addAll(this.scanForPatches(grimoireFolder, true));
            }
            if (modFolder.exists() && modFolder.isDirectory()) {
                patches.addAll(this.scanForPatches(modFolder, false));
            }
            if (versionFolder.exists() && versionFolder.isDirectory()) {
                patches.addAll(this.scanForPatches(versionFolder, false));
            }
            Collections.sort(patches);
            Collections.reverse(patches);
            GrimoireCore.logger.info("Grand total of {} legacy patches was located.", new Object[]{patches.size()});
        }
    }

    @Override
    public void coreLoad(ICoreLoadEvent event) {
        patches.forEach(grimPatch -> {
            if (grimPatch.isCorePatch()) {
                GrimoireCore.logger.info("Applying core legacy patch " + grimPatch.getPatchName());
                grimPatch.getMixinEntries().forEach(json -> event.registerConfiguration(json.getName()));
            }
        });
    }

    @Override
    public void modLoad(IModLoadEvent event) {
        patches.forEach(grimPatch -> {
            if (!grimPatch.isCorePatch()) {
                GrimoireCore.logger.info("Applying mod legacy patch " + grimPatch.getPatchName());
                grimPatch.getMixinEntries().forEach(json -> event.registerConfiguration(json.getName()));
            }
        });
    }

    private boolean isMixinConfiguration(String name, boolean legacy) {
        String splitName;
        String string = splitName = name.contains("/") ? name.substring(name.lastIndexOf("/")).replace("/", "") : name;
        if (legacy) {
            if (splitName.startsWith("mixins.") && splitName.endsWith(".json")) {
                return true;
            }
            if (splitName.startsWith("mixins-") && splitName.endsWith(".json")) {
                return true;
            }
            return splitName.endsWith("-mixins.json");
        }
        if (splitName.startsWith("mixins.grim.") && splitName.endsWith(".json")) {
            return true;
        }
        if (splitName.startsWith("mixins-grim-") && splitName.endsWith(".json")) {
            return true;
        }
        return splitName.endsWith("-grim-mixins.json");
    }

    private List<LegacyPatch> scanForPatches(File dir, boolean legacy) {
        ArrayList<LegacyPatch> grimPatches = new ArrayList<LegacyPatch>();
        for (File mod : FileUtils.listFiles(dir, new String[]{"jar"}, true)) {
            if (!mod.canRead()) continue;
            try {
                ZipFile zipFile = new ZipFile(mod);
                Throwable throwable = null;
                try {
                    boolean bl;
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    ArrayList<ZipEntry> mixinEntries = new ArrayList<ZipEntry>();
                    Manifest manifest = null;
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (this.isMixinConfiguration(entry.getName(), legacy)) {
                            mixinEntries.add(entry);
                            continue;
                        }
                        if (!entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                        manifest = new Manifest(zipFile.getInputStream(entry));
                    }
                    if (mixinEntries.isEmpty()) continue;
                    boolean hasGrimmix = false;
                    for (IGrimmix iGrimmix : GrimmixLoader.INSTANCE.getAllContainers()) {
                        if (!iGrimmix.getGrimmixFile().equals(mod)) continue;
                        hasGrimmix = true;
                        break;
                    }
                    if (hasGrimmix) {
                        GrimoireCore.logger.info("Ignoring legacy patch candidate {}, as it contains modern @Grimmix.", new Object[]{mod.getName()});
                        continue;
                    }
                    URL modUrl = mod.toPath().toUri().toURL();
                    boolean bl2 = false;
                    for (URL url : GrimoireCore.INSTANCE.getClassLoader().getURLs()) {
                        if (!modUrl.equals(url)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        GrimoireCore.INSTANCE.getClassLoader().addURL(modUrl);
                        GrimoireCore.INSTANCE.getForcedFilenames().add(mod.getName());
                    }
                    GrimoireCore.logger.info("Added legacy patch {}, was on classpath: {}", new Object[]{mod.getName(), bl});
                    grimPatches.add(new LegacyPatch(manifest, mixinEntries, mod, bl));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            catch (Exception ex) {
                GrimoireCore.logger.error("Unable to load '{}'.", new Object[]{mod.getAbsolutePath()});
                ex.printStackTrace();
            }
        }
        return grimPatches;
    }

    static {
        patches = new ArrayList<LegacyPatch>();
    }
}

