/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  This class now also supports the idea of concrete maxima and minima. These are optional parameters
 *  that can be set to replace infinite upper and lower bounds on a range. For example, when a chart model
 *  contains only NaN values, then the computed range will be [-Infinity, +Infinity]. Although this is
 *  mathematically correct, it means that the range can no longer be subdivided neatly into sub-regions and
 *  it is therefore no longer possible to paint ticks on the axis. From a user's point of view this behaviour
 *  may be disturbing and the user might even perceive that there is a bug in the system. The absolute maxima
 *  and minima have been introduced to address this problem.
 */
public abstract class AbstractAutoRanger implements AutoRanger {

	protected AbstractAutoRanger() {
	}

	protected AbstractAutoRanger(Double fixMinX, Double fixMinY, Double fixMaxX, Double fixMaxY) {
	}

	/**
	 *  Sets the margin proportions to apply to ranges when calculating minima and maxima.
	 *  If you are setting all the margin proportions this is easier to use than calling the
	 *  individual setters for each of the margins.
	 * 
	 *  @param top    the trailing y margin proportion
	 *  @param left   the leading x margin proportion
	 *  @param bottom the leading y margin proportion
	 *  @param right  the trailing x margin proportion
	 */
	public void setMarginProportions(double top, double left, double bottom, double right) {
	}

	public double getLeadingXMarginProportion() {
	}

	public void setLeadingXMarginProportion(double leadingXMarginProportion) {
	}

	public double getLeadingYMarginProportion() {
	}

	public void setLeadingYMarginProportion(double leadingYMarginProportion) {
	}

	public double getTrailingXMarginProportion() {
	}

	public void setTrailingXMarginProportion(double trailingXMarginProportion) {
	}

	public double getTrailingYMarginProportion() {
	}

	public boolean isAllowXMarginToCrossZero() {
	}

	public void setAllowXMarginToCrossZero(boolean allowXMarginToCrossZero) {
	}

	public void setTrailingYMarginProportion(double trailingYMarginProportion) {
	}

	public boolean isAllowYMarginToCrossZero() {
	}

	public Double getFixMinY() {
	}

	public Double getFixMaxY() {
	}

	public Double getFixMinX() {
	}

	public Double getFixMaxX() {
	}

	/**
	 *  Returns the concrete maximum value for x
	 *  @return the concrete maximum value for x
	 */
	public Double getAbsoluteMaxX() {
	}

	/**
	 *  Specify a concrete maximum value for x if it would otherwise be +Infinity
	 *  @param absoluteMaxX a maximum value for x
	 */
	public void setAbsoluteMaxX(Double absoluteMaxX) {
	}

	/**
	 *  Returns the concrete maximum value for y
	 *  @return the concrete maximum value for y
	 */
	public Double getAbsoluteMaxY() {
	}

	/**
	 *  Specify a concrete maximum value for y if it would otherwise be +Infinity
	 *  @param absoluteMaxY a maximum value for y
	 */
	public void setAbsoluteMaxY(Double absoluteMaxY) {
	}

	/**
	 *  Returns the concrete minimum value for x
	 *  @return the concrete minimum value for x
	 */
	public Double getAbsoluteMinX() {
	}

	/**
	 *  Specify a concrete minimum value for x if it would otherwise be -Infinity
	 *  @param absoluteMinX a minimum value for x
	 */
	public void setAbsoluteMinX(Double absoluteMinX) {
	}

	/**
	 *  Returns the concrete minimum value for y
	 *  @return the concrete minimum value for y
	 */
	public Double getAbsoluteMinY() {
	}

	/**
	 *  Specify a concrete minimum value for y if it would otherwise be -Infinity
	 *  @param absoluteMinY a minimum value for y
	 */
	public void setAbsoluteMinY(Double absoluteMinY) {
	}

	/**
	 *  Specify whether the increase to the range by applying the margin is allowed to extend the range by crossing
	 *  from the positive region into the negative region, or vice versa. By default this is true, meaning there is no
	 *  additional restriction and the margin will be applied.
	 *  @param allowYMarginToCrossZero specify whether allowed to cross from positive to negative (or vice versa) when
	 *  extending the range.
	 */
	public void setAllowYMarginToCrossZero(boolean allowYMarginToCrossZero) {
	}

	public util.Pair getRanges(model.ChartModel model) {
	}

	/**
	 *  Returns the x and y ranges for the supplied chart model
	 *  @param model the chart model whose x and y ranges we need to discover
	 *  @return a pair of NumericRanges
	 */
	public util.Pair getRanges(model.ChartModel model, boolean applyFixes) {
	}

	/**
	 *  Post-processes the ranges of the supplied x and y axes to apply the minimum and maximum values
	 */
	protected util.Pair applyRangeConstraints(axis.Axis xAxis, axis.Axis yAxis, double minX, double minY, double maxX, double maxY) {
	}

	protected <any> applyXRangeConstraints(axis.Axis xAxis, double minX, double maxX) {
	}

	protected <any> applyYRangeConstraints(axis.Axis yAxis, double minY, double maxY) {
	}

	protected boolean isNullOrInfinite(<any> range) {
	}

	protected boolean containsZero(<any> range) {
	}

	/**
	 *  Returns the x and y range when plotting a stacked bar chart.
	 *  This is a special case for finding out the x and y range so is treated separately here
	 *  @param chart the chart for which we are computing the stacked ranges
	 *  @return the X and Y Range as a pair for a stacked bar chart
	 */
	public util.Pair getStackedRanges(Chart chart) {
	}
}
