/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  An interface implemented by graphical components that can be animated.
 */
public interface Animatable {

	/**
	 *  Set the current animation position 0.0 is the start and 1.0 is the end
	 */
	public void setAnimationPosition(double position);

	/**
	 *  Get the current animation position, 0.0 is the start and 1.0 is the end
	 * 
	 *  @return current animation position, between 0.0 and 1.0
	 */
	public double getAnimationPosition();
}
