/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  Interface for charts that support animation
 */
public interface AnimatedChart {

	/**
	 *  Start the chart animation, if it's already running then it will be stopped first and started again from the beginning
	 */
	public void startAnimation();

	/**
	 *  Stop the chart animation if it is running
	 */
	public void stopAnimation();

	/**
	 *  Get if the animation should start when the chart is first drawn to screen. If <code>FALSE</code> the animation
	 *  will only run when startAnimation() is called.
	 * 
	 *  @return <code>TRUE</code> if the chart will start animating on first draw
	 */
	public boolean isAnimateOnShow();

	/**
	 *  Set if the animation should start when the chart is first drawn to screen. If <code>FALSE</code> the animation
	 *  will only run when startAnimation() is called.
	 * 
	 *  @param animateOnShow If <code>TRUE</code> the chart will start animating on first draw
	 */
	public void setAnimateOnShow(boolean animateOnShow);
}
