/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  The interface that must be implemented by any objects that are to be used as auto-rangers for a chart. 
 */
public interface AutoRanger {

	/**
	 *  Returns a pair of range instances for the supplied chart. The first range will be used for the x axis
	 *  and the second range will be used for the primary y axis. Note that auto-ranging is used only when the
	 *  chart's auto-ranging property is set to true. 
	 *  @param chart the chart instance for which the ranges should be calculated
	 *  @return a pair of ranges, one for the x axis and one for the y axis
	 */
	public util.Pair getRanges(Chart chart);
}
