/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  The main charting component. By default, used for XY charts, categorical charts, time series charts and bar charts.
 *  Also used for pie charts by changing the chartType property.
 * 
 *  @author swhite@catalysoft.com
 */
public class Chart extends javax.swing.JComponent implements model.ChartModelChangeListener, java.beans.PropertyChangeListener, Animatable, AnimatedChart {

	public static final String PROPERTY_ANIMATE_ON_SHOW = "Animate on Show";

	public static final String PROPERTY_ANIMATION_POSITION = "Animation Position";

	public static final String PROPERTY_ANTI_ALIASING = "AntiAliasing";

	public static final String PROPERTY_AUTO_RANGING = "AutoRanging";

	public static final String PROPERTY_AXIS_COLOR = "AxisColor";

	public static final String PROPERTY_BAR_RENDERER = "BarRenderer";

	public static final String PROPERTY_BAR_GAP = "BarGap";

	public static final String PROPERTY_BAR_GROUP_GAP = "BarGroupGap";

	public static final String PROPERTY_BARS_GROUPED = "BarsGrouped";

	public static final String PROPERTY_CHART_BACKGROUND = "ChartBackground";

	public static final String PROPERTY_CHART_BORDER = "ChartBorder";

	public static final String PROPERTY_CURRENT_CHART_POINT = "ChartFocusPoint";

	public static final String PROPERTY_CHART_TYPE = "ChartType";

	public static final String PROPERTY_GRID_COLOR = "GridColor";

	public static final String PROPERTY_HIGHLIGHT_STYLE = "HighlightStyle";

	public static final String PROPERTY_HIGH_QUALITY = "HighQuality";

	public static final String PROPERTY_HORIZONTAL_GRID_LINES_VISIBLE = "HorizontalGridLinesVisible";

	public static final String PROPERTY_HORIZONTAL_MINOR_GRID_LINES_VISIBLE = "HorizontalMinorGridLinesVisible";

	public static final String PROPERTY_HORIZONTAL_MINOR_GRID_STROKE = "HorizontalMinorGridStroke";

	public static final String PROPERTY_HORIZONTAL_GRID_STROKE = "HorizontalGridStroke";

	public static final String PROPERTY_LABEL_COLOR = "LabelColor";

	public static final String PROPERTY_LABELLING_TRACES = "LabellingTraces";

	public static final String PROPERTY_LAZY_RENDERING_THRESHOLD = "LazyRenderingThreshold";

	public static final String PROPERTY_LINE_RENDERER = "LineRenderer";

	public static final String PROPERTY_MAX_BAR_WIDTH = "MaxBarWidth";

	public static final String PROPERTY_MINOR_GRID_COLOR = "MinorGridColor";

	public static final String PROPERTY_MODEL = "Model";

	public static final String PROPERTY_PANEL_BACKGROUND = "PanelBackground";

	public static final String PROPERTY_PIE_DIAMETER = "PieDiameter";

	public static final String PROPERTY_PIE_SEGMENT_RENDERER = "PieSegmentRenderer";

	public static final String PROPERTY_POINT_RENDERER = "PointRenderer";

	public static final String PROPERTY_ROLLOVER_VISIBLE = "Rollover Visible";

	public static final String PROPERTY_SELECTABLE = "Selectable";

	public static final String PROPERTY_SELECTION_SHOWS_EXPLODED_SEGMENTS = "SelectionShowsExplodedSegments";

	public static final String PROPERTY_SELECTION_SHOWS_OUTLINE = "SelectionShowsOutlines";

	public static final String PROPERTY_SHADOW_RENDERER = "Shadow Renderer";

	public static final String PROPERTY_SHADOW_VISIBLE = "ShadowVisible";

	public static final String PROPERTY_SHADOW_VISIBILITY = "ShadowVisibility";

	public static final String PROPERTY_CHART_STYLE = "ChartStyle";

	public static final String PROPERTY_TICK_COLOR = "TickColor";

	public static final String PROPERTY_TICK_STROKE = "TickStroke";

	public static final String PROPERTY_TICK_FONT = "TickFont";

	public static final String PROPERTY_TICK_LENGTH = "TickLength";

	public static final String PROPERTY_MINOR_TICK_LENGTH = "Minor TickLength";

	public static final String PROPERTY_ALLOW_TICK_LABEL_OVERLAP = "Allow Tick Label Overlap";

	public static final String PROPERTY_TITLE = "Title";

	public static final String PROPERTY_TITLE_VISIBLE = "TitleVisible";

	/**
	 * @deprecated Please use corrected spelling PROPERTY_VERTICAL_GRID_LINES_VISIBLE 
	 */
	public static final String PROPERTY_VERTICAL_GRIDLINES_VISIBLE = "VerticalGridLinesVisible";

	public static final String PROPERTY_VERTICAL_GRID_LINES_VISIBLE = "VerticalGridLinesVisible";

	/**
	 * @deprecated  Please use corrected spelling PROPERTY_VERTICAL_MINOR_GRID_LINES_VISIBLE 
	 */
	public static final String PROPERTY_VERTICAL_MINOR_GRIDLINES_VISIBLE = "VerticalMinorGridLinesVisible";

	public static final String PROPERTY_VERTICAL_MINOR_GRID_LINES_VISIBLE = "VerticalMinorGridLinesVisible";

	public static final String PROPERTY_VERTICAL_MINOR_GRID_STROKE = "VerticalMinorGridStroke";

	public static final String PROPERTY_VERTICAL_GRID_STROKE = "VerticalGridStroke";

	public static final String PROPERTY_X_AXIS = "XAxis";

	public static final String PROPERTY_Y_AXIS = "YAxis";

	/**
	 *  Zero-argument Constructor
	 */
	public Chart() {
	}

	/**
	 *  Create a chart from the supplied model
	 * 
	 *  @param model the model that will be used initially by the Chart
	 */
	public Chart(model.ChartModel model) {
	}

	/**
	 *  The idea of this constructor is to encourage the naming of chart components. As a JComponent, it inherits the
	 *  <code>setName</code> method, but many programmers do not use this method. Naming the chart instance is optional
	 *  but can help with testing and debugging, especially if you are using more than one chart instance.
	 * 
	 *  @param name the name of the Chart instance
	 */
	public Chart(String name) {
	}

	/**
	 *  Creates a Chart, and sets its size (and preferred size) to be the supplied dimensions. Note that whether the size
	 *  settings are respected depends on the layout manager that is used for displaying the chart.
	 * 
	 *  @param size the size of the chart
	 */
	public Chart(java.awt.Dimension size) {
	}

	/**
	 *  Initialise the component by setting defaults and listeners
	 */
	protected void init() {
	}

	@java.lang.Override
	public void updateUI() {
	}

	/**
	 *  Specify the z order of a model.
	 * 
	 *  @param model  the model whose z order we wish to set
	 *  @param zOrder the z order for the specified model (a positive integer)
	 */
	public void setZOrder(model.ChartModel model, Integer zOrder) {
	}

	public Integer getZOrder(model.ChartModel model) {
	}

	/**
	 *  @return the type of chart, eg. whether XY chart or Pie chart
	 */
	public ChartType getChartType() {
	}

	/**
	 *  Specify the type of chart, eg. whether XY chart or pie chart. By default this is an XY chart.
	 * 
	 *  @param chartType the new chart type
	 */
	public void setChartType(ChartType chartType) {
	}

	public ShadowRenderer getShadowRenderer() {
	}

	public void setShadowRenderer(ShadowRenderer shadowRenderer) {
	}

	/**
	 *  @return the renderer object responsible for rendering points
	 */
	public render.PointRenderer getPointRenderer() {
	}

	/**
	 *  Specify the point renderer to use
	 * 
	 *  @param pointRenderer the new point renderer
	 */
	public void setPointRenderer(render.PointRenderer pointRenderer) {
	}

	/**
	 *  Returns the point renderer associated with the given model. If no renderer is associated specifically with this
	 *  model, then the "all-model" renderer is returned instead.
	 * 
	 *  @param model the chart model we are interested in
	 *  @return the associated PointRenderer
	 */
	public render.PointRenderer getPointRenderer(model.ChartModel model) {
	}

	/**
	 *  Specify the point renderer to use for the given model. This overrides any point renderer specified by calling
	 *  <code>setPointRenderer(PointRenderer)</code>.
	 * 
	 *  @param model         the model with which the renderer is associated
	 *  @param pointRenderer the point renderer
	 */
	public void setPointRenderer(model.ChartModel model, render.PointRenderer pointRenderer) {
	}

	/**
	 *  Returns the line renderer associated with the given model. If no renderer is associated specifically with this
	 *  model, then the "all-model" renderer is returned instead.
	 * 
	 *  @param model the chart model we are interested in
	 *  @return the associated LineRenderer
	 */
	public render.LineRenderer getLineRenderer(model.ChartModel model) {
	}

	/**
	 *  Specify the line renderer to use for the given model. This overrides any line renderer specified by calling
	 *  <code>setLineRenderer(LineRenderer)</code>.
	 * 
	 *  @param model        the model with which the renderer is associated
	 *  @param lineRenderer the line renderer
	 */
	public void setLineRenderer(model.ChartModel model, render.LineRenderer lineRenderer) {
	}

	/**
	 *  @return the renderer object responsible for rendering bars of a bar chart
	 */
	public render.BarRenderer getBarRenderer() {
	}

	/**
	 *  Specify the bar renderer to use
	 * 
	 *  @param barRenderer the new bar renderer
	 */
	public void setBarRenderer(render.BarRenderer barRenderer) {
	}

	/**
	 *  Returns the bar renderer associated with the given model. If no renderer is associated specifically with this
	 *  model, then the "all-model" renderer is returned instead.
	 * 
	 *  @param model the chart model we are interested in
	 *  @return the associated BarRenderer
	 */
	public render.BarRenderer getBarRenderer(model.ChartModel model) {
	}

	/**
	 *  Specify the bar renderer to use for the given model. This overrides any bar renderer specified by calling
	 *  <code>setBarRenderer(BarRenderer)</code>.
	 * 
	 *  @param model       the model with which the renderer is associated
	 *  @param barRenderer the bar renderer
	 */
	public void setBarRenderer(model.ChartModel model, render.BarRenderer barRenderer) {
	}

	/**
	 *  Return a boolean to indicate whether we are recording the shapes for points and bars
	 * 
	 *  @return a boolean to indicate whether we are recording the shapes for points and bars
	 */
	public boolean isRecordingShapes() {
	}

	/**
	 *  Specify whether we want to record the shapes that are drawn out by the point and bar renderers. This is used by
	 *  the rollover mechanism and is switched on by default. However, if you are using large data sets and not using the
	 *  rollover mechanism, you may want to switch this off.
	 * 
	 *  @param recordingShapes whether to record the shapes for the points and bars
	 */
	public void setRecordingShapes(boolean recordingShapes) {
	}

	/**
	 *  Specify the diameter of the pie chart, in pixels. Only used when displaying pie charts. When this property is not
	 *  set (that is, set to <code>null</code>), a 'best fit' size will be calculated.
	 * 
	 *  @param diameter the new diameter of pie charts
	 */
	public void setPieDiameter(Integer diameter) {
	}

	/**
	 *  Returns the diameter of the pie chart in pixels, or null if no pixel diameter has been specified.
	 *  @return the diameter of the pie in a pie chart, in pixels
	 */
	public Integer getPieDiameter() {
	}

	/**
	 *  Returns the Stroke used for the style of horizontal lines of the grid corresponding to major ticks
	 * 
	 *  @return the Stroke used for the style of horizontal lines of the grid corresponding to major ticks
	 */
	public java.awt.Stroke getHorizontalGridStroke() {
	}

	/**
	 *  Returns the Stroke currently used for horizontal lines of the grid corresponding to minor ticks
	 * 
	 *  @return the Stroke currently used for horizontal lines of the grid corresponding to minor ticks
	 */
	public java.awt.Stroke getHorizontalMinorGridStroke() {
	}

	/**
	 *  Sets the stroke to use when painting horizontal grid lines that correspond to minor ticks
	 * 
	 *  @param stroke the stroke to use when painting horizontal grid lines that correspond to minor ticks
	 */
	public void setHorizontalMinorGridStroke(java.awt.Stroke stroke) {
	}

	/**
	 *  Sets the stroke used for the style of horizontal lines in the grid of an XY chart
	 * 
	 *  @param horizontalGridStroke the new Stroke
	 */
	public void setHorizontalGridStroke(java.awt.Stroke horizontalGridStroke) {
	}

	/**
	 *  Returns the Stroke currently used for vertical lines of the grid corresponding to major ticks
	 * 
	 *  @return the Stroke currently used for vertical lines of the grid corresponding to major ticks
	 */
	public java.awt.Stroke getVerticalGridStroke() {
	}

	/**
	 *  Sets the stroke used for the style of vertical lines in the grid of an XY chart
	 * 
	 *  @param verticalGridStroke the new Stroke
	 */
	public void setVerticalGridStroke(java.awt.Stroke verticalGridStroke) {
	}

	/**
	 *  Returns the Stroke currently used for vertical lines of the grid corresponding to minor ticks
	 * 
	 *  @return the Stroke currently used for vertical lines of the grid corresponding to minor ticks
	 */
	public java.awt.Stroke getVerticalMinorGridStroke() {
	}

	/**
	 *  Specify the Stroke to use when painting vertical grid lines that correspond to minor ticks on the x axis
	 * 
	 *  @param stroke the stroke to use when painting vertical grid lines corresponding to minor ticks on the x axis
	 */
	public void setVerticalMinorGridStroke(java.awt.Stroke stroke) {
	}

	/**
	 *  @return the point corresponding to the shape under the mouse cursor
	 */
	public model.Chartable getCurrentChartPoint() {
	}

	/**
	 *  Returns the shape that is being used to render the supplied chartable point, or null if not known. Note that any
	 *  enquiry about the shape used for pie segments will work only if the PieSegmentRenderer is an extension of the
	 *  AbstractPieSegmentRenderer. All pie segment renderers provided as part of this product satisfy this constraint,
	 *  so it is a concern only if your have written your own custom PieSegmentRenderer.
	 * 
	 *  @param chartable the point in the model for which we would like to know the rendered shape
	 *  @return the rendered shape, or null if not known (or not rendered)
	 */
	public java.awt.Shape renderedAs(model.Chartable chartable) {
	}

	public event.PointDescriptor rendered(model.Chartable chartable) {
	}

	/**
	 *  Determines whether there is a shape rendered that contains the supplied pixel point. If so, a descriptor is
	 *  returned for the corresponding point in the chart model.
	 * 
	 *  @param p a coordinate in pixel space
	 *  @return a point descriptor for the corresponding point in the chart model, if any; otherwise null.
	 */
	public event.PointDescriptor containingShape(java.awt.Point p) {
	}

	/**
	 *  Returns point descriptors for all the Chartables rendered at the specified point
	 * 
	 *  @param p the specified pixel point
	 *  @return a Collection of the PointDescriptors relevant to the supplied point
	 */
	public java.util.Collection containingShapes(java.awt.Point p) {
	}

	/**
	 *  You can use this method to test whether the supplied pixel point is contained by the rendering of a bar.
	 * 
	 *  @param p the point to be tested
	 *  @return the model point corresponding to the bar, or null if the point is not over a bar
	 */
	public event.PointDescriptor containingBar(java.awt.Point p) {
	}

	/**
	 *  Determines whether the supplied pixel point is contained by the rendering of a segment in a pie chart.
	 * 
	 *  @param p a coordinate in pixel space
	 *  @return a point descriptor for the corresponding point in the chart model, if any; otherwise null.
	 */
	public event.PointDescriptor containingSegment(java.awt.Point p) {
	}

	/**
	 *  Determines whether there is a line segment close to p, within a supplied 'radius'.
	 *  Strictly speaking this is not really a radius, because a circumscribing rectangle is constructed around the
	 *  point of interest rather than a circle, but for most purposes this difference does not matter as the distances
	 *  that we are using for testing proximity to a line are small.
	 * 
	 *  @param p      the point of interest
	 *  @param radius the allowed distance from a line at which the line is said to 'contain' the point
	 *  @return a Collection of ChartModels found near the point
	 */
	public java.util.Collection nearLine(java.awt.Point p, float radius) {
	}

	/**
	 *  Determines whether the supplied pixel point is contained by the rendering of a (model) point in a chart.
	 * 
	 *  @param p a coordinate in pixel space
	 *  @return a point descriptor for the corresponding point in the chart model, if any; otherwise null.
	 */
	public event.PointDescriptor containingPoint(java.awt.Point p) {
	}

	/**
	 *  Returns a collection of descriptors for all (model) points rendered at the supplied pixel point
	 * 
	 *  @param p a coordinate in pixel space
	 *  @return a collection of point descriptors for chartables found at the given pixel position
	 */
	public java.util.Collection containingPoints(java.awt.Point p) {
	}

	/**
	 *  @return the renderer used for rendering the segments of a pie chart
	 */
	public render.PieSegmentRenderer getPieSegmentRenderer() {
	}

	/**
	 *  Specify the renderer to use for drawing pie charts
	 * 
	 *  @param segmentRenderer the new pie segment renderer
	 */
	public void setPieSegmentRenderer(render.PieSegmentRenderer segmentRenderer) {
	}

	/**
	 *  @return the renderer to use for drawing lines in a chart
	 */
	public render.LineRenderer getLineRenderer() {
	}

	/**
	 *  Specify the renderer to use for drawing lines in a chart
	 * 
	 *  @param lineRenderer the new line renderer
	 */
	public void setLineRenderer(render.LineRenderer lineRenderer) {
	}

	/**
	 *  Specify the pixel gap between bars in a bar chart
	 * 
	 *  @param barGap the new pixel gap
	 */
	public void setBarGap(int barGap) {
	}

	/**
	 *  @return the pixel gap between bars in a bar chart
	 */
	public int getBarGap() {
	}

	/**
	 *  Specify the maximum width for a bar in a bar chart. If the maximum width is set to a negative number then no
	 *  limit applies.
	 * 
	 *  @param maxBarWidth the new maximum width
	 */
	public void setMaxBarWidth(int maxBarWidth) {
	}

	/**
	 *  Get the current maximum bar width.
	 * 
	 *  @return the current maximum bar width
	 */
	public int getMaxBarWidth() {
	}

	public int getBarGroupGap() {
	}

	/**
	 *  Specify the gap (in pixels) between groups of bars in a grouped bar chart
	 * 
	 *  @param barGroupGap the new gap between groups of bars
	 */
	public void setBarGroupGap(int barGroupGap) {
	}

	/**
	 *  Specify the size of the group gap as a proportion of the space available to the group. If you set the
	 *  groupGapProportion to null, then the absolute number of pixels (specified by calling <code>setBarGroupGap</code>)
	 *  will be used instead.
	 * 
	 *  @param barGroupGapProportion the size of the group gap as a proportion of the space available to the group
	 */
	public void setBarGroupGapProportion(Double barGroupGapProportion) {
	}

	/**
	 *  Specify whether bars should be grouped or stacked when they have the same axis value
	 * 
	 *  @param barsGrouped whether bars should be grouped (if not grouped they are stacked)
	 */
	public void setBarsGrouped(boolean barsGrouped) {
	}

	/**
	 *  @return whether bars are grouped
	 */
	public boolean isBarsGrouped() {
	}

	/**
	 *  Specify the bar resize policy when bars are assigned a width and the space available does not match the widths
	 * 
	 *  @param policy the bar resize policy
	 */
	public void setBarResizePolicy(BarResizePolicy policy) {
	}

	/**
	 *  @return the current bar resize policy
	 */
	public BarResizePolicy getBarResizePolicy() {
	}

	public boolean isHighQuality() {
	}

	/**
	 *  Specify whether to invest additional computational effort to try to avoid the possibility of pixel value rounding
	 *  errors. This is false by default and you should not normally need to set it to true.
	 * 
	 *  @param highQuality whether to try to avoid pixel value rounding errors
	 */
	public void setHighQuality(boolean highQuality) {
	}

	/**
	 *  Returns whether the vertical lines corresponding to major ticks on the x axis are visible
	 * 
	 *  @return whether the vertical lines corresponding to major ticks on the x axis are visible
	 */
	public boolean isVerticalGridLinesVisible() {
	}

	/**
	 *  Returns whether the vertical grid lines corresponding to minor ticks on the x axis are visible
	 * 
	 *  @return whether the vertical grid lines corresponding to minor ticks on the x axis are visible
	 */
	public boolean isVerticalMinorGridLinesVisible() {
	}

	public void setVerticalMinorGridLinesVisible(boolean verticalMinorGridLinesVisible) {
	}

	/**
	 *  Specify whether the vertical lines of the grid should be painted
	 * 
	 *  @param gridLinesVisible should the lines be painted?
	 */
	public void setVerticalGridLinesVisible(boolean gridLinesVisible) {
	}

	/**
	 *  Returns whether the horizontal grid lines corresponding to major ticks on the y axis are visible
	 * 
	 *  @return whether the horizontal grid lines corresponding to major ticks on the y axis are visible
	 */
	public boolean isHorizontalGridLinesVisible() {
	}

	/**
	 *  Returns whether the horizontal grid lines corresponding to minor ticks on the y axis are visible
	 * 
	 *  @return whether the horizontal grid lines corresponding to minor ticks on the y axis are visible
	 */
	public boolean isHorizontalMinorGridLinesVisible() {
	}

	/**
	 *  Specify whether horizontal grid lines should be visible
	 * 
	 *  @param gridLinesVisible whether horizontal grid lines are to be visible
	 */
	public void setHorizontalGridLinesVisible(boolean gridLinesVisible) {
	}

	public void setHorizontalMinorGridLinesVisible(boolean horizontalMinorGridLinesVisible) {
	}

	/**
	 *  Returns a boolean to indicate whether the chart should display a title
	 * 
	 *  @return whether the chart should display a title
	 */
	public boolean isTitleVisible() {
	}

	/**
	 *  Specify whether the chart should display a title
	 * 
	 *  @param titleVisible whether to display a title for the chart
	 */
	public void setTitleVisible(boolean titleVisible) {
	}

	/**
	 *  Returns the font used when painting tick labels. The tickFont property has been moved to the axis class so that
	 *  fonts can be specified differently for each axis. Calling this method now returns the tickFont associated with
	 *  the x axis. Calling <code>setTickFont()</code> adjusts the tick font for both axes, but must be called after the
	 *  axes have been configured on the chart.
	 * 
	 *  @return the font used for tick labels
	 */
	public java.awt.Font getTickFont() {
	}

	/**
	 *  Returns the font to use for painting tick labels on the supplied axis. The axis has its own tick font property
	 *  which overrides the value held by this class.
	 * 
	 *  @param axis the axis of interest
	 *  @return the Font to use for painting tick labels on the axis
	 */
	protected java.awt.Font getTickFont(axis.Axis axis) {
	}

	/**
	 *  Specify the font used for tick labels. Note that if a font has been set on an axis then that font value will
	 *  override any value set here.
	 * 
	 *  @param font the font to be used for tick labels
	 */
	public void setTickFont(java.awt.Font font) {
	}

	/**
	 *  Returns the stroke used when painting ticks
	 * 
	 *  @return the stroke used when painting ticks
	 */
	public java.awt.Stroke getTickStroke() {
	}

	/**
	 *  Specify the stroke used when painting ticks
	 * 
	 *  @param tickStroke the stroke to use when painting ticks
	 */
	public void setTickStroke(java.awt.Stroke tickStroke) {
	}

	/**
	 *  Returns the color of the axes
	 * 
	 *  @return the color of the axes
	 */
	public java.awt.Color getAxisColor() {
	}

	/**
	 *  Specify the color to use for the axes
	 * 
	 *  @param axisColor the new axis color
	 */
	public void setAxisColor(java.awt.Color axisColor) {
	}

	/**
	 *  Returns the color used for the grid
	 * 
	 *  @return the color used for the grid
	 */
	public java.awt.Color getGridColor() {
	}

	/**
	 *  Specify the color to use for the grid
	 * 
	 *  @param gridColor the new color for the grid lines
	 */
	public void setGridColor(java.awt.Color gridColor) {
	}

	/**
	 *  Returns the color used for the minor grid lines
	 * 
	 *  @return the color used for the minor grid lines
	 */
	public java.awt.Color getMinorGridColor() {
	}

	public void setMinorGridColor(java.awt.Color minorGridColor) {
	}

	/**
	 *  Returns the background used for the area surrounding the main chart area
	 * 
	 *  @return The background used for the area surrounding the main chart area
	 *  @see #getChartBackground()
	 */
	public java.awt.Paint getPanelBackground() {
	}

	/**
	 *  Note that we can't call this method setBackground, as that method already exists and expects a Color rather than
	 *  a Paint. That's OK for the setter but we can't override the getter. For consistency, this method calls
	 *  super.setBackground() internally if the value supplied is a Color.
	 * 
	 *  @see #setBackground(java.awt.Color)
	 *  @see #setChartBackground(java.awt.Paint)
	 */
	public void setPanelBackground(java.awt.Paint background) {
	}

	/**
	 *  Sets the background for a chart. More precisely, sets the background <i>color</i> for the chart.
	 *  Note that calling this method has the same effect as calling setPanelBackground() with the same color value.
	 * 
	 *  @param background the background color of the chart.
	 *  @see #setChartBackground(java.awt.Paint)
	 */
	public void setBackground(java.awt.Color background) {
	}

	/**
	 *  Returns the background used for the area displaying the chart
	 * 
	 *  @return the background used for the area displaying the chart
	 *  @see #getPanelBackground()
	 */
	public java.awt.Paint getChartBackground() {
	}

	/**
	 *  Specify the paint to use for the main chart area. This can be a java.awt.Color or it can be something more
	 *  complex, like a gradient fill, an image or a textured paint.
	 * 
	 *  @param chartBackground the new paint to use
	 *  @see #setPanelBackground(java.awt.Paint)
	 */
	public void setChartBackground(java.awt.Paint chartBackground) {
	}

	/**
	 *  Returns the border used to surround the chart area
	 * 
	 *  @return the border around the chart area, or null if not set
	 */
	public javax.swing.border.Border getChartBorder() {
	}

	/**
	 *  Specify the border to use around the chart area
	 * 
	 *  @param chartBorder the border for the chart area
	 */
	public void setChartBorder(javax.swing.border.Border chartBorder) {
	}

	/**
	 *  Returns the transformation from user coordinates to pixel coordinates
	 * 
	 *  @return the transformation from user coordinates to pixel coordinates
	 */
	public UserToPixelTransform getUserToPixelTransform() {
	}

	/**
	 *  Returns whether anti-aliasing is currently being used when drawing the main chart
	 * 
	 *  @return whether anti-aliasing is currently being used
	 */
	public boolean isAntiAliasing() {
	}

	/**
	 *  Specify whether to use anti-aliasing when drawing. By default this is true. Charts usually look better with it
	 *  switched on, but a step chart might look better with it switched off. (Another possible reason you might want to
	 *  switch it off is for performance reasons).
	 * 
	 *  @param antiAliasing whether to use anti-aliasing
	 */
	public void setAntiAliasing(boolean antiAliasing) {
	}

	/**
	 *  Returns a value to indicate whether tick label overlaps are currently allowed
	 * 
	 *  @return a boolean to indicate whether tick label overlaps are currently allowed
	 */
	public boolean isAllowTickLabelOverlap() {
	}

	/**
	 *  Specify whether tick labels are allowed to overlap. If this is set to false (the default) then bounds checking
	 *  will be applied and measures will be taken (such as not displaying some labels) in order to avoid overlapping
	 *  labels.
	 * 
	 *  @param allowTickLabelOverlap whether to allow tick labels to overlap
	 */
	public void setAllowTickLabelOverlap(boolean allowTickLabelOverlap) {
	}

	/**
	 *  Returns whether we currently have auto-ranging switched on
	 * 
	 *  @return a boolean to indicate whether ranges for the axes are automatically computed
	 */
	public boolean isAutoRanging() {
	}

	/**
	 *  Specify whether to compute ranges for the axes automatically, based on the data seen.
	 * 
	 *  @param autoRanging a boolean to specify whether auto-ranging should be switched on
	 */
	public void setAutoRanging(boolean autoRanging) {
	}

	/**
	 *  Specify the class used to implemented an auto-ranging policy
	 * 
	 *  @param autoRanger the class that implements the auto-ranging policy
	 */
	public void setAutoRanger(AutoRanger autoRanger) {
	}

	/**
	 *  Returns the autoRanger used for setting the ranges of the axes
	 * 
	 *  @return the AutoRanger instance used by this class
	 */
	public AutoRanger getAutoRanger() {
	}

	public boolean isLabellingTraces() {
	}

	public void setLabellingTraces(boolean labellingTraces) {
	}

	/**
	 *  A convenience method for easily adding a mouse wheel zoom facility to a chart
	 * 
	 *  @return this Chart instance
	 */
	public Chart addMouseZoomer() {
	}

	/**
	 *  Adds a MouseWheelZoomer to this chart instance, and specifies whether zooming should be enabled in the horizontal
	 *  and vertical directions. It is quite common to specify a zoom that operates only in the horizontal direction,
	 *  particularly when displaying time series data.
	 * 
	 *  @param horizontalZoom whether the zoom operates along the x axis
	 *  @param verticalZoom   whether the zoom operates along the y axis
	 *  @return this Chart instance
	 */
	public Chart addMouseZoomer(boolean horizontalZoom, boolean verticalZoom) {
	}

	/**
	 *  Removes any MouseWheelZoomer that was created using one of the addMouseZoomer methods.
	 * 
	 *  @return this Chart instance
	 */
	public Chart removeMouseZoomer() {
	}

	/**
	 *  Makes it possible for the user to 'pan' the chart easily by clicking and dragging the mouse. Panning is a
	 *  translation of the chart domain, but it is very natural when this is done with a click and drag action of the
	 *  mouse.
	 * 
	 *  @return this chart instance (so you can chain method calls)
	 */
	public Chart addMousePanner() {
	}

	/**
	 *  Make it possible for the user to pan the chart easily, but specifying whether panning is allowed in the
	 *  horizontal and/or vertical axes.
	 * 
	 *  @param horizontalPan do we allow horizontal panning
	 *  @param verticalPan   do we allow vertical panning
	 *  @return this Chart instance (so you can chain method calls)
	 */
	public Chart addMousePanner(boolean horizontalPan, boolean verticalPan) {
	}

	/**
	 *  Remove the panning ability for this chart.
	 * 
	 *  @return this chart instance (so you can chain method calls)
	 */
	public Chart removeMousePanner() {
	}

	public void setRolloverEnabled(boolean rollover) {
	}

	public boolean isRolloverEnabled() {
	}

	/**
	 *  Specify whether the displayed chart should respond to selections. By default selection is switched off.
	 * 
	 *  @param selectable whether selection is switched on
	 */
	public void setSelectionEnabled(boolean selectable) {
	}

	public boolean isSelectionEnabled() {
	}

	/**
	 *  @return Are we currently using an explosion effect to indicate selection of segments?
	 */
	public boolean isSelectionShowsExplodedSegments() {
	}

	/**
	 *  Specify whether to use an explosion effect to indicate selection of segments
	 * 
	 *  @param selectionShowsExplodedSegments used to specify whether selecting segments of a pie chart
	 *                                        will show those segments as 'exploded' away from the rest of the pie
	 */
	public void setSelectionShowsExplodedSegments(boolean selectionShowsExplodedSegments) {
	}

	/**
	 *  @return are selection outlines currently shown?
	 */
	public boolean isSelectionShowsOutline() {
	}

	/**
	 *  Specify whether segment selection should be indicated by an outline on the segment
	 * 
	 *  @param selectionShowsOutline should selection outlines be visible?
	 */
	public void setSelectionShowsOutline(boolean selectionShowsOutline) {
	}

	public void addDoubleClickListener(java.awt.event.ActionListener listener) {
	}

	public void removeDoubleClickListener(java.awt.event.ActionListener listener) {
	}

	/**
	 *  This is the method of the ChartModelListener interface; it is called whenever the chart model has changed and all
	 *  points need to be updated.
	 */
	public void chartModelChanged() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void chartModelChanged(model.ChartModelChangeEvent changeEvent) {
	}

	/**
	 *  Returns a boolean to indicate whether shadows are being applied to elements of the chart
	 * 
	 *  @return whether shadows are being applied to elements of the chart
	 */
	public boolean isShadowVisible() {
	}

	/**
	 *  Use to specify whether shadows should be drawn under lines, points etc. on the chart. Note that
	 *  <code>setShadowVisible(true)</code> is equivalent to <code>setShadowVisibility(ShadowVisibility.ALL);</code> and
	 *  <code>setShadowVisible(false)</code> is equivalent to <code>setShadowVisibility(ShadowVisibility.NONE)</code>.
	 * 
	 *  @param shadowVisible boolean to indicate whether shadows should be drawn
	 */
	public void setShadowVisible(boolean shadowVisible) {
	}

	public ShadowVisibility getShadowVisibility() {
	}

	/**
	 *  You can use this property to be more selective about which elements in a chart cast a shadow
	 */
	public void setShadowVisibility(ShadowVisibility shadowVisibility) {
	}

	/**
	 *  Marks the specified model with the given shadow visibility. At the time of writing, this is not supported for
	 *  lazy rendering but it may be supported in a future release.
	 * 
	 *  @param model         the model for which we wish to mark the shadow's visibility
	 *  @param shadowVisible whether the shadow is visible
	 */
	public void setShadowVisible(model.ChartModel model, boolean shadowVisible) {
	}

	/**
	 *  Returns a boolean to indicate whether shadows have been applied to the specified model
	 * 
	 *  @param model the chart model
	 *  @return a boolean to indicate whether shadows have been applied to this model
	 */
	public boolean isShadowVisible(model.ChartModel model) {
	}

	/**
	 *  Causes the ranges of the chart to be adjusted according to the data. If you add a model to the chart you will
	 *  probably want to call this afterwards to ensure that the axes are adjusted to accommodate the new data.
	 */
	public void autoRange() {
	}

	/**
	 *  Updates margins and coordinate systems according to the size of the component. This method is used internally and
	 *  it is rare that you should have to call this. (A possible exception is forcing an update to the component prior
	 *  to painting to a different graphics canvas.)
	 */
	public void update() {
	}

	/**
	 *  Updates margins and coordinate systems according to the size of the component.
	 * 
	 *  @param canInvokeLazyRenderer specify whether this method is allowed to explicitly invoke an update
	 *                               on the lazy renderer. Use with caution as wrong usage can cause recursive
	 *                               event loops.
	 */
	protected void update(boolean canInvokeLazyRenderer) {
	}

	/**
	 *  You should not need to call this method often. It uses lazy rendering for drawing and starts the background
	 *  drawing immediately. If this gets called too often it could damage performance rather than improve it, so
	 *  take care at what point this is invoked.
	 */
	public void drawInBackground() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public void propertyChange(java.beans.PropertyChangeEvent pce) {
	}

	/**
	 *  Adds an object that implements the drawable callback method. Use this method to add custom shapes to a chart.
	 * 
	 *  @param d the Drawable to add
	 *  @return this chart object (so calls to this method can be cascaded)
	 */
	public Chart addDrawable(Drawable d) {
	}

	/**
	 *  Removes a drawable from the chart (and all references to the Drawable from the chart object too). <p><b>Note:</b>
	 *  Make sure your Drawables have good implementations of equals() and hashCode()</p>
	 * 
	 *  @param d the Drawable to remove
	 *  @return this chart object
	 */
	public Chart removeDrawable(Drawable d) {
	}

	/**
	 *  Removes all drawables from the chart
	 * 
	 *  @return this chart object
	 */
	public Chart removeDrawables() {
	}

	/**
	 *  Determines whether this chart object already contains the supplied Drawable. For this method to work as expected,
	 *  the Drawable is expected to have a good implementation of equals() and hashCode()
	 * 
	 *  @param drawable the Drawable object to test
	 *  @return this Chart object
	 */
	public boolean containsDrawable(Drawable drawable) {
	}

	/**
	 *  Returns a Collection of Drawable objects known by the Chart
	 * 
	 *  @return a Collection of drawable objects known by the Chart
	 */
	public java.util.Collection getDrawables() {
	}

	/**
	 *  Returns the padding around the axis labels. Use this to keep the axis label far from the tick labels or to bring
	 *  them close together.
	 * 
	 *  @return the gap between the tick labels and the axis label
	 */
	public int getAxisLabelPadding() {
	}

	/**
	 *  Specify the padding around the axis labels measured in pixels.
	 * 
	 *  @param axisLabelPadding the gap between the axis label and the tick labels and the axis label and the edge of the
	 *                          chart (or next axis)
	 */
	public void setAxisLabelPadding(int axisLabelPadding) {
	}

	/**
	 *  Returns the width of the supplied axis due to the rendering of ticks and tick labels (but not the main axis
	 *  label)
	 * 
	 *  @return the width of the supplied axis due to rendering of ticks and labels
	 */
	public int axisWidth(java.awt.Graphics g, axis.Axis axis) {
	}

	public int titleHeight() {
	}

	/**
	 *  @return the pixel x coordinate start of the drawing area relative to the canvas on which it is painted
	 */
	public int getXStart() {
	}

	/**
	 *  @return the pixel x coordinate end of the drawing area relative to the canvas on which it is painted
	 */
	public int getXEnd() {
	}

	/**
	 *  @return the width of the drawing area in pixels
	 */
	public int getChartWidth() {
	}

	/**
	 *  @return the y coordinate start of the drawing area relative to the canvas on which it is painted. <p>For the y
	 *          axis, the 'start' is the bottom of the chart region and therefore has a numeric value greater than or
	 *          equal to the yEnd property</p>
	 */
	public int getYStart() {
	}

	/**
	 *  @return the y coordinate end of the drawing area relative to the canvas on which it is painted. <p>For the y
	 *          axis, the 'end' is at the top of the chart region</p>
	 */
	public int getYEnd() {
	}

	public int getChartHeight() {
	}

	/**
	 *  @param model the model for which we wish to compute the sum of the y values
	 *  @return the sum of the y values of the supplied ChartModel
	 */
	public double getYSum(model.ChartModel model) {
	}

	/**
	 *  Returns the length of major ticks, in pixels
	 * 
	 *  @return the length of major ticks, in pixels
	 */
	public int getTickLength() {
	}

	/**
	 *  Specify the length of major ticks, in pixels
	 * 
	 *  @param tickLength the new length for major ticks
	 */
	public void setTickLength(int tickLength) {
	}

	/**
	 *  Returns the length of minor ticks, in pixels
	 * 
	 *  @return the length of minor ticks, in pixels
	 */
	public int getMinorTickLength() {
	}

	/**
	 *  Specify the length of minor ticks, in pixels
	 * 
	 *  @param minorTickLength the new length for minor ticks
	 */
	public void setMinorTickLength(int minorTickLength) {
	}

	/**
	 *  Returns the current tick color
	 * 
	 *  @return the current tick color
	 */
	public java.awt.Color getTickColor() {
	}

	/**
	 *  Specify the color to use for ticks along the axes
	 * 
	 *  @param tickColor the new tick color
	 */
	public void setTickColor(java.awt.Color tickColor) {
	}

	/**
	 *  Returns the color of the axis labels
	 * 
	 *  @return the color of the axis labels
	 */
	public java.awt.Color getLabelColor() {
	}

	/**
	 *  Specify the color to use for the labels of the axes
	 * 
	 *  @param labelColor the color to use for the labels of the axes
	 */
	public void setLabelColor(java.awt.Color labelColor) {
	}

	/**
	 *  Set the x axis
	 * 
	 *  @param axis the new x axis
	 */
	public void setXAxis(axis.Axis axis) {
	}

	/**
	 *  Returns the chart's x axis
	 * 
	 *  @return the chart's x axis
	 */
	public axis.Axis getXAxis() {
	}

	/**
	 *  Set the primary y axis
	 * 
	 *  @param newAxis the new y axis
	 */
	public void setYAxis(axis.Axis newAxis) {
	}

	/**
	 *  Adds a y axis
	 * 
	 *  @param newAxis the new y axis
	 *  @return this Chart object
	 */
	public Chart addYAxis(axis.Axis newAxis) {
	}

	/**
	 *  Returns the primary y axis. The primary y axis is the first one that was added.
	 * 
	 *  @return the primary y axis
	 */
	public axis.Axis getYAxis() {
	}

	/**
	 *  Returns the nth y axis (indexed from zero)
	 * 
	 *  @param n the index of the axis to return
	 *  @return the nth axis
	 */
	public axis.Axis getYAxis(int n) {
	}

	/**
	 *  Returns the number of y axes
	 * 
	 *  @return the number of y axes
	 */
	public int getYAxisCount() {
	}

	/**
	 *  Sets the (optional) title for the chart
	 * 
	 *  @param title the new title of the chart
	 */
	public void setTitle(String title) {
	}

	/**
	 *  Returns the current title of the chart
	 * 
	 *  @return the current title of the chart
	 */
	public annotation.AbstractAnnotation getTitle() {
	}

	/**
	 *  Specify the title of the chart
	 * 
	 *  @param title the new title label for the chart
	 */
	public void setTitle(annotation.AbstractLabel title) {
	}

	/**
	 *  Returns the total size that data sets must be before switching to lazy rendering
	 * 
	 *  @return the lazy rendering total
	 */
	public int getLazyRenderingThreshold() {
	}

	/**
	 *  How large does a data set have to be before we switch into lazy rendering mode?
	 * 
	 *  @param lazyRenderingThreshold the total number of points in all the loaded chart models before Chart starts using
	 *                                lazy rendering. If this value is set to zero, then Chart automatically uses lazy
	 *                                rendering.
	 */
	public void setLazyRenderingThreshold(int lazyRenderingThreshold) {
	}

	public LazyRenderer getLazyChartRenderer() {
	}

	/**
	 *  Specify the lazy chart renderer to use
	 * 
	 *  @param lazyChartRenderer the lazy renderer of charts
	 */
	public void setLazyChartRenderer(LazyRenderer lazyChartRenderer) {
	}

	public void setLazyChartRenderer(LazyRenderer lazyChartRenderer, boolean autoRefresh) {
	}

	/**
	 *  Returns a boolean to indicate whether lazy rendering is currently being used
	 * 
	 *  @return a boolean to indicate whether lazy rendering is currently being used
	 */
	public boolean isLazyRendering() {
	}

	/**
	 *  First removes any models held by this object, then sets the supplied model as the single known model. You can
	 *  still add more models by calling addModel
	 * 
	 *  @param model the model to add
	 */
	public void setModel(model.ChartModel model) {
	}

	/**
	 *  First removes any models held by this object, then sets the supplied model as the single known model with the
	 *  supplied style
	 * 
	 *  @param model the model to add
	 *  @param style the style of the model
	 */
	public void setModel(model.ChartModel model, style.ChartStyle style) {
	}

	/**
	 *  Adds the supplied ChartModel to the Chart so that it is drawn in the chart area. <p>The Chart instance should not
	 *  already contain the supplied ChartModel.</p>
	 * 
	 *  @param newModel the <code>ChartModel</code> being added
	 */
	public Chart addModel(model.ChartModel newModel) {
	}

	/**
	 *  Adds the supplied ChartModel to the Chart, but does not force a repaint. This means that multiple models can be
	 *  added to the chart and we can perform an update after they have all been added.
	 * 
	 *  @param model the model to add to the chart
	 *  @param makeDirty a boolean flag to indicate whether the chart should be marked as 'dirty' and in need of a repaint
	 */
	public Chart addModel(model.ChartModel model, boolean makeDirty) {
	}

	/**
	 *  Adds the supplied ChartModel to the Chart, also assigning the supplied style to the chart. <p>Note that storing
	 *  the style directly without making a separate call to <code>setStyle</code> potentially saves a screen update, as
	 *  setStyle causes a repaint() itself.</p>
	 * 
	 *  @param model the new ChartModel to display
	 *  @param style the style of the added ChartModel
	 *  @return the Chart
	 */
	public Chart addModel(model.ChartModel model, style.ChartStyle style) {
	}

	/**
	 *  Adds the supplied ChartModel to the Chart, also assigning the model to the supplied axis. This means that the
	 *  model will be rescaled whenever the axis is rescaled.
	 * 
	 *  @param model the model to add to the Chart
	 *  @param axis the (y) axis to which the model is assigned
	 *  @return the Chart
	 */
	public Chart addModel(model.ChartModel model, axis.Axis axis) {
	}

	/**
	 *  Adds the supplied ChartModel to the Chart, also assigning the model to the supplied axis. This means that the
	 *  model will be rescaled whenever the axis is rescaled. <p>Note that storing the style directly without making a
	 *  separate call to <code>setStyle</code> potentially saves a screen update, as setStyle causes a repaint()
	 *  itself.</p>
	 * 
	 *  @param model the model to add to the chart
	 *  @param axis the (y) axis to which the model is assigned
	 *  @param style the style with which to paint the chart
	 *  @return the Chart
	 */
	public Chart addModel(model.ChartModel model, axis.Axis axis, style.ChartStyle style) {
	}

	/**
	 *  @return the first <code>ChartModel</code>. Useful when we can safely assume that there is only one. Returns null
	 *          if there are no <code>ChartModel</code>s.
	 */
	public model.ChartModel getModel() {
	}

	/**
	 *  @param i - zero based index
	 *  @return the ith <code>ChartModel</code>
	 */
	public model.ChartModel getModel(int i) {
	}

	/**
	 *  Returns the model with the specified name; null otherwise
	 * 
	 *  @param modelName the name of the chart model to retrieve
	 *  @return the ChartModel with the specified name
	 */
	public model.ChartModel getModel(String modelName) {
	}

	public java.util.List getModels() {
	}

	/**
	 *  The number of chart models currently loaded into the chart component
	 * 
	 *  @return the number of models
	 */
	public int modelCount() {
	}

	/**
	 *  @return the total number of points contained in all the known models
	 */
	public int pointCount() {
	}

	/**
	 *  Asserts that the supplied model should be plotted against the supplied axis rather than the default axis
	 * 
	 *  @param model the model whose axis we are setting
	 *  @param axis the (y) axis to associate with the model
	 */
	public void setModelAxis(model.ChartModel model, axis.Axis axis) {
	}

	public axis.Axis getAxisForModel(model.ChartModel model) {
	}

	public javax.swing.ListSelectionModel getSelectionsForModel(model.ChartModel model) {
	}

	public void setSelectionsForModel(model.ChartModel chartModel, javax.swing.ListSelectionModel selectionModel) {
	}

	public UserToPixelTransform getTransformForModel(model.ChartModel model) {
	}

	/**
	 *  Applies the supplied chart style to the specified chart model
	 * 
	 *  @param model the chart model
	 *  @param style the chart style to apply to the model
	 */
	public void setStyle(model.ChartModel model, style.ChartStyle style) {
	}

	/**
	 *  Applies the supplied chart style to the specified chart model, and additionally allows the caller to specify
	 *  whether the change should trigger a repaint.
	 * 
	 *  @param model     the chart model
	 *  @param style     the chart style to apply to the model
	 *  @param makeDirty whether the component should become 'dirty' and therefore in need of a repaint
	 */
	public void setStyle(model.ChartModel model, style.ChartStyle style, boolean makeDirty) {
	}

	/**
	 *  Returns the Chart Style associated with the supplied chart model, or null if there is no style associated with
	 *  the model. The ChartModel must have a non-null name; otherwise a NullPointerException i
	 * 
	 *  @param model the chart model
	 *  @return a Chart Style
	 *  @throws NullPointerException if the supplied chart model is null or the name of the model is null
	 */
	public style.ChartStyle getStyle(model.ChartModel model) {
	}

	/**
	 *  Specifies a ChartStyle to be associated with the given <code>Highlight</code>
	 * 
	 *  @param highlight the highlight to which we are attaching a ChartStyle
	 *  @param style     the ChartStyle associated with the Highlight
	 */
	public void setHighlightStyle(model.Highlight highlight, style.ChartStyle style) {
	}

	/**
	 *  Retrieves the ChartStyle associated with the supplied highlight
	 * 
	 *  @param h the highlight of interest
	 *  @return the ChartStyle associated with the highlight, or null if none present
	 */
	public style.ChartStyle getHighlightStyle(model.Highlight h) {
	}

	/**
	 *  Removes all known highlights and their associated styles from this class
	 * 
	 *  @return this Chart instance
	 */
	public Chart clearHighlights() {
	}

	/**
	 *  Returns a boolean to indicate whether the supplied model is known to this Chart instance
	 * 
	 *  @param model the model of interest
	 *  @return a boolean to indicate whether the supplied model is known
	 */
	public boolean containsModel(model.ChartModel model) {
	}

	/**
	 *  <p>Removes the chart model from the chart.</p> <p>Note that for this to work successfully, the hashCode() and
	 *  equals() methods on the ChartModel class must be correctly implemented so if you notice your models are not being
	 *  properly removed, this would be the first thing to check for.</p>
	 * 
	 *  @param model the model to remove
	 */
	public Chart removeModel(model.ChartModel model) {
	}

	/**
	 *  Allows you to replace an existing chart model with a new instance with the same model name. This can be used to
	 *  quickly swap one model for another; for example when changing the resolution of a data set as part of a drill
	 *  down operation.
	 * 
	 *  @param oldModel the old model
	 *  @param newModel the new model
	 */
	public Chart replaceModel(model.ChartModel oldModel, model.ChartModel newModel) {
	}

	/**
	 *  Stops any background drawing, and removes all the known ChartModels by repeated calls to removeModel()
	 */
	public Chart removeModels() {
	}

	@java.lang.Override
	protected void paintComponent(java.awt.Graphics g) {
	}

	/**
	 *  This fixes a painting problem with the shadow rendering code when a tool tip disappears. We issue a repaint
	 *  request when the tool tip disappears. See forum posting from Fri Jan 08, 2010
	 */
	@java.lang.Override
	public javax.swing.JToolTip createToolTip() {
	}

	public void paintYAxisTicks(java.awt.Graphics g, axis.Axis axis, java.awt.Point midPoint, int xPixelCoord) {
	}

	protected void paintHorizontalGrid(java.awt.Graphics g, axis.Axis axis, UserToPixelTransform transform) {
	}

	protected void paintYAxisTicks(java.awt.Graphics g, axis.Axis axis, UserToPixelTransform transform, java.awt.Point midPoint, int xPixelCoord) {
	}

	/**
	 *  Paints a string but only if the whole of the string will be visible according to the bounds of the component
	 * 
	 *  @param g the <code>Graphics</code> context
	 *  @param s the string to draw
	 *  @param x the bottom left x coordinate of the drawn string
	 *  @param y the bottom left y coordinate of the drawn string
	 *  @return a boolean to indicate whether the string was actually drawn
	 */
	protected boolean drawStringIfWithinBounds(java.awt.Graphics g, String s, int x, int y) {
	}

	/**
	 *  @param g        the Graphics context into which to draw
	 *  @param s        the string to draw
	 *  @param x        the x coordinate of the centre of where the string should be drawn
	 *  @param y        the y coordinate of the centre of where the string should be drawn
	 *  @param rotation the rotation to use, in radians
	 *  @return a boolean to indicate whether the string was drawn
	 */
	protected boolean drawRotatedStringIfWithinBounds(java.awt.Graphics g, String s, int x, int y, double rotation) {
	}

	/**
	 *  Draws a tick label onto the Graphics context. You should not need to call this method directly.
	 * 
	 *  @param g    the Graphics context into which to draw
	 *  @param axis the Axis from which the tick comes. This is needed so we can find out the orientation and placement
	 *              for the text
	 *  @param s    the text string to draw
	 *  @param x    the x coordinate of the tick
	 *  @param y    the y coordinate of the tick
	 */
	public void drawXAxisTickLabel(java.awt.Graphics g, axis.Axis axis, String s, int x, int y) {
	}

	/**
	 *  Paint a single Y axis
	 * 
	 *  @param g         the Graphics context
	 *  @param axis      the y axis to paint
	 *  @param xPosition the xPosition at which to paint the axis
	 */
	protected void paintYAxis(java.awt.Graphics2D g, axis.Axis axis, int xPosition) {
	}

	/**
	 *  Paints the X axis onto the Graphics context
	 * 
	 *  @param g the graphics context
	 */
	protected void paintXAxis(java.awt.Graphics2D g) {
	}

	/**
	 *  Returns the tick color to use when painting (a major tick) on an axis. This color is given by the tick color
	 *  property unless it has been overridden by the tickColor property of the given axis. If the tick color property is
	 *  null this method returns a default color of darkGray.
	 * 
	 *  @param axis the axis whose tick color is to be determined
	 *  @return the Color to use for ticks of the supplied axis
	 */
	protected java.awt.Color getTickColor(axis.Axis axis) {
	}

	/**
	 *  Finds the minor tick color to use for the supplied axis. If the axis does not explicitly set a minor tick color,
	 *  then the major tick color is used instead.
	 * 
	 *  @param axis the axis whose minor tick color is to be determined
	 *  @return the Color to use for minor ticks of the supplied axis
	 */
	protected java.awt.Color getMinorTickColor(axis.Axis axis) {
	}

	protected void paintXAxisTicks(java.awt.Graphics2D g, axis.Tick[] ticks) {
	}

	protected void paintXAxisGridLines(java.awt.Graphics2D g, axis.Tick[] ticks) {
	}

	/**
	 *  Paint all axes
	 * 
	 *  @param g the Graphics context onto which the axis will be painted The axis width needs to be calculated as the
	 *           width of a tick plus the width of a tick label
	 */
	protected void paintAxes(java.awt.Graphics2D g) {
	}

	/**
	 *  Paint all y axis tick labels
	 * 
	 *  @param g the Graphics context onto which the axis will be painted The axis width needs to be calculated as the
	 *           width of a tick plus the width of a tick label
	 */
	protected void paintYAxisLabels(java.awt.Graphics2D g) {
	}

	protected void drawYAxisTickLabel(java.awt.Graphics g, axis.Axis yAxis, String s, int x, int y) {
	}

	/**
	 *  Returns the nearest point to a specified pixel point from a given ChartModel. To find the nearest point we need
	 *  only to compute the distance squared to each of the other points - no need to take the square root
	 * 
	 *  @param hitPoint the pixel point of interest
	 *  @param model the ChartModel of interest
	 *  @return the nearest point in a model to the specified pixel point, or null if a nearest point could not be found
	 */
	public event.PointSelection nearestPoint(java.awt.Point hitPoint, model.ChartModel model) {
	}

	/**
	 *  Note that the current implementation may take some time to execute for larger data sets. This will be optimized
	 *  in a future release.
	 * 
	 *  @return the nearest model to the last known cursor point, or null if a nearest model could not be found.
	 */
	public model.ChartModel nearestModel(java.awt.Point p) {
	}

	/**
	 *  We need to specify which model the point belongs to, so that we know which axis and therefore which point ranges
	 *  to apply.
	 * 
	 *  @return whether the point is within the viewable region of the chart
	 */
	public boolean isUserPointViewable(java.awt.geom.Point2D userPoint, model.ChartModel model) {
	}

	public boolean isPixelPointViewable(int x, int y) {
	}

	/**
	 *  Returns the nearest point in a model to the specified real point. Note that this calculates the nearest point in
	 *  user coordinates rather than pixel coordinates and therefore, depending on the scaling of the axes, may produce
	 *  correct, but unexpected, results. Consider using <code>nearestPoint(Point, ChartModel)</code> instead.
	 * 
	 *  @param realPoint the position of the point of interest in user coordinates
	 *  @param model the ChartModel of interest
	 *  @return the nearest point
	 */
	public util.Pair nearestPoint(java.awt.geom.Point2D realPoint, model.ChartModel model) {
	}

	public static double distanceSq(java.awt.geom.Point2D point, model.Chartable chartable) {
	}

	public static double distance(java.awt.geom.Point2D point, model.Chartable chartable) {
	}

	/**
	 *  Calculate the pixel coordinates of a point using the default y axis.
	 * 
	 *  @return the Point calculated in pixel space (i.e., pixel coordinates) or null if the point cannot be calculated.
	 */
	public java.awt.Point calculatePixelPoint(java.awt.geom.Point2D userPoint) {
	}

	/**
	 *  Calculate the pixel coordinates of a point using the default y axis.
	 * 
	 *  @return the Point2D calculated in pixel space (i.e., pixel coordinates) or null if the point cannot be
	 *          calculated.
	 */
	public java.awt.geom.Point2D calculatePixelPoint2D(java.awt.geom.Point2D userPoint) {
	}

	/**
	 *  Calculate the pixel coordinates of a point using the supplied y axis
	 * 
	 *  @param userPoint the point in user coordinates
	 *  @param axis      the y axis used for the y value
	 *  @return a pixel point
	 */
	public java.awt.Point calculatePixelPoint(java.awt.geom.Point2D userPoint, axis.Axis axis) {
	}

	/**
	 *  Calculate the pixel coordinates of a point using the supplied y axis
	 * 
	 *  @param userPoint the point in user coordinates
	 *  @param axis      the y axis used for the y value
	 *  @return a pixel point
	 */
	public java.awt.geom.Point2D calculatePixelPoint2D(java.awt.geom.Point2D userPoint, axis.Axis axis) {
	}

	/**
	 *  Calculates the pixel point using the supplied transform. There is a transform associated with each y axis and you
	 *  can retrieve it using <code>getTransformForAxis()</code> or <code>getTransformForModel(ChartModel model)</code>.
	 * 
	 *  @param userPoint the point in user coordinates
	 *  @param transform the transform used for the calculation. You do not create these, but retrieve them using the
	 *                   supplied methods (see above).
	 *  @return a pixel point, or null if the pixel point cannot be computed
	 */
	public java.awt.Point calculatePixelPoint(java.awt.geom.Point2D userPoint, UserToPixelTransform transform) {
	}

	public java.awt.geom.Point2D calculatePixelPoint2D(java.awt.geom.Point2D userPoint, UserToPixelTransform transform) {
	}

	/**
	 *  Calculates the point in the user's coordinate system for the pixel coordinate given by <code>p</code>. TODO: We
	 *  probably need a version of this method that accepts an axis, and uses the conversion appropriate for that axis.
	 * 
	 *  @param p the point in pixel coordinates
	 *  @return the point calculated in user space; or null if this cannot be computed
	 */
	public java.awt.geom.Point2D calculateUserPoint(java.awt.Point p) {
	}

	/**
	 *  Converts a point scaled against the supplied yAxis to its equivalent point on the primary y axis. Note that this
	 *  will not work with a logarithmic range
	 * 
	 *  @param userY the point scaled on the supplied y axis
	 *  @param yAxis the y axis used for the supplied user point
	 *  @return the equivalent point on the primary y axis
	 */
	public double convertYToPrimary(double userY, axis.Axis yAxis) {
	}

	/**
	 *  Converts a point scaled against the primary yAxis to its equivalent point on the supplied y Axis Note that this
	 *  will not work with a logarithmic range
	 * 
	 *  @param primaryY the value on the primary y axis
	 *  @param yAxis    the axis to which we need to convert the value
	 *  @return the converted value
	 */
	public double convertPrimaryToY(double primaryY, axis.Axis yAxis) {
	}

	protected void paintModels(java.awt.Graphics2D g, java.awt.Graphics2D shadowGraphics, java.awt.Shape clipBounds, java.awt.Shape chartAreaClip) {
	}

	/**
	 *  Returns the Affine Transform associated with the given y axis
	 * 
	 *  @param yAxis the y axis for which we are retrieving the transform
	 *  @return the AffineTransform associated with the given y axis
	 */
	public UserToPixelTransform getTransformForAxis(axis.Axis yAxis) {
	}

	protected void paintAnnotations(java.awt.Graphics2D g) {
	}

	/**
	 *  @return the current animation position. A value of 1.0 indicates that animation has finished.
	 */
	public double getAnimationPosition() {
	}

	/**
	 *  Specify the animation position as a value from 0 (the initial position) to 1 (the final position). You don't need
	 *  to call this method, except if you want to implement a custom animation strategy.
	 */
	public void setAnimationPosition(double position) {
	}

	/**
	 *  @return a boolean to indicate whether animation is currently switched on
	 */
	public boolean isAnimateOnShow() {
	}

	/**
	 *  Specify whether the chart should updateChart the appearance of the chart when first shown
	 */
	public void setAnimateOnShow(boolean animateOnShow) {
	}

	/**
	 *  Explicitly start the animation
	 */
	public void startAnimation() {
	}

	/**
	 *  Explicitly stop the animation
	 */
	public void stopAnimation() {
	}

	/**
	 *  Transforms an input x value to a value used during the animateOnShow phase
	 * 
	 *  @param inputX a pixel x coordinate
	 *  @param model  the chart model that uses the x coordinate
	 *  @return the interpolated x value
	 */
	public int interpolateXForAnimation(int inputX, model.ChartModel model) {
	}

	/**
	 *  Transforms an input y value to a value used during the animateOnShow phase
	 * 
	 *  @param inputY a pixel y coordinate
	 *  @param model  the chart model that uses the y coordinate
	 *  @return the interpolated y value
	 */
	public int interpolateYForAnimation(int inputY, model.ChartModel model) {
	}
}
