/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  The primary chart types. Different chart types cannot be mixed in the same chart display. In practise, most charts
 *  will be of the XY type, as this includes line charts, scatter charts, bar charts etc.
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public final class ChartType extends Enum {

	/**
	 * 
	 *  An XY chart 
	 */
	public static final ChartType XY;

	/**
	 *  A Pie Chart 
	 */
	public static final ChartType PIE;

	public static ChartType[] values() {
	}

	public static ChartType valueOf(String name) {
	}
}
