/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  A class that computes appropriate ranges for the x and y axes of a chart.
 *  By default the leading and trailing margin proportions for the x and y ranges are 10% of the difference between
 *  the maximum and the minimum (that is, the value is 0.1).
 *  If required, you can fix corner points of the x and y axes - for example to make sure the origin of the chart is
 *  at (0, 0) while allowing the maximum values to be auto-ranged.
 * 
 *  <p>Note that if you are using multiple y axes, these are 'bound' together by the rescaling procedure. This
 *  is intended for the case where, say, one axis shows Celsius and the other one Fahrenheit. In this case you
 *  want both axes to be rescaled together. If you want the rescaling of the axes to be more independent, try
 *  using the ZeroAlignedAutoRanger instead.
 *  </p>
 */
public class DefaultAutoRanger extends AbstractAutoRanger {

	/**
	 *  Creates an auto ranger that does not constrain any of the corner points of the x or y axes, and with
	 *  default values for the leading and trailing margin proportions.
	 */
	public DefaultAutoRanger() {
	}

	/**
	 *  This constructor allows you to fix one or more parts of the ranges that are returned. A common
	 *  example of this would be when you are plotting a bar chart and you always want the minimum y value to be 0.
	 *  If you provide null as any of the values here, that part of the returned range is not fixed and an auto-range
	 *  value is computed as normal.
	 * 
	 *  @param fixMinX the fixed value for min x, or null to compute value automatically
	 *  @param fixMinY the fixed value for min y, or null to compute value automatically
	 *  @param fixMaxX the fixed value for max x, or null to compute value automatically
	 *  @param fixMaxY the fixed value for max y, or null to compute value automatically
	 */
	public DefaultAutoRanger(Double fixMinX, Double fixMinY, Double fixMaxX, Double fixMaxY) {
	}

	/**
	 *  Computes appropriate x and y ranges for the supplied chart instance and applies them to the chart.
	 * 
	 *  @param chart the chart instance for which the ranges should be calculated
	 *  @return Ranges that can be used for the x and y axes of the supplied chart
	 */
	public util.Pair getRanges(Chart chart) {
	}
}
