/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  <p>A <code>Drawable</code> that fills in the gap between two models to generate a chart.</p>
 *  <p>Here is an example of a chart that uses a DifferenceMarker:</p>
 *  <img src="doc-files/DifferenceMarker-1.png" alt="Difference Marker Screenshot"/>
 *  <p>Note that this class assumes the points of the model are already ordered by their <i>x</i> values.</p>
 */
public class DifferenceMarker implements Drawable, Frontable, Shadowable {

	public static final String PROPERTY_AT_FRONT = "At Front";

	public static final String PROPERTY_MODEL1 = "Model1";

	public static final String PROPERTY_MODEL2 = "Model2";

	public static final String PROPERTY_CHART = "Chart";

	public static final String PROPERTY_MODEL1_DOMINANT_FILL = "Model1 Dominant Fill";

	public static final String PROPERTY_MODEL2_DOMINANT_FILL = "Model2 Dominant Fill";

	/**
	 *  If you use this constructor, don't forget that you will still have to call <code>setChart()</code>
	 *  before it will work. 
	 */
	public DifferenceMarker() {
	}

	/**
	 *  Constructs a DifferenceMarker for the supplied Chart instance
	 *  @param chart the Chart instance to which the DifferenceMarker will be applied
	 */
	public DifferenceMarker(Chart chart) {
	}

	/**
	 *  Constructs a DifferenceMarker for the supplied Chart instance and using the
	 *  two supplied ChartModels 
	 *  @param chart the Chart instance to which the DifferenceMarker will be applied
	 *  @param model1 a model used for constructing the DifferenceMarker
	 *  @param model2 a model used for constructing the DifferenceMarker
	 */
	public DifferenceMarker(Chart chart, model.ChartModel model1, model.ChartModel model2) {
	}

	/**
	 *  Add a listener to property changes on this object
	 *  @param listener the PropertyChangeListener
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove a previously-added PropertyChangeListener from this object
	 *  @param listener the PropertyChangeListener
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns the <code>Chart</code> to which this marker is applied
	 *  @return the <code>Chart</code> object
	 */
	public Chart getChart() {
	}

	/**
	 *  Specify the chart to which this marker is applied
	 *  @param chart the <code>Chart</code> object
	 */
	public void setChart(Chart chart) {
	}

	/**
	 *  Returns the first <code>ChartModel</code> used by the marker
	 *  @return the <code>ChartModel</code> object
	 */
	public model.ChartModel getModel1() {
	}

	/**
	 *  Specify the first ChartModel
	 *  @param model1 the first ChartModel
	 */
	public void setModel1(model.ChartModel model1) {
	}

	/**
	 *  Returns the second <code>ChartModel</code> used by the marker
	 *  @return the <code>ChartModel</code> object
	 */
	public model.ChartModel getModel2() {
	}

	/**
	 *  Specify the second ChartModel
	 *  @param model2 the second ChartModel
	 */
	public void setModel2(model.ChartModel model2) {
	}

	public boolean isSmooth() {
	}

	public void setSmooth(boolean smooth) {
	}

	public double getSmoothness() {
	}

	public void setSmoothness(double smoothness) {
	}

	/**
	 *  Returns the Shape constructed by the DifferenceMarker
	 *  @return the Shape of the DifferenceMarker
	 */
	public java.awt.Shape getDifferenceShape() {
	}

	/**
	 *  Returns the paint filling used when model1 &gt; model2
	 *  @return the <code>Paint</code> filling
	 */
	public java.awt.Paint getModel1DominantFill() {
	}

	/**
	 *  Specify the paint to use when model1 &gt; model2. If set to null the area will not be filled.
	 *  @param fill the <code>Paint</code> (or <code>Color</code>) filling
	 */
	public void setModel1DominantFill(java.awt.Paint fill) {
	}

	/**
	 *  Returns the paint filling used when model1 &lt; model2
	 *  @return the <code>Paint</code> filling
	 */
	public java.awt.Paint getModel2DominantFill() {
	}

	/**
	 *  Specify the paint to use when model1 &lt; model2. If set to null the area will not be filled.
	 *  @param fill the <code>Paint</code> (or <code>Color</code>) filling
	 */
	public void setModel2DominantFill(java.awt.Paint fill) {
	}

	/**
	 *  Convenience method for setting the model1Dominant and model2Dominant fills to be the same
	 *  @param fill the new <code>Paint</code> to use for regions between model1 and model2
	 */
	public void setFill(java.awt.Paint fill) {
	}

	/**
	 *  Recomputes the positions of the fill and clipping regions
	 */
	protected void update() {
	}

	/**
	 *  The <code>Drawable</code> callback method
	 */
	public void draw(java.awt.Graphics g) {
	}

	/**
	 *  A method of the <code>Frontable</code> interface. By default returns false so the filling is drawn behind any lines. 
	 *  @return whether the marker should be drawn in front of the Chart Models
	 */
	public boolean isAtFront() {
	}

	/**
	 *  Specify whether the DifferenceMarker should be drawn in front or behind of the ChartModels
	 */
	public void setAtFront(boolean atFront) {
	}

	/**
	 *  Discover whether this object is being drawn with a shadow
	 *  @return a boolean to indicate whether this object is being drawn with a shadow
	 */
	public boolean isShadowVisible() {
	}

	/**
	 *  Specify whether this object should be drawn with a shadow
	 *  @param shadowVisible whether the object should have a shadow
	 */
	public void setShadowVisible(boolean shadowVisible) {
	}
}
