/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  This is a callback mechanism so that arbitrary shapes can be drawn in the context of some other object (in particular
 *  a Chart instance). The drawable object knows how to draw itself, but another object decides when the Drawable should
 *  be drawn. This is a very flexible mechanism, as the class that implements Drawable can decide how to react to GUI
 *  interactions and their corresponding events. Most importantly, objects that implement this interface can be added to
 *  a chart instance and whenever the Chart instance is painted, the draw() method of the Drawable will be called.
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public interface Drawable {

	/**
	 *  Draw the object implementing this interface onto the supplied Graphics context
	 *  @param g the Graphics context
	 */
	public void draw(java.awt.Graphics g);
}
