/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  Drawables can be painted behind the chart models of a Chart or in front of them. If a Drawable object implements 
 *  this interface then it can also specify whether it should be behind or at the front.
 *  @see Drawable
 */
public interface Frontable {

	/**
	 *  Whether the object is to drawn at the front (i.e. in front of ChartModels)
	 *  @return true if the object is to be drawn at the front; false if to be drawn at the back
	 */
	public boolean isAtFront();

	/**
	 *  Specify whether the object should be drawn at the front: <code>setAtFront(true)</code> is like a 
	 *  <code>toFront()</code> request, but conforms to the JavaBean property pattern. Similarly, to send
	 *  an object to the back, call <code>setAtFront(false)</code>. 
	 *  @param atFront whether the object is to be shown in front of ChartModels.
	 */
	public void setAtFront(boolean atFront);
}
