/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  A Drawable object that can be added to a Chart to mark an interval on one of the axes.
 *  The orientation determines whether the interval applies to the x or y axis.
 *  By default, the orientation is vertical.
 *  <p>
 *  Note that if an IntervalMarker is used in a Chart that is embedded in a JViewport, the position of the label for
 *  the marker does not change under scrolling relative to the marker. In other words, the marker label always
 *  stays on screen as long as the marker itself is visible.  
 *  </p>
 */
public class IntervalMarker implements Drawable, Frontable, Shadowable, ZOrder {

	/**
	 *  The name of the property to indicate whether the IntervalMarker is visible
	 */
	public static final String PROPERTY_VISIBLE = "Visible";

	/**
	 *  The name of the property that indicates the orientation of the IntervalMarker 
	 */
	public static final String PROPERTY_ORIENTATION = "Orientation";

	/**
	 *  The name of the property that holds the corresponding chart
	 */
	public static final String PROPERTY_CHART = "Chart";

	/**
	 *  The name of the property used for the color of the marker (same as paint if the paint is a java.awt.Color)
	 */
	public static final String PROPERTY_COLOR = "Color";

	/**
	 *  The name of the property used for the paint of the marker
	 */
	public static final String PROPERTY_PAINT = "Paint";

	/**
	 *  The name of the property used for the upper limit of the interval marker
	 */
	public static final String PROPERTY_MAX = "Maximum";

	/**
	 *  The name of the property used for the lower limit of the interval marker
	 */
	public static final String PROPERTY_MIN = "Minimum";

	/**
	 *  The name of the property used for the label of the IntervalMarker
	 */
	public static final String PROPERTY_LABEL = "Label";

	/**
	 *  The name of the property used for the placement of the label
	 */
	public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";

	/**
	 *  The name of the property used for the color of the label
	 */
	public static final String PROPERTY_LABEL_COLOR = "Label Color";

	/**
	 *  The name of the property used for the font of the label
	 */
	public static final String PROPERTY_LABEL_FONT = "Label Font";

	/**
	 *  The name of the property used to indicate whether the marker is at the front or behind the chart models
	 */
	public static final String PROPERTY_AT_FRONT = "At Front";

	/**
	 *  The name of the property used for the outline color
	 */
	public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";

	/**
	 *  The name of the property used for the outline
	 */
	public static final String PROPERTY_OUTLINE_STROKE = "Outline Stroke";

	/**
	 *  The name of the property used for the shadow visibility
	 */
	public static final String PROPERTY_SHADOW_VISIBLE = "Shadow Visible";

	protected final java.beans.PropertyChangeSupport support;

	/**
	 *  Zero-argument Constructor. Usually you would create an IntervalMarker with one of the other constructors
	 *  that sets properties at object creation time.
	 */
	public IntervalMarker() {
	}

	/**
	 *  Create a marker and set the Chart object to which this marker applies
	 *  @param newChart the chart object to which this marker applies.
	 */
	public IntervalMarker(Chart newChart) {
	}

	/**
	 *  Create an IntervalMarker and set some properties
	 *  @param newChart the chart to which this marker applies
	 *  @param min the minimum value for the interval
	 *  @param max the maximum value for the interval
	 *  @param paint the color or other paint for the interval
	 */
	public IntervalMarker(Chart newChart, double min, double max, java.awt.Paint paint) {
	}

	/**
	 *  Create an IntervalMarker and set properties
	 *  @param newChart the chart to which this marker applies
	 *  @param orientation the orientation of the interval. Effectively this specifies whether the interval
	 *  applies to the x or the y axis
	 *  @param min the minimum value for the interval
	 *  @param max the maximum value for the interval
	 *  @param paint the paint fill to use for the interval
	 */
	public IntervalMarker(Chart newChart, Orientation orientation, double min, double max, java.awt.Paint paint) {
	}

	/**
	 *  Registers the interest of an object in the property changes of this object
	 *  @param listener the interested object
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  De-register the interest of an object in the property changes of this object
	 *  @param listener the object that is no longer interested in property changes
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns the Chart object with which this Interval marker is associated
	 *  @return the Chart object with which this Interval marker is associated
	 */
	public Chart getChart() {
	}

	/**
	 *  Sets the chart object that this marker will be drawn on
	 *  @param chart sets the Chart object with which this Interval marker is associated
	 */
	public void setChart(Chart chart) {
	}

	/**
	 *  Returns whether the marker object is currently visible
	 *  @return whether the marker object is currently visible
	 */
	public boolean isVisible() {
	}

	/**
	 *  Specify whether this marker object should be drawn. Sometimes it may be useful to keep it associated with
	 *  the chart but to temporarily remove it visually from the chart.
	 *  @param visible whether the marker should be drawn
	 */
	public void setVisible(boolean visible) {
	}

	/**
	 *  Returns the color of the marker object. If a paint is used that is not a color, this returns null.
	 *  @return the color of the marker object. If a paint is used that is not a color, this returns null.
	 */
	public java.awt.Color getColor() {
	}

	/**
	 *  Specify the fill color of the marker object
	 *  @param color the fill color of the marker object
	 */
	public void setColor(java.awt.Color color) {
	}

	/**
	 *  Returns the paint used for the marker object
	 *  @return the paint used for the marker object
	 */
	public java.awt.Paint getPaint() {
	}

	/**
	 *  Specify the paint to use for the marker object. If the paint happens to be a Color, you could call
	 *  either this method or setColor - the end result is the same.
	 *  @param paint the new paint.
	 */
	public void setPaint(java.awt.Paint paint) {
	}

	/**
	 *  Returns the orientation of the interval
	 *  @return the orientation of the interval
	 */
	public Orientation getOrientation() {
	}

	/**
	 *  If the orientation of the interval is vertical it means it is applied to the x axis; if horizontal it
	 *  is applied to the y axis.
	 *  @param orientation the orientation of the interval
	 */
	public void setOrientation(Orientation orientation) {
	}

	public int getZOrder() {
	}

	public void setZOrder(int zOrder) {
	}

	/**
	 *  Returns the minimum value of the range
	 *  @return the minimum value of the range
	 */
	public double getMin() {
	}

	/**
	 *  Returns the maximum value of the range
	 *  @return the maximum value of the range
	 */
	public double getMax() {
	}

	/**
	 *  Specify the minimum value for the interval
	 *  @param min the new minimum
	 */
	public void setMin(double min) {
	}

	/**
	 *  Specify the maximum value for the interval
	 *  @param max the new maximum
	 */
	public void setMax(double max) {
	}

	/**
	 *  Sets the interval with minimum and maximum values
	 *  @param min the new minimum for the interval
	 *  @param max the new maximum for the interval
	 */
	public void setInterval(double min, double max) {
	}

	/**
	 *  Returns the text label associated with this marker, if any
	 *  @return the text label associated with this marker
	 */
	public String getLabel() {
	}

	/**
	 *  Specify a text label for the marker
	 */
	public void setLabel(String label) {
	}

	/**
	 *  Returns the current positioning of the label
	 *  @return the current positioning of the label
	 */
	public LabelPlacement getLabelPlacement() {
	}

	/**
	 *  Specify where to place the label, if one has been provided. 
	 *  By default the label is placed in the centre of the IntervalMarker.
	 *  @param labelPlacement where to place the label
	 */
	public void setLabelPlacement(LabelPlacement labelPlacement) {
	}

	/**
	 *  Returns the current color setting for the label
	 *  @return the current color setting for the label
	 */
	public java.awt.Color getLabelColor() {
	}

	/**
	 *  Specify the color to use for the label. The default color is black. 
	 *  @param labelColor the color to use for the label
	 */
	public void setLabelColor(java.awt.Color labelColor) {
	}

	/**
	 *  Returns the font used for displaying the label
	 *  @return the font used for displaying the label
	 */
	public java.awt.Font getLabelFont() {
	}

	/**
	 *  Specify the font used for displaying the label [optional]
	 *  @param labelFont the font for the label
	 */
	public void setLabelFont(java.awt.Font labelFont) {
	}

	/**
	 *  Returns the color used for the outline (if there is one). If no outline is being used, this returns null.
	 *  @return the color of the outline, or null if no color is being used
	 */
	public java.awt.Color getOutlineColor() {
	}

	/**
	 *  Specify an outline color for the marker
	 *  @param outlineColor the color to be used for the outline
	 */
	public void setOutlineColor(java.awt.Color outlineColor) {
	}

	/**
	 *  Returns the stroke used for the outline
	 *  @return the stroke used for the outline
	 */
	public java.awt.Stroke getOutlineStroke() {
	}

	/**
	 *  Specify a stroke to use for the outline of the marker. If not supplied, a default Stroke is used
	 *  with a solid line of width 1.
	 *  @param outlineStroke the stroke to use for the outline
	 */
	public void setOutlineStroke(java.awt.Stroke outlineStroke) {
	}

	/**
	 *  The callback method to draw the object. It cannot be drawn if the chart property is not set or if
	 *  either the xInterval or yInterval is null.
	 */
	public void draw(java.awt.Graphics g) {
	}

	/**
	 *  By default simply returns the paint property, but this protected method gives you an opportunity to override
	 *  this behaviour and, if required, create a Paint that varies depending on the IntervalMarker's pixel height. 
	 *  @param chart the chart instance
	 *  @param pixelYMin the pixel y value corresponding to the minimum value of the interval marker's range
	 *  @param pixelYMax the pixel y value corresponding to the maximum value of the interval marker's range
	 *  @return a Paint instance used for filling the IntervalMarker
	 */
	protected java.awt.Paint createHorizontalPaint(Chart chart, int pixelYMin, int pixelYMax) {
	}

	/**
	 *  By default simply returns the paint property, but this protected method gives you an opportunity to override
	 *  this behaviour and, if required, create a Paint that varies depending on the IntervalMarker's pixel width. 
	 *  @param chart the chart instance
	 *  @param pixelXMin the pixel x value corresponding to the minimum value of the interval marker's range
	 *  @param pixelXMax the pixel x value corresponding to the maximum value of the interval marker's range
	 *  @return a Paint instance used for filling the IntervalMarker
	 */
	protected java.awt.Paint createVerticalPaint(Chart chart, int pixelXMin, int pixelXMax) {
	}

	/**
	 *  A method of the <code>Frontable</code> interface. By default returns false so the filling is drawn behind any lines. 
	 *  @return whether the marker should be drawn in front of the Chart Models in the chart
	 */
	public boolean isAtFront() {
	}

	/**
	 *  Specify whether the marker should be drawn in front of the Chart Models in the chart
	 */
	public void setAtFront(boolean atFront) {
	}

	public boolean isShadowVisible() {
	}

	public void setShadowVisible(boolean shadowVisible) {
	}
}
