/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  A graphical component to display a legend corresponding to a Chart. Usually a Legend is generated as one entry
 *  per ChartModel displayed in the Chart, but sometimes, such as when displaying a pie chart, it is more useful to
 *  display a legend item for every point in a model. To use this mode, set the <em>generateFromPoints</em> property
 *  to be true. (See the comments on setGenerateFromPoints() for more details on how to name the items in the legend.)
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class Legend extends javax.swing.JPanel implements Drawable, Frontable {

	public static final int LEFT = 0;

	public static final int CENTER = 1;

	public static final int LEADING = 3;

	public static final int RIGHT = 2;

	public static final int TRAILING = 4;

	public static final String PROPERTY_GENERATE_FROM_POINTS = "GenerateFromPoints";

	public static final String PROPERTY_TITLE = "title";

	public static final String PROPERTY_TITLE_COLOR = "titleColor";

	public static final String PROPERTY_COLUMNS = "columns";

	public static final String PROPERTY_KEY_LABEL_GAP = "keyLabelGap";

	public static final String PROPERTY_LABEL_COLOR = "labelColor";

	public static final String PROPERTY_LEGEND_BACKGROUND = "legendBackground";

	public static final String PROPERTY_ORDER_REVERSED = "order reversed";

	public static final String PROPERTY_AT_FRONT = "At Front";

	public static final String PROPERTY_TITLE_LABEL = "Title Label";

	public static final String PROPERTY_ROLLOVER_MODEL = "Rollover Model";

	/**
	 *  Create a Legend object. You will need to call addChart() to specify the chart(s) to which the legend
	 *  applies.
	 */
	public Legend() {
	}

	public Legend(boolean wrap, int alignment) {
	}

	/**
	 *  Create a Legend from the supplied chart and using 1 column for the layout of the entries
	 * 
	 *  @param chart the chart for which to create a legend
	 */
	public Legend(Chart chart) {
	}

	/**
	 *  Create a Legend as a row of items that optionally wrap around when there is not enough space
	 *  @param chart the chart from which the legend items are to be taken
	 *  @param wrap whether to allow legend items to wrap around to the next row
	 */
	public Legend(Chart chart, boolean wrap) {
	}

	/**
	 *  Create a Legend as a row of items. If <code>wrap</code> is set to true, then the alignment parameter
	 *  is used in the layout.
	 *  @param chart the chart from which the legend items are to be taken
	 *  @param wrap whether to allow legend items to wrap around to the next row
	 *  @param alignment when wrap is true, the horizontal alignment used for legend items. One of LEFT, CENTER, RIGHT, LEADING or TRAILING.
	 * 
	 *  @see #LEFT
	 *  @see #RIGHT
	 *  @see #CENTER
	 *  @see #LEADING
	 *  @see #TRAILING
	 */
	public Legend(Chart chart, boolean wrap, int alignment) {
	}

	/**
	 *  Create a Legend from the supplied chart and using the supplied number of columns
	 * 
	 *  @param chart the chart for which to create a legend
	 *  @param cols  the number of columns to use in the layout of the legend
	 */
	public Legend(Chart chart, int cols) {
	}

	/**
	 *  Returns the pixel gap between each graphical key item and its label in the legend
	 *  @return the pixel gap between each graphical key item and its label in the legend
	 */
	public int getKeyLabelGap() {
	}

	/**
	 *  Specify the gap in pixels between each graphical key item and its label in the legend
	 *  @param keyLabelGap the gap in pixels
	 */
	public void setKeyLabelGap(int keyLabelGap) {
	}

	/**
	 *  Returns the Paint used for the legend background. If the legendBackground property has never been set,
	 *  the method returns the Color that is also returned by getBackground()
	 *  @return the Paint used for the Legend background.
	 */
	public java.awt.Paint getLegendBackground() {
	}

	/**
	 *  Specifies the Paint to use for the background of the Legend. For example, you can use this method to set
	 *  a Gradient fill.
	 *  @param background the Paint to use for the background of the Legend
	 */
	public void setLegendBackground(java.awt.Paint background) {
	}

	/**
	 *  Returns the color used for the labels in the legend
	 * 
	 *  @return the color used for the labels in the legend
	 */
	public java.awt.Color getLabelColor() {
	}

	/**
	 *  Specify the color to use for the labels in the legend
	 * 
	 *  @param labelColor the color to use for the legend labels
	 */
	public void setLabelColor(java.awt.Color labelColor) {
	}

	/**
	 *  Returns the color used for the title in the legend
	 * 
	 *  @return the color used in the title of the legend
	 */
	public java.awt.Color getTitleColor() {
	}

	/**
	 *  Specifies the color to use for the title of the legend
	 * 
	 *  @param titleColor the color to use in the title of the legend
	 */
	public void setTitleColor(java.awt.Color titleColor) {
	}

	/**
	 *  Exclude the supplied models from the Legend
	 * 
	 *  @param models the models to exclude from the Legend
	 */
	public void addExcludedModels(model.ChartModel[] models) {
	}

	/**
	 *  Remove the supplied models from the set of models that have been excluded from the Legend
	 * 
	 *  @param models the models to remove the excluded set
	 */
	public void removeExcludedModels(model.ChartModel[] models) {
	}

	/**
	 *  Empty out the set of excluded models
	 */
	public void clearExcludedModels() {
	}

	public Legend addIncludedModel(model.ChartModel model) {
	}

	public Legend removeIncludedModel(model.ChartModel model) {
	}

	public Legend addLegendItem(LegendItem item) {
	}

	public Legend removeLegendItem(LegendItem item) {
	}

	/**
	 *  Exclude the supplied points from the Legend (when using generateFromPoints)
	 * 
	 *  @param points the points to exclude from the Legend
	 */
	public void addExcludedPoints(model.Chartable[] points) {
	}

	/**
	 *  Remove the supplied points from the set of points to exclude from the Legend
	 * 
	 *  @param points the points to reinstate as Legend items
	 */
	public void removeExcludedPoints(model.Chartable[] points) {
	}

	/**
	 *  Empty out the set of excluded points
	 */
	public void clearExcludedPoints() {
	}

	/**
	 *  This method modifies the default behaviour of JComponent.
	 *  If the legend does not have any items to display, then the border becomes null.
	 *  This prevents an embarrassing dot from appearing next to a chart that doesn't
	 *  have any data yet. You still call this method to set the border, but it will not
	 *  appear if the chart does not have any data to display.
	 */
	@java.lang.Override
	public void setBorder(javax.swing.border.Border border) {
	}

	/**
	 *  Add a chart to the legend; i.e. allow the legend component to extract the chart models and their styles from
	 *  the supplied chart object and add them to the legend.
	 * 
	 *  @param chart the chart to add to the Legend
	 */
	public void addChart(Chart chart) {
	}

	/**
	 *  Remove the models contained by the supplied chart from the legend
	 * 
	 *  @param chart the chart for which the models should be removed
	 */
	public void removeChart(Chart chart) {
	}

	/**
	 *  Set the number of columns to use for the items in the legend. If you specify the number of columns as 0,
	 *  then there will be as many columns as there are items to display.
	 * 
	 *  @param columns the number of columns to use for items in the legend
	 */
	public void setColumns(int columns) {
	}

	/**
	 *  Clear references to all charts from this legend object.
	 */
	public void clear() {
	}

	/**
	 *  Returns the title of the legend
	 * 
	 *  @return the title of the legend
	 */
	public String getTitle() {
	}

	/**
	 *  Set the title to use for this legend. Internally, this creates a JLabel. To customize the appearance of the
	 *  label, you can either retrieve it using <code>getTitleLabel()</code> and then modify it; or create the label
	 *  yourself and supply it using the <code>setTitleLabel()</code> method.
	 * 
	 *  @param title the title to use for the legend
	 *  @see #getTitleLabel()
	 *  @see #setTitleLabel(JLabel)
	 */
	public void setTitle(String title) {
	}

	/**
	 *  Returns the title label as a component
	 * 
	 *  @return the title label
	 */
	public javax.swing.JLabel getTitleLabel() {
	}

	/**
	 *  Sets the title for this legend
	 * 
	 *  @param titleLabel the ready-made JLabel to use for the title
	 */
	public void setTitleLabel(javax.swing.JLabel titleLabel) {
	}

	/**
	 *  Returns whether the legend is generated based on points.
	 * 
	 *  @return whether the legend is generated based on the points of a chart model.
	 */
	public boolean isGenerateFromPoints() {
	}

	/**
	 *  By default a Legend will be generated as one entry per chart model that is displayed on the chart.
	 *  Sometimes, however, it makes more sense to generate one entry per point; for example for a pie chart,
	 *  where each segment represents a single point. If you are generating from points on a categorical data set,
	 *  then the names of the categories are used as the labels in the legend. Otherwise, if the Chartable instances
	 *  implement the Named interface (like <code>ChartPoint</code>, for instance), then the name is taken from the
	 *  <cite>name</cite> property of the object.
	 * 
	 *  @param generateFromPoints whether to generate the legend based on points
	 */
	public void setGenerateFromPoints(boolean generateFromPoints) {
	}

	/**
	 *  Returns whether the order of the elements is reversed or the same as the order in which
	 *  they were added to the chart.
	 * 
	 *  @return whether the order is reversed
	 */
	public boolean isOrderReversed() {
	}

	/**
	 *  Specify whether the order of iterating through the models should be reversed when
	 *  generating the legend. By default, the order is the order in which the models were added
	 *  to the Chart.
	 * 
	 *  @param orderReversed whether to reverse the order
	 */
	public void setOrderReversed(boolean orderReversed) {
	}

	/**
	 *  Sets the font to use for the Legend items
	 * 
	 *  @param font the font to use for the Legend items
	 */
	@java.lang.Override
	public void setFont(java.awt.Font font) {
	}

	/**
	 *  Recreate the legend object, taking account of the specified number of columns
	 */
	protected void updateLegend() {
	}

	protected LegendItem createPointLegendItem(model.Chartable chartable, model.ChartModel model, Chart chart) {
	}

	protected LegendItem createModelLegendItem(model.ChartModel model, Chart chart) {
	}

	protected LegendItem createModelLegendItem(model.ChartModel model, Chart chart, style.ChartStyle style) {
	}

	protected LegendPair createLegendPair(LegendItem legendItem, javax.swing.JComponent label) {
	}

	protected javax.swing.JLabel createLegendLabel(model.Chartable chartable) {
	}

	protected javax.swing.JComponent createLegendLabel(model.ChartModel model) {
	}

	protected javax.swing.JComponent createLegendLabel(String labelString) {
	}

	protected javax.swing.JLabel createLegendTitle(String titleString) {
	}

	/**
	 *  Should the Legend be drawn in front of the ChartModels when used as a Drawable?
	 * 
	 *  @return whether the Legend should be drawn in front of the ChartModels
	 */
	public boolean isAtFront() {
	}

	/**
	 *  Specify whether the Legend should appear in front of the chart models when
	 *  added as a Drawable to the chart.
	 * 
	 *  @param atFront whether the object is to be shown in front of ChartModels.
	 */
	public void setAtFront(boolean atFront) {
	}

	/**
	 *  By implementing the <code>Drawable</code> interface, it makes it possible for
	 *  a Legend to be added to be displayed within a chart rather than just next to it.
	 * 
	 *  @param g the Graphics context onto which the legend should be drawn
	 */
	public void draw(java.awt.Graphics g) {
	}

	public void paintComponent(java.awt.Graphics g) {
	}
}
