/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  LegendItems can be created to represent a ChartModel or a Chartable within a ChartModel.
 *  The ability to create a LegendItem for a Chartable is important for pie charts, as each
 *  segment is a Chartable and may have a different ChartStyle applied to it.
 */
public interface LegendItem {

	public static final int itemHeight = 20;

	public static final int itemWidth = 30;

	/**
	 *  Returns the GUI component to be displayed in the legend
	 *  @return the GUI component
	 */
	public java.awt.Component getComponent();

	public String getLabel();

	/**
	 *  For a ModelLegendItem this returns the ChartModel; for a PointLegendItem it returns the Chartable
	 *  @return either the ChartModel or the Chartable
	 */
	public Object getItem();

	/**
	 *  Returns the model item, or the model to which the Chartable item belongs
	 *  @return a ChartModel
	 */
	public Object getSource();
}
