/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  A marker that can be added to a chart and is drawn as either a horizontal or vertical line across the chart.
 *  <p>
 *  Note that if a LineMarker is used in a Chart that is embedded in a JViewport, the position of the label for
 *  the marker does not change under scrolling relative to the marker. In other words, the marker label always
 *  stays on screen as long as the marker itself is visible.  
 *  </p>
 */
public class LineMarker implements Drawable, Frontable {

	/**
	 *  The name of the property to indicate whether the IntervalMarker is visible
	 */
	public static final String PROPERTY_VISIBLE = "Visible";

	/**
	 *  The name of the property that holds the corresponding chart
	 */
	public static final String PROPERTY_CHART = "Chart";

	/**
	 *  The name of the property used for the color of the marker (same as paint if the paint is a java.awt.Color)
	 */
	public static final String PROPERTY_COLOR = "Color";

	/**
	 *  The name of the property that indicates the orientation of the IntervalMarker 
	 */
	public static final String PROPERTY_ORIENTATION = "Orientation";

	/**
	 *  The name of the property that indicates the position of the line.
	 */
	public static final String PROPERTY_POSITION = "Position";

	/**
	 *  The name of the property describing the Stroke of the line
	 */
	public static final String PROPERTY_STROKE = "Stroke";

	/**
	 *  The name of the property for the text of the label
	 */
	public static final String PROPERTY_LABEL = "Label";

	/**
	 *  The name of the property for the placement of the label
	 */
	public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";

	/**
	 *  The name of the property for the color of the label
	 */
	public static final String PROPERTY_LABEL_COLOR = "Label Color";

	/**
	 *  The name of the property for the font of the label
	 */
	public static final String PROPERTY_LABEL_FONT = "Label Font";

	/**
	 *  The name of the property that indicates whether the marker is in front of the models
	 */
	public static final String PROPERTY_AT_FRONT = "At Front";

	protected final java.beans.PropertyChangeSupport support;

	/**
	 *  Zero argument constructor. Usually you would construct a LineMarker by using one of the other constructors
	 *  that automatically set property values at object construction time.
	 */
	public LineMarker() {
	}

	/**
	 *  Create a marker and set the Chart object to which this marker applies
	 *  @param newChart the chart object to which this marker applies
	 */
	public LineMarker(Chart newChart) {
	}

	/**
	 *  Create a LineMarker and set some properties
	 *  @param newChart the chart to which this marker applies
	 *  @param orientation the orientation of the line
	 *  @param position the position on the appropriate axis
	 *  @param color the color for the line
	 */
	public LineMarker(Chart newChart, Orientation orientation, double position, java.awt.Color color) {
	}

	/**
	 *  Registers the interest of an object in property changes of the LineMarker
	 *  @param listener the object interested interested in property changes
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  De-registers the interest of an object that is already registered as a property listener
	 *  @param listener the object no longer interested in property changes
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns the text of the label
	 *  @return the text of the label
	 */
	public String getLabel() {
	}

	/**
	 *  Specify a text label for the marker
	 *  @param label the text of the label
	 */
	public void setLabel(String label) {
	}

	/**
	 *  Returns the current positioning of the label
	 *  @return the current positioning of the label
	 */
	public LabelPlacement getLabelPlacement() {
	}

	/**
	 *  Specify where to place the label, if one has been provided
	 *  @param labelPlacement the parameter that specifies where to place the label
	 */
	public void setLabelPlacement(LabelPlacement labelPlacement) {
	}

	/**
	 *  Returns the current color setting for the label
	 *  @return the current color setting for the label
	 */
	public java.awt.Color getLabelColor() {
	}

	/**
	 *  Specify the color to use for the label. If the color is not specified, the same
	 *  color will be used as for the line.
	 *  @param labelColor the color of the label
	 */
	public void setLabelColor(java.awt.Color labelColor) {
	}

	/**
	 *  Returns the font used for displaying the label
	 *  @return the font used for displaying the label
	 */
	public java.awt.Font getLabelFont() {
	}

	/**
	 *  Specify the font used for displaying the label [optional]
	 *  @param labelFont the font for the label
	 */
	public void setLabelFont(java.awt.Font labelFont) {
	}

	/**
	 *  Returns the chart object with which this marker is associated
	 *  @return the chart object with which this marker is associated
	 */
	public Chart getChart() {
	}

	/**
	 *  Specify the chart object with which this marker is associated
	 *  @param chart the chart object
	 */
	public void setChart(Chart chart) {
	}

	public void setRenderingHint(java.awt.RenderingHints.Key hint, Object value) {
	}

	/**
	 *  Returns whether the marker is currently painted onto the chart's Graphics context when an update occurs
	 *  @return whether the marker is currently painted onto the chart's Graphics context when an update occurs
	 */
	public boolean isVisible() {
	}

	/**
	 *  Specify whether the marker should be painted
	 *  @param visible the visibility of the marker
	 */
	public void setVisible(boolean visible) {
	}

	/**
	 *  Returns the color of the LineMarker
	 *  @return the color of the LineMarker
	 */
	public java.awt.Color getColor() {
	}

	/**
	 *  Specify the color for the LineMarker
	 *  @param color the new color for the line marker
	 */
	public void setColor(java.awt.Color color) {
	}

	/**
	 *  Returns the stroke used for drawing the line
	 *  @return the stroke used for drawing the line
	 */
	public java.awt.Stroke getStroke() {
	}

	/**
	 *  Specify the stroke for the line
	 *  @param stroke the new Stroke
	 */
	public void setStroke(java.awt.Stroke stroke) {
	}

	/**
	 *  Returns the orientation of the LineMarker
	 *  @return the orientation of the LineMarker
	 */
	public Orientation getOrientation() {
	}

	/**
	 *  If the orientation of the interval is vertical it means it is applied to the x axis; if horizontal it
	 *  is applied to the y axis.
	 *  @param orientation the orientation of the line
	 */
	public void setOrientation(Orientation orientation) {
	}

	/**
	 *  Returns the position of the marker along the axis
	 *  @return the position of the marker along the axis
	 */
	public double getPosition() {
	}

	/**
	 *  Specify the position of the marker along the axis
	 *  @param pos the new position
	 */
	public void setPosition(double pos) {
	}

	/**
	 *  The callback method to draw the object. It cannot be drawn if the chart property is not set or if
	 *  either the xInterval or yInterval is null.
	 */
	public void draw(java.awt.Graphics g) {
	}

	/**
	 *  A method of the <code>Frontable</code> interface. By default this returns false, unless you have set it
	 *  using the setAtFront() method. 
	 *  @return whether the line marker should be displayed in front of the chart models
	 */
	public boolean isAtFront() {
	}

	/**
	 *  You can use this method to specify whether the line marker should be drawn at the front of the
	 *  chart models or at the back.
	 *  @param atFront specify whether the marker should be drawn in front of the chart models
	 */
	public void setAtFront(boolean atFront) {
	}
}
