/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  This class maintains a separate Image for each model added to a chart. This means that the models can easily
 *  be switched off and on by way of a ChartStyle. It also means that a chart can be built up incrementally, one model
 *  at a time.
 */
public class MultiImageLazyChartRenderer implements LazyRenderer {

	public MultiImageLazyChartRenderer(Chart chart) {
	}

	public void addImageChangeListener(event.ImageChangeListener listener) {
	}

	public void removeImageChangeListener(event.ImageChangeListener listener) {
	}

	protected void fireImageChange() {
	}

	/**
	 *  @param clearAll if clearAll is set to true then all the previously painted model images are purged from memory
	 */
	public void updateCharts(boolean clearAll) {
	}

	public void cancelDrawing() {
	}

	/**
	 *  Updates the image in response to a change to an individual model; for example a change to the style for
	 *  that model.
	 * 
	 *  @param model the model for which a change occurred
	 *  @param canUseCache specify whether it is allowed to retrieve the cached Image instead of redrawing
	 */
	public void updateImage(model.ChartModel model, boolean canUseCache) {
	}

	public void removeImage(String modelName) {
	}

	public void removeImage(model.ChartModel model) {
	}

	/**
	 *  Draw the latest image (if any) into the supplied graphics context
	 */
	public void draw(java.awt.Graphics g) {
	}
}
