/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  A Drawable object that can be added to a Chart to mark a rectangular region.
 *  If you set the chart property, then the chart will automatically be repainted when the color or
 *  intervals of the region change.
 *  <p>
 *  Note that the label for a RectangularRegionMarker will always scroll when the chart is embedded in a JViewport
 *  whereas the label for a LineMarker or IntervalMarker will not scroll, but stay fixed in position relative to 
 *  the marker.</p>
 */
public class RectangularRegionMarker implements Drawable, Frontable, ZOrder {

	/**
	 *  The name used in a Property Change Event when the atFront property changes
	 */
	public static final String PROPERTY_AT_FRONT = "At Front";

	/**
	 *  The name used in a Property Change Event when the Visible property changes.
	 */
	public static final String PROPERTY_VISIBLE = "Visible";

	/**
	 *  The name used in a Property Change Event when the Color property changes
	 */
	public static final String PROPERTY_COLOR = "Color";

	/**
	 *  The name used in a Property Change Event when the Paint property changes
	 */
	public static final String PROPERTY_PAINT = "Paint";

	/**
	 *  The name used in a Property Change Event when the Chart property changes
	 */
	public static final String PROPERTY_CHART = "Chart";

	/**
	 *  The name used in a Property Change Event when the XInterval property changes
	 */
	public static final String PROPERTY_X_INTERVAL = "X Interval";

	/**
	 *  The name used in a Property Change Event when the YInterval property changes
	 */
	public static final String PROPERTY_Y_INTERVAL = "Y Interval";

	/**
	 *  The name used in a Property Change Event when the Label property changes
	 */
	public static final String PROPERTY_LABEL = "Label";

	/**
	 *  The name used in a Property Change Event when the LabelPlacement property changes
	 */
	public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";

	/**
	 *  The name used in a Property Change Event when the LabelColor property changes
	 */
	public static final String PROPERTY_LABEL_COLOR = "Label Color";

	/**
	 *  The name used in a Property Change Event when the LabelFont property changes
	 */
	public static final String PROPERTY_LABEL_FONT = "Label Font";

	/**
	 *  The name of the property used for the outline color
	 */
	public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";

	/**
	 *  The name of the property used for the outline
	 */
	public static final String PROPERTY_OUTLINE_STROKE = "Outline Stroke";

	protected final java.beans.PropertyChangeSupport support;

	/**
	 *  Zero argument constructor. Usually you would use one of the other constructors to automatically
	 *  set some of the properties at object creation time.
	 */
	public RectangularRegionMarker() {
	}

	/**
	 *  Create a marker and set the Chart object to which this marker applies
	 *  @param chart the chart object to which this marker applies.
	 */
	public RectangularRegionMarker(Chart chart) {
	}

	/**
	 *  Create a rectangular marker and set all properties
	 *  @param chart the chart to which this marker applies
	 *  @param xMin the minimum x value for the region
	 *  @param xMax the maximum x value for the region
	 *  @param yMin the minimum y value for the region
	 *  @param yMax the maximum y value for the region
	 *  @param paint the color or other paint for the region
	 */
	public RectangularRegionMarker(Chart chart, double xMin, double xMax, double yMin, double yMax, java.awt.Paint paint) {
	}

	/**
	 *  Adds an object that is interested in property changes in this object
	 *  @param listener the interested object
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove a previously added listener 
	 *  @param listener the listener to remove
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns the chart with which this marker is associated
	 *  @return the chart with which this marker is associated
	 */
	public Chart getChart() {
	}

	/**
	 *  Set the chart that this object will update if any of the properties change
	 *  @param chart the Chart object
	 */
	public void setChart(Chart chart) {
	}

	public void setRenderingHint(java.awt.RenderingHints.Key hint, Object value) {
	}

	/**
	 *  Returns whether this marker object is currently visible 
	 *  @return whether the marker object is currently visible
	 */
	public boolean isVisible() {
	}

	/**
	 *  Specify whether this marker object should be drawn. Sometimes it may be useful to keep it associated with
	 *  the chart but to temporarily remove it visually from the chart.
	 *  @param visible whether the marker should be drawn
	 */
	public void setVisible(boolean visible) {
	}

	/**
	 *  Returns the color of the marker object. If a paint is used that is not a color, this returns null.
	 *  @return the color of the marker object. 
	 */
	public java.awt.Color getColor() {
	}

	/**
	 *  Specify the color of the marker object
	 *  @param color the new color
	 */
	public void setColor(java.awt.Color color) {
	}

	/**
	 *  Returns the paint used for the marker object
	 *  @return the paint used for the marker object
	 */
	public java.awt.Paint getPaint() {
	}

	/**
	 *  Specify the paint to use for the marker object. If the paint happens to be a Color, you could call
	 *  either this method or setColor - the end result is the same.
	 *  @param paint the new paint.
	 */
	public void setPaint(java.awt.Paint paint) {
	}

	/**
	 *  Returns the x interval of the marker
	 *  @return the x interval of the marker
	 */
	public NumericRange getXInterval() {
	}

	/**
	 *  Returns the y interval of the marker
	 *  @return the y interval of the marker
	 */
	public NumericRange getYInterval() {
	}

	/**
	 *  Specifies the upper and lower bounds of the rectangular region on the x axis
	 *  @param min the minimum x value
	 *  @param max the maximum x value
	 */
	public void setXInterval(double min, double max) {
	}

	/**
	 *  Specifies the upper and lower bounds of the rectangular region on the y axis
	 *  @param min the minimum y value
	 *  @param max the maximum y value
	 */
	public void setYInterval(double min, double max) {
	}

	/**
	 *  Returns the label used on this marker, if any.
	 *  @return the textual label, if any.
	 */
	public String getLabel() {
	}

	/**
	 *  Specify a text label for the marker. This will usually be used to 
	 *  indicate to the user the purpose of the marker.
	 */
	public void setLabel(String label) {
	}

	/**
	 *  Returns the current position of the label
	 *  @return the current positioning of the label
	 */
	public LabelPlacement getLabelPlacement() {
	}

	/**
	 *  Specify where to place the label, if one has been provided
	 *  @param labelPlacement where to place the label
	 */
	public void setLabelPlacement(LabelPlacement labelPlacement) {
	}

	/**
	 *  Returns the current color setting for the label
	 *  @return the color used for the label
	 */
	public java.awt.Color getLabelColor() {
	}

	/**
	 *  Specify the color to use for the label. If the color is not specified, the same
	 *  color will be used as for the line.
	 *  @param labelColor the color to use for the label
	 */
	public void setLabelColor(java.awt.Color labelColor) {
	}

	/**
	 *  Returns the font of the label
	 *  @return the font used for displaying the label
	 */
	public java.awt.Font getLabelFont() {
	}

	/**
	 *  Specify the font used for displaying the label [optional]
	 *  @param labelFont the font for the label
	 */
	public void setLabelFont(java.awt.Font labelFont) {
	}

	/**
	 *  Returns the outline color for the rectangular region, or null if not used
	 *  @return the outline color for the rectangular region
	 */
	public java.awt.Color getOutlineColor() {
	}

	public int getZOrder() {
	}

	public void setZOrder(int zOrder) {
	}

	/**
	 *  Specify the outline color for the rectangular region, or null if not used
	 *  @param outlineColor the new outline color
	 */
	public void setOutlineColor(java.awt.Color outlineColor) {
	}

	/**
	 *  The stroke currently used for painting the outline of the rectangle
	 *  @return the outline stroke for the rectangular region
	 */
	public java.awt.Stroke getOutlineStroke() {
	}

	/**
	 *  Specify the stroke to use for the outline of the rectangular region.
	 *  This is a solid line of width 1 by default.
	 *  @param outlineStroke the outline stroke
	 */
	public void setOutlineStroke(java.awt.Stroke outlineStroke) {
	}

	/**
	 *  The callback method to draw the object. It cannot be drawn if the chart property is not set or if
	 *  either the xInterval or yInterval is null.
	 */
	public void draw(java.awt.Graphics g) {
	}

	/**
	 *  A method of the <code>Frontable</code> interface. By default returns false so the filling is drawn behind any lines. 
	 *  @return whether the marker should be drawn in front of the Chart Models
	 */
	public boolean isAtFront() {
	}

	/**
	 *  Specify whether the marker should be drawn in front of the chart models
	 */
	public void setAtFront(boolean atFront) {
	}
}
