/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  Interface implemented by components that support automatic resizing of fonts
 */
public interface ResizableComponent {

	/**
	 *  Allows you to register your interest in size changes for this component
	 *  @param listener the ComponentListener
	 */
	public void addComponentListener(java.awt.event.ComponentListener listener);

	/**
	 *  A boolean flag to indicate whether the component has font resizing switched on or off
	 *  @return a boolean flag to indicate whether the component has font resizing switched on or off
	 */
	public boolean isResizeFonts();
}
