/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  ChartModels and Drawables can be painted with or without a shadow. If your ChartModel or Drawable implements this
 *  interface, then you can switch the shadow on or off as required.
 */
public interface Shadowable {

	/**
	 *  Whether the object is to drawn with a shadow
	 *  @return true if the object is to be drawn with a shadow; false if to be drawn without a shadow
	 */
	public boolean isShadowVisible();

	/**
	 *  Specify whether the object should be drawn with a shadow.
	 *  @param shadowVisible whether the object should have a shadow
	 */
	public void setShadowVisible(boolean shadowVisible);
}
