/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  This class maintains a single Image for all the models added to a chart.
 */
public class SingleImageLazyChartRenderer implements LazyRenderer, Frontable, java.awt.event.ActionListener {

	/**
	 *  Create a LazyChartRenderer for the supplied chart instance
	 *  @param chart the chart for which we want to prepare the display lazily.
	 */
	public SingleImageLazyChartRenderer(Chart chart) {
	}

	/**
	 *  Returns the chart used by this lazy chart renderer.
	 *  @return the chart instance used by this lazy chart renderer.
	 */
	public Chart getChart() {
	}

	/**
	 *  A read-only property so that a user can find out how old the current image is
	 */
	public long lastModified() {
	}

	/**
	 *  Returns the first model of the list of ChartModels, or null there are no models
	 *  @return the first ChartModel or null.
	 */
	public model.ChartModel getModel() {
	}

	public void addImageChangeListener(event.ImageChangeListener listener) {
	}

	public void removeImageChangeListener(event.ImageChangeListener listener) {
	}

	protected void fireImageChange() {
	}

	public void updateImage(model.ChartModel chartModel, boolean canUseCache) {
	}

	public void removeImage(model.ChartModel chartModel) {
	}

	public void cancelDrawing() {
	}

	/**
	 *  Called at the end of a delay by a SwingTimer. Creates a background thread to do the plotting
	 */
	public void actionPerformed(java.awt.event.ActionEvent e) {
	}

	/**
	 *  Creates a background thread to do the plotting. Does not delay
	 */
	public void drawImmediately() {
	}

	public void updateImage(java.awt.Image image, java.awt.geom.Point2D topLeft, java.awt.geom.Point2D bottomRight) {
	}

	/**
	 *  Lodges a request to redraw the plot sometime soon. However, if there is lots of activity in a short period of
	 *  time, then multiple requests may be serviced by one response. If the width and height of the chart object is
	 *  non-zero then create a timer to start the rendering. If the timer is already running then restart it. The plotter
	 *  starts when the timer reaches the end of its period.
	 */
	public void updateCharts(boolean clearAll) {
	}

	/**
	 *  Draw the latest image (if any) into the supplied graphics context
	 */
	public void draw(java.awt.Graphics g) {
	}

	/**
	 *  Always returns false as the lazy chart renderer is always at the back so it can cast a shadow if
	 *  shadows are switched on.
	 *  @return false
	 */
	public boolean isAtFront() {
	}

	/**
	 *  @throws UnsupportedOperationException as the LazyChartRenderer must always appear at the back
	 *  in case shadows are switched on
	 */
	public void setAtFront(boolean atFront) {
	}
}
