/**
 *  The package contains the classes related to the JIDE Charts product.
 */
package com.jidesoft.chart;


/**
 *  A class that computes appropriate ranges for the x and y axes of a chart, while keeping y axis aligned at zero.
 *  By default the leading and trailing margin proportions for the x and y ranges are 10% of the difference between
 *  the maximum and the minimum (that is, the value is 0.1).
 *  If required, you can fix corner points of the x and y axes - for example to make sure the origin of the chart is
 *  at (0, 0) while allowing the maximum values to be auto-ranged.
 * 
 *  <p>ZeroAlignedAutoRanger is a MultiAutoRanger, which means that when a chart contains multiple y axes,
 *  the axes are rescaled independently. This is different behaviour to the DefaultAutoRanger, which rescales
 *  the axes by maintaining a scaling factor across them (which is useful for axes showing different units
 *  of temperature, for example).
 *  </p>
 */
public class ZeroAlignedAutoRanger extends AbstractAutoRanger implements MultiAutoRanger {

	/**
	 *  Creates an auto ranger that does not constrain any of the corner points of the x or y axes, and with
	 *  default values for the leading and trailing margin proportions.
	 */
	public ZeroAlignedAutoRanger() {
	}

	/**
	 *  This constructor allows you to fix one or more parts of the ranges that are returned. A common
	 *  example of this would be when you are plotting a bar chart and you always want the minimum y value to be 0.
	 *  If you provide null as any of the values here, that part of the returned range is not fixed and an auto-range
	 *  value is computed as normal.
	 * 
	 *  @param fixMinX the fixed value for min x, or null to compute value automatically
	 *  @param fixMinY the fixed value for min y, or null to compute value automatically
	 *  @param fixMaxX the fixed value for max x, or null to compute value automatically
	 *  @param fixMaxY the fixed value for max y, or null to compute value automatically
	 */
	public ZeroAlignedAutoRanger(Double fixMinX, Double fixMinY, Double fixMaxX, Double fixMaxY) {
	}

	/**
	 *  Returns a boolean to indicate whether zero inclusion is active for both x and y axes
	 *  @return a boolean to indicate whether zero inclusion is active for both x and y axes
	 */
	public boolean isAlwaysIncludeZeros() {
	}

	/**
	 *  When you have all positive or all negative data, auto-ranging would normally home in on the ranges that
	 *  actually include the data, but sometimes you want the origin to be included. If you set this property to
	 *  true, then zero will be included on the y axis.
	 *  @param alwaysIncludeZeros a boolean to indicate whether you want zero to be included
	 */
	public void setAlwaysIncludeZeros(boolean alwaysIncludeZeros) {
	}

	/**
	 *  Returns a boolean to indicate whether zero should always be included in the modified x range
	 *  @return a boolean to indicate whether zero should always be included in the modified x range
	 */
	public boolean isAlwaysIncludeXZero() {
	}

	public void setAlwaysIncludeXZero(boolean alwaysIncludeXZero) {
	}

	/**
	 *  Returns a boolean to indicate whether zero should always be included in the modified y ranges
	 *  @return a boolean to indicate whether zero should always be included in the modified y ranges
	 */
	public boolean isAlwaysIncludeYZeros() {
	}

	public void setAlwaysIncludeYZeros(boolean alwaysIncludeYZeros) {
	}

	/**
	 *  Computes appropriate x and y ranges for the supplied chart instance and applies them to the chart.
	 *  When used as a MultiAutoRanger, this method is not called and the Chart instance calls getAxisRanges(Chart) instead.
	 * 
	 *  @param chart the chart instance for which the ranges should be calculated
	 *  @return Ranges that can be used for the x and y axes of the supplied chart
	 */
	public util.Pair getRanges(Chart chart) {
	}

	public java.util.Map getAxisRanges(Chart chart) {
	}
}
