/**
 *  The package contains classes for annotating a chart with images and/or labels in JIDE Charts product.
 */
package com.jidesoft.chart.annotation;


/**
 *  A superclass of labels that can be added to a Chart.
 *  <p>
 *  The default font is taken from UIManager's Chart.font key value.
 *  </p>
 *  <p>
 *  The default color is taken from UIManager's Chart.foreground key value
 *  </p>
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public abstract class AbstractLabel extends AbstractAnnotation {

	/**
	 *  Construct a label with no text (i.e., the empty string), default color and default font
	 */
	public AbstractLabel() {
	}

	public AbstractLabel(String label) {
	}

	public AbstractLabel(String label, java.awt.Color color) {
	}

	public AbstractLabel(String label, java.awt.Color color, java.awt.Font font) {
	}

	public AbstractLabel(String label, com.jidesoft.chart.style.LabelStyle labelStyle) {
	}

	public String getLabel() {
	}

	public void setLabel(String label) {
	}

	protected javax.swing.JLabel getLabelComponent() {
	}

	public java.awt.Color getColor() {
	}

	public void setColor(java.awt.Color color) {
	}

	public void setBackground(java.awt.Color color) {
	}

	public java.awt.Color getBackground() {
	}

	public java.awt.Font getFont() {
	}

	public void setFont(java.awt.Font font) {
	}

	public Double getRotation() {
	}

	/**
	 *  Set the rotation of the label in radians, relative to the normal horizontal position; for example
	 *  <ul>
	 *    <li>Math.PI/2 = 90 degrees clockwise</li>
	 *    <li>-Math.PI/2 = 90 degrees anticlockwise</li>
	 *    <li>Math.PI/4 = 45 degrees clockwise</li>
	 *    <li>-Math.PI/4 = 45 degrees anticlockwise</li>
	 *  </ul>
	 *  @param rotation the radians to rotate; positive values rotate clockwise, negative values anticlockwise
	 */
	public void setRotation(Double rotation) {
	}

	public com.jidesoft.chart.style.LabelStyle getLabelStyle() {
	}

	public void setLabelStyle(com.jidesoft.chart.style.LabelStyle labelStyle) {
	}

	/**
	 *  This method assumes that the font to be used for the label has already been set on the graphics context.
	 * 
	 *  @param g - the graphics context for which the size is to be calculated
	 *  @return the dimension of the label in the supplied graphics context
	 */
	public java.awt.Dimension size(java.awt.Graphics g, java.awt.Font f) {
	}

	public void paint(java.awt.Graphics g, int x, int y, com.jidesoft.chart.util.Rotation rotation) {
	}

	/**
	 *  @param g        the Graphics object onto which the method draws
	 *  @param x        the x coordinate of the centre of the label
	 *  @param y        the y coordinate of the centre of the label
	 *  @param rotation in radians
	 */
	public void paint(java.awt.Graphics g, int x, int y, double rotation) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
