/**
 *  The package contains classes for annotating a chart with images and/or labels in JIDE Charts product.
 */
package com.jidesoft.chart.annotation;


/**
 *  A Chart Label is a simple label of textual information that can be used as an annotation on a point of a Chart.
 *  It can be used to point out particular features of a chart such as maxima or minima, to label regions of interest,
 *  or to give more details about the points that they annotate such as the precise x and y coordinates or other
 *  (unshown) attributes of the point object.
 * 
 *  <p>Note that when providing the coordinates to be used for displaying the label, they:
 *  <ul>
 *  <li>are given in user coordinates that correspond to the values along the x axis and primary y axis;</li>
 *  <li>specify the approximate centre of the label, so you may want to use a <code>pixelOffset</code> if you
 *  are labelling a point at the given position.
 *  </ul>
 *  </p>
 * 
 *  <p>The following screenshot shows ChartLabels being used to give additional information on all the points
 *  in a model when the user moves his mouse over an item in the legend:</p>
 *  <div style="text-align:center"><img src="doc-files/ChartLabel-1.png" alt="Example of the use of Chart Labels"/></div>
 */
public class ChartLabel extends AbstractLabel implements com.jidesoft.chart.model.Chartable, ChartAnnotation, Comparable {

	/**
	 *  Create a chart label annotation to be placed at the given position.
	 *  The X,Y coordinates are near the centre of the label
	 *  @param x the x coordinate in the user space
	 *  @param y the y coordinate in the user space
	 *  @param label the label to draw
	 */
	public ChartLabel(double x, double y, String label) {
	}

	/**
	 *  Create a ChartLabel at the given user coordinates, but with the text of the label set to <code>null</code>.
	 *  To make the label useful, you will presumably be calling <code>setLabel()</code> with a string value at
	 *  some later stage.
	 *  @param x the x coordinate in the user space
	 *  @param y the y coordinate in the user space
	 */
	public ChartLabel(double x, double y) {
	}

	/**
	 *  Create a ChartLabel at the given user coordinates, but with the text of the label set to <code>null</code>.
	 *  This constructor accepts <code>Positionable</code> objects to specify the user coordinates, so you may be
	 *  using a <code>ChartCategory</code> or a <code>RealPosition</code> to define the location.
	 *  @param x the x coordinate of the label
	 *  @param y the y coordinate of the label
	 */
	public ChartLabel(Positionable x, Positionable y) {
	}

	/**
	 *  Create a ChartLabel at the given user coordinates, with the supplied text label.
	 *  @param x the x coordinate of the centre of the label
	 *  @param y the y coordinate of the centre of the label
	 *  @param label the text of the label. If the label starts with '<html>' it will be interpreted as an HTML fragment.
	 */
	public ChartLabel(Positionable x, Positionable y, String label) {
	}

	/**
	 *  Create ChartLabel at the given user coordinates, with the supplied text label and text color.
	 *  @param x the x coordinate of the centre of the label
	 *  @param y the y coordinate of the centre of the label
	 *  @param label the text of the label. If the label starts with '<html>' it will be interpreted as an HTML fragment.
	 *  @param color the color of the text of the label
	 */
	public ChartLabel(Positionable x, Positionable y, String label, java.awt.Color color) {
	}

	/**
	 *  Create ChartLabel at the given user coordinates, with the supplied text label and text color.
	 *  @param x the x coordinate of the centre of the label
	 *  @param y the y coordinate of the centre of the label
	 *  @param label the text of the label. If the label starts with '<html>' it will be interpreted as an HTML fragment.
	 *  @param color the color of the text of the label
	 *  @param font the font to be used for the label
	 */
	public ChartLabel(Positionable x, Positionable y, String label, java.awt.Color color, java.awt.Font font) {
	}

	/**
	 *  Returns the current background color used for the label
	 *  @return the background color used for the label (or null if none has been set)
	 */
	public java.awt.Color getBackground() {
	}

	/**
	 *  Specify the background color to be used for the label. Transparent colors are allowed.
	 *  @param background the background color to be used on the label
	 */
	public void setBackground(java.awt.Color background) {
	}

	/**
	 *  Returns the current border on the ChartLabel (or null if none has been set)
	 *  @return the current border on the ChartLabel
	 */
	public javax.swing.border.Border getBorder() {
	}

	/**
	 *  Specify the border to use for the ChartLabel. Don't forget that as well as the more common Border types
	 *  like LineBorder you can also use EmptyBorder and CompoundBorder to good effect here.
	 *  @param border the border to use
	 */
	public void setBorder(javax.swing.border.Border border) {
	}

	/**
	 *  {@inheritDoc}
	 */
	public Positionable getX() {
	}

	/**
	 *  {@inheritDoc}
	 */
	public Positionable getY() {
	}

	/**
	 *  Returns the offset in pixel values that is applied to the position of the ChartLabel after the x,y user
	 *  coordinates have been calculated
	 *  @return the current pixel offset for the position of the chart label
	 */
	public java.awt.Point getPixelOffset() {
	}

	/**
	 *  Specify the offset in pixel values to be applied to the position of the ChartLabel after the x,y user
	 *  coordinates have been calculated
	 *  @param pixelOffset the pixel offset to be applied to the position of the chart label
	 */
	public void setPixelOffset(java.awt.Point pixelOffset) {
	}

	/**
	 *  Compares with other Chartables based on their x coordinates
	 *  @param other the other Chartable with which this object is to be compared
	 *  @return an int to indicate whether the x coordinate of this ChartLabel is less than, the same as,
	 *  or greater than the x coordinate of the supplied Chartable.
	 */
	public int compareTo(com.jidesoft.chart.model.Chartable other) {
	}

	/**
	 *  Draws this Chart Label onto the supplied graphics context using properties of the supplied chart instance.
	 *  @param g the Graphics context
	 *  @param chart the chart from which property values may be taken and applied to the label
	 */
	public void draw(java.awt.Graphics2D g, com.jidesoft.chart.Chart chart) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
