/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  Represents an axis in the chart display.
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class Axis implements java.beans.PropertyChangeListener {

	public static final double MIN_RESOLUTION = 1.0E-10;

	public static final String PROPERTY_TICKS = "ticks";

	public static final String PROPERTY_TICK_FONT = "tickFont";

	public static final String PROPERTY_TICK_LENGTH = "tickLength";

	public static final String PROPERTY_MINOR_TICK_LENGTH = "minorTickLength";

	public static final String PROPERTY_RANGE = "range";

	public static final String PROPERTY_UPDATE_OTHER_AXES = "updateOtherAxes";

	public static final String PROPERTY_LABEL = "label";

	public static final String PROPERTY_TICK_LABEL_COLOR = "tickLabelColor";

	public static final String PROPERTY_TICK_CALCULATOR = "tickCalculator";

	public static final String PROPERTY_AXIS_COLOR = "axisColor";

	public static final String PROPERTY_TICK_COLOR = "tickColor";

	public static final String PROPERTY_MINOR_TICK_COLOR = "minorTickColor";

	public static final String PROPERTY_STROKE = "axisStroke";

	/**
	 *  No-args constructor
	 */
	public Axis() {
	}

	/**
	 *  Create an axis using the supplied text to create a label
	 * 
	 *  @param labelText the text of the label
	 */
	public Axis(String labelText) {
	}

	/**
	 *  Create an axis using the given label
	 * 
	 *  @param label the label to use for the axis
	 */
	public Axis(com.jidesoft.chart.annotation.AutoPositionedLabel label) {
	}

	/**
	 *  Create an axis using the supplied minimum and maximum values to set the range of the axis. This assumes we are
	 *  using a purely numerical axis (rather than categorical values or a time line).
	 * 
	 *  @param min the minimum value of the range
	 *  @param max the maximum value of the range
	 */
	public Axis(double min, double max) {
	}

	/**
	 *  Create an axis using the given range to define the minimum and maximum values
	 * 
	 *  @param newRange the new range of the axis
	 */
	public Axis(<any> newRange) {
	}

	/**
	 *  Create an Axis, using the text as the label
	 * 
	 *  @param newRange  the range of the axis, defining minimum and maximum values
	 *  @param labelText the text to use in the label for the axis
	 */
	public Axis(<any> newRange, String labelText) {
	}

	/**
	 *  A property change event will be fired when this axis changes its range.
	 * 
	 *  @param listener the listener to receive notification of changes
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Remove a listener that receives notification of property changes.
	 * 
	 *  @param listener the listener
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  Returns the tick calculator
	 * 
	 *  @return the tick calculator
	 */
	@javax.xml.bind.annotation.XmlTransient
	@java.lang.SuppressWarnings("rawtypes")
	public TickCalculator getTickCalculator() {
	}

	/**
	 *  <p>Specify the tick calculator to use for this axis.</p>
	 *  <p><b>Note:</b> We add ourselves as a PropertyChangeListener to the tick calculator in case there
	 *  are changes (such as NumberFormatChanges) that require the ticks to be updated.
	 * 
	 *  @param tickCalculator the tick calculator
	 */
	@java.lang.SuppressWarnings("rawtypes")
	public void setTickCalculator(TickCalculator tickCalculator) {
	}

	@javax.xml.bind.annotation.XmlTransient
	public com.jidesoft.chart.render.AxisRenderer getAxisRenderer() {
	}

	/**
	 *  Returns the current tick label rotation, given in radians.
	 * 
	 *  @return the current tick label rotation
	 */
	public double getTickLabelRotation() {
	}

	/**
	 *  Specify a rotation for the tick labels, given in radians.
	 *  So for example, to rotate the x axis text by 45 degrees use Math.PI/4 for climbing text or -Math.PI/4 for
	 *  descending text.
	 * 
	 *  @param tickLabelRotation a rotation given in radians
	 */
	public void setTickLabelRotation(double tickLabelRotation) {
	}

	public int getTickLabelOffset() {
	}

	/**
	 *  Specify a gap between the tick and the tick label
	 * 
	 *  @param offset the gap between the tick and the tick label
	 */
	public void setTickLabelOffset(int offset) {
	}

	/**
	 *  Returns the length of major ticks, in pixels
	 *  @return the length of major ticks, in pixels
	 */
	public int getTickLength() {
	}

	/**
	 *  Specify the length of major ticks, in pixels
	 *  @param tickLength the new length for major ticks
	 */
	public void setTickLength(int tickLength) {
	}

	/**
	 *  Returns the length of minor ticks, in pixels
	 *  @return the length of minor ticks, in pixels
	 */
	public int getMinorTickLength() {
	}

	/**
	 *  Specify the length of minor ticks, in pixels
	 *  @param minorTickLength the new length for minor ticks
	 */
	public void setMinorTickLength(int minorTickLength) {
	}

	/**
	 *  Returns the tick color for the axis
	 *  @return the tick color for the axis
	 */
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlColorAdapter.class)
	public java.awt.Color getTickColor() {
	}

	/**
	 *  The chart class contains a tickColor attribute, but you can override that value by
	 *  setting the tick color on an instance of Axis.
	 *  @param tickColor the color to use when painting ticks on this axis
	 */
	public void setTickColor(java.awt.Color tickColor) {
	}

	/**
	 *  Returns the value for the minor tick Color
	 *  @return the Color used for painting minor ticks
	 */
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlColorAdapter.class)
	public java.awt.Color getMinorTickColor() {
	}

	/**
	 *  Specify the color used for painting minor ticks.
	 *  If this value is not set (i.e., null), minor ticks will be painted the same color as major ticks
	 *  @param minorTickColor the Color for minor ticks, or null for the same color as major ticks
	 */
	public void setMinorTickColor(java.awt.Color minorTickColor) {
	}

	/**
	 *  Returns the color used for tick labels on this axis
	 * 
	 *  @return the color used for tick labels on this axis
	 */
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlColorAdapter.class)
	public java.awt.Color getTickLabelColor() {
	}

	/**
	 *  Sets the tick label color and overrides the default value set in the Chart class
	 * 
	 *  @param tickLabelColor the color to use for tick labels
	 */
	public void setTickLabelColor(java.awt.Color tickLabelColor) {
	}

	/**
	 *  Returns the font currently used for tick labels
	 * 
	 *  @return the font currently used for tick labels
	 */
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlFontAdapter.class)
	public java.awt.Font getTickFont() {
	}

	/**
	 *  Specify the font to use for tick labels
	 * 
	 *  @param tickFont the font to use for tick labels
	 */
	public void setTickFont(java.awt.Font tickFont) {
	}

	/**
	 *  Returns whether the axis is currently visible
	 * 
	 *  @return whether the axis is currently visible
	 */
	public boolean isVisible() {
	}

	/**
	 *  Specify whether the axis should be visible. An invisible axis takes up no space. Axes are visible by default.
	 *  If you change the visibility of an axis at run time you will need to repaint the chart.
	 * 
	 *  @param visible true if the axis should be visible; false to make it invisible.
	 */
	public void setVisible(boolean visible) {
	}

	/**
	 *  Returns whether the label should be visible
	 * 
	 *  @return whether the label should be visible
	 */
	public boolean isLabelVisible() {
	}

	/**
	 *  Specify whether the axis label is visible.
	 *  <p>Sometimes you might want to specify an axis label, but then set it to be invisible. This can help,
	 *  for example, when aligning the charts in a multi-chart layout</p>
	 * 
	 *  @param labelVisible whether the label should be visible
	 */
	public void setLabelVisible(boolean labelVisible) {
	}

	public Integer getLabelWidth() {
	}

	/**
	 *  The label width is the variable part of the width of the axis.
	 *  <p>
	 *  Use this only to fix the label width at a specific value; otherwise the label width is automatically computed.
	 *  </p>
	 * 
	 *  @param labelWidth the width of the variable width part of the axis, in pixels
	 */
	public void setLabelWidth(Integer labelWidth) {
	}

	public int labelWidth(java.awt.Graphics g, java.awt.Font tickFont, com.jidesoft.chart.Orientation orientation, Tick[] ticks) {
	}

	/**
	 *  Determines how much space to allow for the tick labels at the side of an axis
	 * 
	 *  @return the (maximum) tick label width in pixels
	 */
	public int labelWidth(java.awt.Graphics g, java.awt.Font tickFont, com.jidesoft.chart.Orientation orientation) {
	}

	/**
	 *  Sets the renderer for the axis
	 * 
	 *  @param axisRenderer the axis renderer
	 */
	public void setAxisRenderer(com.jidesoft.chart.render.AxisRenderer axisRenderer) {
	}

	/**
	 *  Sets the range for the axis to be a numeric range with the supplied minimum and maximum values
	 * 
	 *  @param min the minimum value for the range
	 *  @param max the maximum value for the range
	 */
	public void setRange(double min, double max) {
	}

	/**
	 *  Sets the range for the axis to be the supplied range
	 * 
	 *  @param range the new range
	 */
	public void setRange(<any> range) {
	}

	/**
	 *  Set the range of the axis.
	 */
	public void setRange(<any> range, boolean updateOtherAxes) {
	}

	/**
	 *  Sets the range, with the option of not firing a property change event.
	 *  This can be useful when considering performance, but only when you know that there will be an
	 *  update to the chart soon anyway (probably because of some other related event).
	 */
	public void setRange(<any> range, boolean updateOtherAxes, boolean fireEvent) {
	}

	@javax.xml.bind.annotation.XmlTransient
	public <any> getDomain() {
	}

	public void setDomain(<any> domain) {
	}

	/**
	 *  Returns the <em>quantity</em> for the axis, i.e. is the axis for numeric, time or category values?
	 *  By default an axis is for numeric values, but subclasses should override this appropriately.
	 *  @return the quantity for the axis
	 */
	public AxisQuantity getQuantity() {
	}

	/**
	 *  Returns the range of values for this axis, after the transformation (if any) has been applied
	 * 
	 *  @return a Range
	 */
	public <any> getOutputRange() {
	}

	/**
	 *  @return the range of values for this axis, before the transformation (if any) has been applied
	 */
	@javax.xml.bind.annotation.XmlTransient
	public <any> getRange() {
	}

	@javax.xml.bind.annotation.XmlTransient
	public com.jidesoft.chart.model.InvertibleTransform getAxisTransform() {
	}

	public void setAxisTransform(com.jidesoft.chart.model.InvertibleTransform axisTransform) {
	}

	@javax.xml.bind.annotation.XmlTransient
	public com.jidesoft.chart.annotation.AutoPositionedLabel getLabel() {
	}

	public void setLabel(String text) {
	}

	public void setLabel(com.jidesoft.chart.annotation.AutoPositionedLabel newValue) {
	}

	/**
	 *  Returns the maximum of the input range
	 * 
	 *  @return the maximum of the input range
	 */
	public double maximum() {
	}

	/**
	 *  Returns the minimum of the input range
	 * 
	 *  @return the minimum of the input range
	 */
	public double minimum() {
	}

	/**
	 *  Calculates the mid point of the range
	 * 
	 *  @return the mid point of the range
	 */
	public double midPoint() {
	}

	/**
	 *  Returns the placement of the axis
	 * 
	 *  @return the placement of the axis
	 *  @see AxisPlacement
	 */
	public AxisPlacement getPlacement() {
	}

	/**
	 *  Specifies whether the axis is to be placed at the leading
	 *  or trailing edge of the interval, or placed in the centre
	 * 
	 *  @param placement the placement of the axis
	 */
	public void setPlacement(AxisPlacement placement) {
	}

	/**
	 *  Returns the floating position. This is only relevant when the axis is displayed with an axis placement
	 *  of FLOATING
	 * 
	 *  @return the position of the axis on the other axis
	 */
	public double getFloatingPosition() {
	}

	/**
	 *  Sets the floating position. The floating position is the real axis position when the axis is being displayed in
	 *  floating mode. By default it will be zero.
	 * 
	 *  @param floatingPos the new floating position as a real coordinate value
	 */
	public void setFloatingPosition(double floatingPos) {
	}

	/**
	 *  Returns the color to use when painting the axis
	 * 
	 *  @return the color to use when painting the axis
	 */
	@javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter(com.jidesoft.chart.xml.XmlColorAdapter.class)
	public java.awt.Color getAxisColor() {
	}

	/**
	 *  Specify the color to use when painting the axis
	 * 
	 *  @param axisColor the color to use for the Axis
	 */
	public void setAxisColor(java.awt.Color axisColor) {
	}

	/**
	 *  Returns the stroke used when drawing the axis
	 * 
	 *  @return the Stroke used when drawing the axis
	 */
	@javax.xml.bind.annotation.XmlTransient
	public java.awt.Stroke getStroke() {
	}

	/**
	 *  Specifies the stroke to use for the axis
	 * 
	 *  @param stroke the stroke to use for the axis
	 */
	public void setStroke(java.awt.Stroke stroke) {
	}

	/**
	 *  Returns an array of ticks for this axis
	 * 
	 *  @return an array of ticks for this axis
	 */
	@javax.xml.bind.annotation.XmlTransient
	public Tick[] getTicks() {
	}

	/**
	 *  Updates the cached array of ticks
	 */
	@java.lang.SuppressWarnings("unchecked")
	protected void updateTicks() {
	}

	/**
	 *  Returns whether ticks are currently visible
	 * 
	 *  @return whether ticks are visible
	 */
	public boolean isTicksVisible() {
	}

	/**
	 *  Specify whether ticks should be visible
	 * 
	 *  @param ticksVisible a boolean value to indicate whether ticks should be visible
	 */
	public void setTicksVisible(boolean ticksVisible) {
	}

	public boolean isFlipped() {
	}

	public void setFlipped(boolean flipped) {
	}

	/**
	 *  Adjusts this axis by zooming on the realValue and using the supplied magnification factor. It keeps the midpoint
	 *  of the axis static.
	 * 
	 *  @param axis                the axis to be zoomed
	 *  @param magnificationFactor the factor by which we wish to zoom
	 *  @return the new zoomed range
	 */
	public static <any> zoom(Axis axis, double magnificationFactor) {
	}

	/**
	 *  This method zooms by keeping the given position (for example, the origin) of an axis static
	 * 
	 *  @param axis                the axis being zoomed
	 *  @param magnificationFactor the magnification factor being applied for the zoom
	 *                             "param position the position of the zoom along the axis (in terms of user coordinates)
	 *  @return the new zoomed range for the axis
	 */
	public static <any> zoomFromPosition(Axis axis, double magnificationFactor, double position) {
	}

	/**
	 *  Render the axis onto the supplied graphics context
	 * 
	 *  @param g           the Graphics context
	 *  @param x           the x coordinate for the axis
	 *  @param y           the y coordinate for the axis
	 *  @param length      the length of the axis
	 *  @param orientation the orientation of the axis; horizontal or vertical
	 */
	public void render(java.awt.Graphics g, int x, int y, int length, com.jidesoft.chart.Orientation orientation) {
	}

	@java.lang.Override
	public String toString() {
	}

	public void propertyChange(java.beans.PropertyChangeEvent evt) {
	}

	@java.lang.Override
	public boolean equals(Object o) {
	}

	@java.lang.Override
	public int hashCode() {
	}
}
