/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  EAxisPlacement is used to specify where to put an axis on a chart. There are four possible values: <ul>
 *  <li><code>LEADING</code></li> <li><code>TRAILING</code></li> <li><code>CENTER</code></li>
 *  <li><code>FLOATING</code></li> </ul> For horizontal placement, <code>LEADING</code> means on the left and
 *  <code>TRAILING</code> means on the right. For vertical placement, <code>LEADING</code> means on the bottom and
 *  <code>TRAILING</code> means on the top. <p>Floating means that the axes can move when the chart is panned.</> <p>This
 *  approach means that we can easily switch the orientation of the axis and still have meaningful placement values for
 *  an axis.</p>
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public final class AxisPlacement extends Enum {

	public static final AxisPlacement LEADING;

	public static final AxisPlacement TRAILING;

	public static final AxisPlacement CENTER;

	public static final AxisPlacement FLOATING;

	public static AxisPlacement[] values() {
	}

	public static AxisPlacement valueOf(String name) {
	}
}
