/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  An axis used specifically for displaying categorical values.
 * 
 *  @param <T> the type of object described by the categories
 */
public class CategoryAxis extends Axis {

	/**
	 *  Creates a Category axis for a Category range with no categories.
	 *  (This is one way of creating an axis with no ticks!)
	 *  If you use one of the constructors that does not take a CategoryRange as a parameter, then
	 *  you would need to call setRange() with a CategoryRange instance some time later instead.
	 */
	public CategoryAxis() {
	}

	/**
	 *  Creates an empty category axis, but uses the supplied text as a label
	 *  @param text the text label for the axis
	 */
	public CategoryAxis(String text) {
	}

	/**
	 *  Creates an empty category axis, and uses the supplied label object as a label for the axis
	 *  @param label the axis label
	 */
	public CategoryAxis(com.jidesoft.chart.annotation.AutoPositionedLabel label) {
	}

	/**
	 *  Creates a category axis using the supplied CategoryRange to specify where to place the ticks and tick labels.
	 *  @param range the range of Category values to display along the axis
	 */
	public CategoryAxis(<any> range) {
	}

	/**
	 *  Creates a CategoryAxis using the supplied CategoryRange to specify where to place the ticks and tick labels.
	 *  @param range the range of Category values to display along the axis
	 *  @param text the text to use as the axis label
	 */
	public CategoryAxis(<any> range, String text) {
	}

	protected void init() {
	}

	/**
	 *  Returns the CATEGORY quantity
	 *  @return the CATEGORY quantity
	 */
	@java.lang.Override
	public AxisQuantity getQuantity() {
	}

	@java.lang.Override
	public void setRange(<any> range, boolean updateOtherAxes, boolean fireEvent) {
	}

	@java.lang.Override
	public void setRange(<any> range) {
	}

	@java.lang.Override
	public void setRange(<any> range, boolean updateOtherAxes) {
	}

	@java.lang.Override
	public void setRange(double min, double max) {
	}
}
