/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  A default implementation of a tick calculator for numeric values.
 */
public class DefaultNumericTickCalculator implements NumericTickCalculator {

	public static final String PROPERTY_NUMBER_FORMAT = "numberFormat";

	public static final String PROPERTY_TICK_INTERVALS_BETWEEN_MAJORS = "tickIntervalsBetweenMajors";

	public DefaultNumericTickCalculator() {
	}

	/**
	 *  Returns the number of intervals between major ticks. The number of intervals is one more than
	 *  the number of minor ticks, as the end intervals are delimited by major ticks.
	 *  @return the number of intervals between major ticks
	 */
	public int getMinorTickIntervalBetweenMajors() {
	}

	/**
	 *  Set the number of ticks between major ticks by specifying the number of intervals. For example
	 *  if you want 5 subdivisions between major ticks then you specify 5 as the parameter to this
	 *  method. This means that you actually get 4 minor ticks between the major ticks.
	 *  @param minorTickIntervalBetweenMajors specify the number of intervals between major ticks
	 */
	public void setMinorTickIntervalBetweenMajors(int minorTickIntervalBetweenMajors) {
	}

	/**
	 *  Returns the number format used for generating tick labels
	 *  @return the number format used for generating tick labels
	 */
	public java.text.NumberFormat getNumberFormat() {
	}

	/**
	 *  By default the number format used for generating the ticks uses a maximum of 2 digits for the fractional part.
	 * 
	 *  @param numberFormat the new number format object
	 */
	public void setNumberFormat(java.text.NumberFormat numberFormat) {
	}

	/**
	 *  The string to use for the number format is as used
	 *  in the applyPattern method of <code>DecimalFormat</code>.
	 *  @param numberFormat the number format to use
	 */
	public void setNumberFormat(String numberFormat) {
	}

	public int getScale() {
	}

	public void setScale(int scale) {
	}

	/**
	 *  Works out where to place the tick markers
	 */
	public Tick[] calculateTicks(<any> r) {
	}

	/**
	 *  Register an object's interest in property changes on this object
	 *  @param listener the interested object that will be notified when a change occurs
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  De-register an object's interest in property changes on this object
	 *  @param listener the object that will no longer be notified of changes
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}
}
