/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  A tick calculator that generates ticks only at integer values along the axis range.
 */
public class IntegerTickCalculator extends DefaultNumericTickCalculator {

	public IntegerTickCalculator() {
	}

	/**
	 *  Returns the current error tolerance used when determining if a number is an integer
	 *  @return the current error tolerance
	 */
	public double getTolerance() {
	}

	/**
	 *  Specify the tolerance to use for determining whether a number is an integer.
	 *  Due to imprecise arithmetic there are bound to be some small errors that we need to take
	 *  account of when answering this question, so we allow for a small error tolerance, as
	 *  specified by this property.
	 *  For example, with a value of 0.01 for the tolerance the number 4.01 is deemed close enough to 4 to
	 *  be called an integer. In practice, we should be using smaller values than 0.01.
	 *  By default, the tolerance is set at 1&times;10<sup>-10</sup>.
	 * 
	 *  @param tolerance the tolerance to use when determining if a value is an integer
	 */
	public void setTolerance(double tolerance) {
	}

	/**
	 *  Works out where to place the tick markers.
	 */
	public Tick[] calculateTicks(<any> r) {
	}
}
