/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  <p>An axis class specialised for numeric values.</p>
 *  <p>For example, if you create a NumericAxis with the following code:</p>
 *  <pre>
 *  NumericAxis axis = new NumericAxis(0, 100, "X Axis")
 *  </pre>
 *  <p>you generate an axis which, when used as the x axis, looks as follows:</p>
 *  <div style="text-align:left"><img src="doc-files/NumericAxis-1.png" alt="Numeric Axis Screenshot"/></div>
 */
public class NumericAxis extends Axis {

	/**
	 *  The default constructor creates an axis that ranges from 0.0 to 1.0, and no axis label.
	 */
	public NumericAxis() {
	}

	/**
	 *  Creates an axis ranging from 0.0 to 1.0 and with the supplied text as an axis label
	 *  @param text the label for the axis
	 */
	public NumericAxis(String text) {
	}

	/**
	 *  Creates an axis ranging from 0.0 to 1.0 and with the supplied object as the label
	 *  @param label the label object that will be placed in the centre of the axis
	 */
	public NumericAxis(com.jidesoft.chart.annotation.AutoPositionedLabel label) {
	}

	/**
	 *  Creates an axis ranging from min to max, but without an axis label
	 *  @param min the minimum value of the axis range
	 *  @param max the maximum value of the axis range
	 */
	public NumericAxis(double min, double max) {
	}

	/**
	 *  Creates an axis ranging from min to max, and the supplied text as the axis label
	 *  @param min the minimum value of the axis range
	 *  @param max the maximum value of the axis range
	 *  @param text the text to use for the axis label
	 */
	public NumericAxis(double min, double max, String text) {
	}

	/**
	 *  Creates an axis using the supplied range
	 *  @param range the range of the axis
	 */
	public NumericAxis(<any> range) {
	}

	/**
	 *  Creates an axis using the supplied range and the given text as the axis label
	 *  @param range the range of the axis
	 *  @param text the text to use as the axis label
	 */
	public NumericAxis(<any> range, String text) {
	}

	protected void init() {
	}

	/**
	 *  Sets the number format used when rendering ticks on the axis
	 *  @param numberFormat the format to use
	 *  @see NumberFormat
	 */
	public void setNumberFormat(java.text.NumberFormat numberFormat) {
	}

	/**
	 *  Sets the number format used when rendering ticks on the axis.
	 *  For example, "#0.00" will display the string to 2 decimal places
	 *  @param numberFormat the format string to use
	 *  @see java.text.DecimalFormat
	 */
	public void setNumberFormat(String numberFormat) {
	}

	/**
	 *  Returns the NUMBER quantity
	 *  @return the NUMBER quantity
	 */
	@java.lang.Override
	public AxisQuantity getQuantity() {
	}
}
