/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  <p>This class makes it easy to create custom ticks on a numeric axis by specifying an initial value for the location of
 *  a major tick and then specifying increments for major and (optionally) minor ticks. Note that the class has been
 *  designed so that the major tick increment does not have to be a multiple of the minor tick increment, although this
 *  is still the most common situation.</p>
 * 
 *  <p>The class is called a <em>Simple</em>NumericTickCalculator because it makes no provision for changing the
 *  distance between ticks when zooming. Zooming is well catered for by the DefaultNumericTickCalculator, which you
 *  get by default on a NumericAxis.</p>
 */
public class SimpleNumericTickCalculator implements NumericTickCalculator {

	public static final String PROPERTY_NUMBER_FORMAT = "Number Format";

	public static final String PROPERTY_START = "Start";

	public static final String PROPERTY_MAJOR_TICK_INTERVAL = "Major Tick Interval";

	public static final String PROPERTY_MINOR_TICK_INTERVAL = "Minor Tick Interval";

	/**
	 *  Create a SimpleNumericTickCalculator
	 */
	public SimpleNumericTickCalculator() {
	}

	/**
	 *  Create a SimpleNumericTickCalculator using the supplied start and majorTickInterval values.
	 *  @param start the lowest numeric tick value - assumed to be a major tick
	 *  @param majorTickInterval the interval before the next major tick
	 */
	public SimpleNumericTickCalculator(double start, double majorTickInterval) {
	}

	/**
	 *  Create a SimpleNumericTickCalculator using the supplied start, majorTickInterval and minorTickInterval values.
	 *  @param start the lowest numeric tick value - assumed to be a major tick
	 *  @param majorTickInterval the interval before the next major tick
	 *  @param minorTickInterval the interval before the next minor tick and the distance between subsequent minor ticks
	 */
	public SimpleNumericTickCalculator(double start, double majorTickInterval, double minorTickInterval) {
	}

	/**
	 *  Returns the number format used for tick labels
	 *  @return the number format used for tick labels
	 */
	public java.text.NumberFormat getNumberFormat() {
	}

	/**
	 *  Specify the number format used when generating tick labels
	 *  @param numberFormat the number format to use for tick labels
	 */
	public void setNumberFormat(java.text.NumberFormat numberFormat) {
	}

	/**
	 *  Uses the supplied string as a number format specifier as if supplied to the DecimalFormat class.
	 *  @param numberFormat a numberFormat string as used by the DecimalFormat class
	 */
	public void setNumberFormat(String numberFormat) {
	}

	public int getScale() {
	}

	public void setScale(int scale) {
	}

	/**
	 *  Returns the initial lowest value used for calculating ticks
	 *  @return the initial lowest value used for calculating ticks
	 */
	public double getStart() {
	}

	/**
	 *  Specifies the initial lowest value used for calculating ticks
	 *  @param start the initial lowest value used for calculating ticks
	 */
	public void setStart(double start) {
	}

	/**
	 *  Returns the major tick interval used for calculating tick positions
	 *  @return the major tick interval used for calculating tick positions
	 */
	public double getMajorTickInterval() {
	}

	/**
	 *  Specify the major tick interval used for calculating tick positions
	 *  @param majorTickInterval the interval between major ticks
	 */
	public void setMajorTickInterval(double majorTickInterval) {
	}

	/**
	 *  Returns the minor tick interval used in calculating tick positions
	 *  @return the minor tick interval used in calculating tick positions
	 */
	public Double getMinorTickInterval() {
	}

	/**
	 *  Specifies the minor tick interval used in calculating tick positions
	 *  @param minorTickInterval the interval between minor ticks
	 */
	public void setMinorTickInterval(Double minorTickInterval) {
	}

	/**
	 *  Returns the upper limit on the number of ticks that can be generated.
	 *  @return the maximum number of ticks that can be generated
	 */
	public int getMaxTickCount() {
	}

	/**
	 *  Set an upper limit on the number of ticks that can be generated.
	 *  This property is a safety measure to guard against bad inputs and you
	 *  should not normally need to adjust the value from its default.
	 *  @param maxTickCount the maximum number of ticks to generate
	 */
	public void setMaxTickCount(int maxTickCount) {
	}

	/**
	 *  Calculates the ticks and their labels according to the start and tick interval settings supplied
	 *  @param range the range for which ticks need to be calculated and returned
	 *  @return an array of Ticks to use along the axis
	 */
	public Tick[] calculateTicks(<any> range) {
	}

	/**
	 *  Registers the supplied object as interested in property changes on this object
	 *  @param listener the interested object
	 */
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}

	/**
	 *  De-registers the supplied object as interested in property changes on this object
	 *  @param listener the object that is no longer interested in property changes on this object
	 */
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	}
}
