/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  <code>Tick</code>s are generated at regular intervals along an axis and displayed as little dashed lines on the axis
 *  to give an indication of the gradation.
 * 
 *  @author Simon White (swhite@catalysoft.com)
 */
public class Tick {

	/**
	 *  Construct a Tick object. By default the position along the axis is zero.
	 */
	public Tick() {
	}

	/**
	 *  Creates a minor tick at the supplied position.
	 *  @param position the position for the tick.
	 */
	public Tick(double position) {
	}

	/**
	 *  Create a tick at the supplied position.
	 *  The second parameter determines whether it is a major or a minor tick.
	 *  @param position the position for the tick
	 *  @param isMajor whether the tick is a major tick
	 */
	public Tick(double position, boolean isMajor) {
	}

	/**
	 *  Create a Tick object with the supplied position and label.
	 *  As a label is supplied, this is assumed to be a major tick.
	 * 
	 *  @param position the new position of the tick along the axis
	 *  @param label    the new label
	 */
	public Tick(double position, String label) {
	}

	/**
	 *  Returns whether the tick is a major tick. If not major, it is a minor tick.
	 *  @return a boolean to indicate whether the tick is a major tick
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public boolean isMajor() {
	}

	/**
	 *  Specify whether the tick is a major tick. If the tick is not major it is minor
	 *  (that is, these are the only two possibilities.)
	 *  @param major whether the tick is a major tick
	 */
	public void setMajor(boolean major) {
	}

	/**
	 *  Returns the label for this tick, or null if there is none
	 *  @return the label for this tick
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public String getLabel() {
	}

	/**
	 *  Sets the label for this tick
	 * 
	 *  @param label the label for the tick
	 */
	public void setLabel(String label) {
	}

	/**
	 *  Returns the position of the tick along the axis
	 *  @return the position of the tick along the axis
	 */
	@javax.xml.bind.annotation.XmlAttribute
	public double getPosition() {
	}

	/**
	 *  Sets the position of the tick along the axis
	 * 
	 *  @param position the position for the tick, given in axis coordinates
	 */
	public void setPosition(double position) {
	}

	@java.lang.Override
	public int hashCode() {
	}

	@java.lang.Override
	public boolean equals(Object obj) {
	}

	@java.lang.Override
	public String toString() {
	}
}
