/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  This interface is implemented by all objects that calculate tick positions for axes, whether for numeric, category
 *  or time-based axes. Extensions of this interface provide more detailed levels of support for each of these axis
 *  types. 
 * 
 *  @param <T> the class of object over which the axis ranges; for example <code>Double</code> for a numeric axis.
 */
public interface TickCalculator {

	/**
	 *  Calculate the ticks for this range of values
	 *  @return an array of tick values
	 */
	public Tick[] calculateTicks(<any> range);

	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener);

	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener);
}
