/**
 *  Classes relating to axes and tick calculation
 */
package com.jidesoft.chart.axis;


/**
 *  <p>An axis class specialised for time-based values. The values along the axis are
 *  given as the number of milliseconds since 00:00hrs on January 1st 1970, which
 *  is the same as the value returned when you call <code>System.currentTimeMillis()</code>.</p>
 *  <p>Note that as all axis types are based on double values, it is sometimes necessary to
 *  cast from a long to a double when adding time points or to cast from a double to a long when
 *  reading them off a chart.</p>
 */
public class TimeAxis extends Axis {

	/**
	 *  Constructs a time axis with a default time range and tick calculator.
	 */
	public TimeAxis() {
	}

	/**
	 *  Constructs a time axis with a default time range and tick calculator, and uses
	 *  the supplied text as the axis label.
	 *  @param text the text for the axis label
	 */
	public TimeAxis(String text) {
	}

	/**
	 *  Constructs a time axis with a default time range and tick calculator, and sets
	 *  the supplied object to be the label for the axis.
	 *  @param label the axis label
	 */
	public TimeAxis(com.jidesoft.chart.annotation.AutoPositionedLabel label) {
	}

	/**
	 *  Constructs a time axis using the supplied time range.
	 *  @param min the minimum value of the time range, in milliseconds since Jan 1st 1970
	 *  @param max the maximum value of the time range, in milliseconds since Jan 1st 1970
	 */
	public TimeAxis(long min, long max) {
	}

	/**
	 *  Constructs a time axis using the supplied time range
	 *  @param timeRange the time range to use for the axis
	 */
	public TimeAxis(TimeRange timeRange) {
	}

	/**
	 *  Constructs a time axis using the supplied time range and the text as the axis label
	 *  @param timeRange the time range to use for the axis
	 *  @param text the text to use for the axis label
	 */
	public TimeAxis(TimeRange timeRange, String text) {
	}

	protected TimeRange createDefaultRange() {
	}

	protected void init() {
	}

	public void setDateFormat(java.text.DateFormat dateFormat) {
	}

	public java.text.DateFormat getDateFormat() {
	}

	public TimeAxis withDateFormat(java.text.DateFormat dateFormat) {
	}

	public java.util.TimeZone getTimeZone() {
	}

	public void setTimeZone(java.util.TimeZone timeZone) {
	}

	/**
	 *  Returns the TIME quantity
	 *  @return the TIME quantity
	 */
	@java.lang.Override
	public AxisQuantity getQuantity() {
	}
}
