/**
 *  The package contains events and listeners for JIDE Charts product
 */
package com.jidesoft.chart.event;


/**
 *  <p>A GUI element for controlling the zooming of one or more axes. As the user of this component in the user interface
 *  you can choose which axis to zoom by choosing from the drop-down menu, then zoom in or out by pressing the appropriate button.
 *  When you do this, the component fires a ZoomEvent
 *  to its listeners and the listener can determine how much to zoom. The listener will probably effect a zoom by using
 *  the <code>zoom()</code> method on the Axis class.</p>
 *  <p>As a developer working with this component, you can specify what the text or icon should be in the zoom buttons
 *  and you can specify the axes that can be controlled. (Actually it is also possible to specify both text <em>and</em> an
 *  icon. If just one axis is specified, a JLabel is used to display the
 *  axis name as no choices can be made.</p>
 *  <p>Here is a screenshot of the AxisZoomController (taken on a Mac), where the buttons have been configured to display '-' and
 *  '+' to mean zoom out and zoom in, respectively:</p>
 *  <img src="doc-files/AxisZoomController-1.png" alt="AxisZoomController screenshot"/>
 */
public class AxisZoomController extends javax.swing.JPanel {

	/**
	 *  Added for Java Bean compatibility. If you use this constructor you must remember to call setAxes() to specify which axes the class is to act on.
	 */
	public AxisZoomController() {
	}

	/**
	 *  Create a zoom controller object and pass the axes that it will allow you to control.
	 * 
	 *  @param axes the Axis objects for this zoom controller
	 */
	public AxisZoomController(com.jidesoft.chart.axis.Axis[] axes) {
	}

	/**
	 *  Specify the axes that are to be controlled by this class
	 * 
	 *  @param axes the axes that are to be controlled by this class
	 */
	public void setAxes(com.jidesoft.chart.axis.Axis[] axes) {
	}

	/**
	 *  The axes that are known by this class
	 * 
	 *  @return the axes
	 */
	public com.jidesoft.chart.axis.Axis[] getAxes() {
	}

	protected void init() {
	}

	/**
	 *  Add an object that is interested in receiving zoom events from this class
	 * 
	 *  @param listener the object to receive zoom notification
	 */
	public void addZoomListener(ZoomListener listener) {
	}

	/**
	 *  Remove a (previously-added) zoom listener from this class
	 * 
	 *  @param listener the object to remove
	 */
	public void removeZoomListener(ZoomListener listener) {
	}

	/**
	 *  Fire a zoom event. This method is called when either of the zoom buttons is pressed.
	 * 
	 *  @param direction the direction of the zoom (<code>in</code> or <code>out</code>)
	 */
	protected void fireZoomAction(ZoomDirection direction) {
	}

	/**
	 *  Specify the text to use on the zoom out button
	 * 
	 *  @param text the text label
	 */
	public void setZoomOutText(String text) {
	}

	/**
	 *  Specify the text to use on the zoom in button
	 * 
	 *  @param text the text label
	 */
	public void setZoomInText(String text) {
	}

	/**
	 *  Specify the icon to use on the zoom out button
	 * 
	 *  @param icon the zoom out icon
	 */
	public void setZoomOutIcon(javax.swing.Icon icon) {
	}

	/**
	 *  Specify the icon to use on the zoom in button
	 * 
	 *  @param icon the zoom in icon
	 */
	public void setZoomInIcon(javax.swing.Icon icon) {
	}
}
